/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.common.ui.wizards.internal;

import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import uk.ac.ed.inf.common.ui.wizards.PassageTimeAnalysisWizard;
import uk.ac.ed.inf.common.ui.wizards.internal.IUpdatable;

public class FileLocationPage
extends WizardPage
implements IUpdatable {
    private Map<String, String> optionMap = null;
    private Text outputFolderWorkspaceLoc = null;

    public FileLocationPage(String pageName) {
        super(pageName);
        this.setTitle("Output Settings");
        this.setDescription("Select location for intermediate PEPA models.");
    }

    public void setWizard(IWizard wizard) {
        super.setWizard(wizard);
        this.optionMap = ((PassageTimeAnalysisWizard)wizard).getOptionMap();
    }

    public void update() {
        if (!this.isControlCreated()) {
            return;
        }
        this.optionMap.put("uk.ac.ed.inf.common.output_dir", ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(this.outputFolderWorkspaceLoc.getText())).getLocation().toOSString());
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout selectionLayout = new GridLayout();
        selectionLayout.numColumns = 1;
        selectionLayout.makeColumnsEqualWidth = false;
        main.setLayout((Layout)selectionLayout);
        this.setControl((Control)main);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileLocationPage.this.updatePage();
            }
        };
        Group dataGroup = new Group(main, 8);
        dataGroup.setText("Output Files");
        dataGroup.setLayoutData((Object)new GridData(768));
        GridLayout dataLayout = new GridLayout(3, false);
        dataGroup.setLayout((Layout)dataLayout);
        this.outputFolderWorkspaceLoc = new Text((Composite)dataGroup, 2048);
        this.outputFolderWorkspaceLoc.setLayoutData((Object)new GridData(768));
        this.outputFolderWorkspaceLoc.addModifyListener(listener);
        Button browseWorkspaceFolder = new Button((Composite)dataGroup, 8);
        browseWorkspaceFolder.setText("Workspace...");
        browseWorkspaceFolder.setLayoutData((Object)new GridData());
        browseWorkspaceFolder.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Object[] resultArray;
                ContainerSelectionDialog d = new ContainerSelectionDialog(FileLocationPage.this.outputFolderWorkspaceLoc.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select directory to save output files to");
                if (d.open() == 0 && (resultArray = d.getResult()).length > 0 && resultArray[0] instanceof Path) {
                    String fileLoc = ((Path)resultArray[0]).toString();
                    FileLocationPage.this.outputFolderWorkspaceLoc.setText(fileLoc);
                }
            }
        });
        this.initialiseComponents();
    }

    private void initialiseComponents() {
        String currentPath = this.optionMap.get("uk.ac.ed.inf.common.output_dir");
        if (currentPath == null) {
            this.outputFolderWorkspaceLoc.setText(((PassageTimeAnalysisWizard)this.getWizard()).getInputFile().getParent().getFullPath().append("tmp").toString());
        } else {
            IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(currentPath));
            if (container != null && container instanceof IFolder) {
                this.outputFolderWorkspaceLoc.setText(container.getFullPath().toString());
            } else {
                this.setErrorMessage("Please select output folder");
                this.setPageComplete(false);
                return;
            }
        }
        this.updatePage();
    }

    private void updatePage() {
        String message = this.validate();
        this.setErrorMessage(message);
        if (message == null) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    private String validate() {
        this.setMessage(null);
        String t = this.outputFolderWorkspaceLoc.getText();
        if (t == null) {
            return "Please specify folder";
        }
        Path path = new Path(t);
        if (!path.isValidPath(t) || path.segmentCount() < 2) {
            return "Please specify folder";
        }
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
        if (!folder.exists()) {
            this.setMessage("Folder does not exist and will be created", 2);
        } else {
            IResource[] members = null;
            try {
                members = folder.members(true);
            }
            catch (CoreException coreException) {
                return "Unable to retrieve this folder's state.Please check that the folder exists and is empty.";
            }
            if (members.length > 0) {
                this.setMessage("Folder is not empty. Folder members will be deleted.", 2);
            }
        }
        return null;
    }
}

