/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui.wizards.export;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import uk.ac.ed.inf.biopepa.core.interfaces.Result;
import uk.ac.ed.inf.biopepa.core.sba.SBAModel;
import uk.ac.ed.inf.biopepa.core.sba.export.SBRMLResultExport;
import uk.ac.ed.inf.biopepa.core.sba.export.SimulationTracer;
import uk.ac.ed.inf.common.ui.plotting.IChart;
import uk.ac.ed.inf.common.ui.plotting.ISemanticElement;
import uk.ac.ed.inf.common.ui.plotting.Plotting;
import uk.ac.ed.inf.common.ui.plotting.data.InfoWithAxes;
import uk.ac.ed.inf.common.ui.plotting.data.Series;
import uk.ac.ed.inf.common.ui.plotview.PlotViewPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulationTraceJob
extends Job {
    private String jobName;
    private SimulationTracer simulationTracer;
    private LinkedList<SimulationTracer.SimulationTraceLog> traceLoggers;
    private boolean doGraph = false;
    private LinkedList<IFile> outputFiles;
    private IFile sbrmlFile;
    private IPath sbrmlPath;
    private SBAModel sbaModel;

    public SimulationTraceJob(String name) {
        super(name);
        this.jobName = name;
        this.outputFiles = new LinkedList();
    }

    public void setSimulationTracer(SimulationTracer st) {
        this.simulationTracer = st;
    }

    public void setSimulationTraceLoggers(LinkedList<SimulationTracer.SimulationTraceLog> slts) {
        this.traceLoggers = slts;
    }

    public void setDoGraph(boolean dg) {
        this.doGraph = dg;
    }

    public void addOutputFile(IFile file) {
        this.outputFiles.add(file);
    }

    public void setSbrmlFile(IFile file) {
        this.sbrmlFile = file;
    }

    public void setSbrmlPath(IPath path) {
        this.sbrmlPath = path;
    }

    public void setSbaModel(SBAModel model) {
        this.sbaModel = model;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.simulationTracer.generateLotsOfTraces(this.traceLoggers);
            if (this.doGraph) {
                Result result = this.simulationTracer.getSimulationResults();
                InfoWithAxes info = new InfoWithAxes();
                List list = info.getYSeries();
                info.setXSeries(Series.create((double[])result.getTimePoints(), (String)"Time"));
                String[] names = result.getComponentNames();
                int i = 0;
                while (i < names.length) {
                    list.add(Series.create((double[])result.getTimeSeries(i), (String)names[i]));
                    ++i;
                }
                info.setShowLegend(true);
                info.setYLabel("Process Count / Variable Value");
                final IChart chart = Plotting.getPlottingTools().createTimeSeriesChart(info);
                class Semantic
                implements ISemanticElement {
                    Semantic() {
                    }

                    public String getDescription(String format) {
                        return "Trace Generation Simulation";
                    }

                    public Object getAdapter(Class arg0) {
                        return null;
                    }
                }
                chart.setSemanticElement((ISemanticElement)new Semantic());
                Runnable runnable = new Runnable(){

                    public void run() {
                        PlotViewPlugin.getDefault().reveal(chart);
                    }
                };
                Display.getDefault().syncExec(runnable);
            }
            if (this.sbrmlFile != null && this.sbaModel != null) {
                Result results = this.simulationTracer.getSimulationResults();
                String filePath = this.sbrmlFile.getLocation().toOSString();
                SBRMLResultExport sbrmlExport = new SBRMLResultExport(this.sbaModel);
                String modelName = this.jobName;
                sbrmlExport.setModelName(modelName);
                sbrmlExport.exportResults(filePath, results);
                this.sbrmlFile.refreshLocal(0, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Status(4, "uk.ac.ed.inf.biopepa.ui", e.getMessage());
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        try {
            for (IFile outputFile : this.outputFiles) {
                if (outputFile == null) continue;
                outputFile.refreshLocal(0, null);
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return new Status(4, "uk.ac.ed.inf.biopepa.ui", e.getMessage());
        }
    }
}

