/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui.wizards.timeseries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import uk.ac.ed.inf.biopepa.core.interfaces.Solver;
import uk.ac.ed.inf.biopepa.core.sba.Parameters;
import uk.ac.ed.inf.biopepa.core.sba.SBAModel;
import uk.ac.ed.inf.biopepa.core.sba.Solvers;
import uk.ac.ed.inf.biopepa.ui.interfaces.BioPEPAModel;
import uk.ac.ed.inf.biopepa.ui.wizards.timeseries.TimeSeriesAnalysisWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgorithmWizardPage
extends WizardPage {
    public static final String name = "Algorithm";
    Listener controlListener;
    HashMap<Control, Parameters.Parameter> controlMap;
    boolean firstUse = true;
    HashSet<Parameters.Parameter> invalidParameters;
    BioPEPAModel model;
    Group optionsGroup;
    Combo solverCombo;
    Composite solverComposite;
    Solver solver;
    Map<Parameters.Parameter, Object> uParameters;
    Parameters parameters;

    protected AlgorithmWizardPage(BioPEPAModel model, Map<Parameters.Parameter, Object> parameters) {
        super(name);
        this.model = model;
        this.controlMap = new HashMap();
        this.invalidParameters = new HashSet();
        this.setTitle("Solver selection and Parameter input");
        this.uParameters = parameters;
        this.setPageComplete(this.solver != null);
    }

    public void algorithmChanged() {
        this.controlMap.clear();
        this.invalidParameters.clear();
        Control[] controlArray = this.optionsGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (!child.isDisposed()) {
                child.dispose();
            }
            ++n2;
        }
        ((TimeSeriesAnalysisWizard)this.getWizard()).solver = this.solver = Solvers.getSolverInstance((String)this.solverCombo.getItem(this.solverCombo.getSelectionIndex()));
        Solver.SolverResponse sr = this.solver.getResponse(this.model.getSBAModel());
        if (sr.getSuitability().equals((Object)Solver.SolverResponse.Suitability.WARNING)) {
            this.setMessage(sr.getMessage(), 1);
        } else {
            this.setMessage(null, 0);
            this.setDescription("Parameters required for the " + this.solver.getDescriptiveName());
        }
        ((TimeSeriesAnalysisWizard)this.getWizard()).parameters = this.parameters = this.solver.getRequiredParameters();
        Parameters.Parameter[] parameterArray = this.parameters.arrayOfKeys();
        int n3 = parameterArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Parameters.Parameter parameter = parameterArray[n4];
            if (!parameter.equals((Object)Parameters.Parameter.Components)) {
                Label label = new Label((Composite)this.optionsGroup, 16384);
                label.setText(parameter.toString());
                Class c = parameter.getType();
                if (Number.class.isAssignableFrom(c)) {
                    String s;
                    Text control = new Text((Composite)this.optionsGroup, 131076);
                    if (this.uParameters.containsKey(parameter)) {
                        s = this.uParameters.get(parameter).toString();
                        this.parameters.setValue(parameter, this.uParameters.get(parameter));
                    } else {
                        s = parameter.getDefault().toString();
                    }
                    control.setText(s);
                    control.addListener(24, this.controlListener);
                    control.setLayoutData((Object)new GridData(768));
                    this.controlMap.put((Control)control, parameter);
                }
            }
            ++n4;
        }
        this.optionsGroup.layout();
        this.solverComposite.layout();
        this.validatePage();
    }

    public void createControl(Composite parent) {
        Set tSet;
        Solver solver;
        this.solverComposite = new Composite(parent, 0);
        this.solverComposite.setLayout((Layout)new FormLayout());
        this.solverCombo = new Combo(this.solverComposite, 8);
        String[] sArray = Solvers.getSolverList();
        ArrayList<String> tArrayList = new ArrayList<String>();
        SBAModel sbaModel = this.model.getSBAModel();
        HashMap disallowed = new HashMap();
        String[] stringArray = sArray;
        int n = sArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            solver = Solvers.getSolverInstance((String)s);
            Solver.SolverResponse sr = solver.getResponse(sbaModel);
            if (!sr.getSuitability().equals((Object)Solver.SolverResponse.Suitability.UNSUITABLE)) {
                tArrayList.add(s);
            } else {
                String message = sr.getMessage();
                if (disallowed.containsKey(message)) {
                    ((Set)disallowed.get(message)).add(s);
                } else {
                    tSet = new HashSet<String>();
                    tSet.add(s);
                    disallowed.put(message, tSet);
                }
            }
            ++n2;
        }
        sArray = tArrayList.toArray(new String[0]);
        this.solverCombo.setItems(sArray);
        solver = ((TimeSeriesAnalysisWizard)this.getWizard()).solver;
        if (solver != null) {
            int i = 0;
            while (i < sArray.length) {
                if (sArray[i].equals(solver.getDescriptiveName())) {
                    this.solverCombo.select(i);
                    break;
                }
                ++i;
            }
        } else {
            this.solverCombo.select(0);
        }
        this.solverCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (AlgorithmWizardPage.this.solverCombo.getSelectionIndex() != -1) {
                    AlgorithmWizardPage.this.algorithmChanged();
                }
            }
        });
        this.optionsGroup = new Group(this.solverComposite, 0);
        this.optionsGroup.setText("Solver Parameters");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.optionsGroup.setLayout((Layout)layout);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                Control control = (Control)event.widget;
                Parameters.Parameter parameter = AlgorithmWizardPage.this.controlMap.get(control);
                try {
                    if (control instanceof Text) {
                        AlgorithmWizardPage.this.parameters.setValue(parameter, (Object)((Text)control).getText());
                        AlgorithmWizardPage.this.uParameters.put(parameter, AlgorithmWizardPage.this.parameters.getValue(parameter));
                    }
                    AlgorithmWizardPage.this.invalidParameters.remove(parameter);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    AlgorithmWizardPage.this.invalidParameters.add(parameter);
                }
                AlgorithmWizardPage.this.validatePage();
            }
        };
        Label text = new Label(this.solverComposite, 64);
        if (!disallowed.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            String term = System.getProperty("line.separator");
            sb.append("Certain solvers are not available due to certain features used within the model.");
            sb.append(" The following are not available:").append(term).append(term);
            for (String s : disallowed.keySet()) {
                sb.append("Reason : ").append(s).append(term);
                tSet = (Set)disallowed.get(s);
                if (tSet.size() > 1) {
                    sb.append("Solvers :").append(term);
                    for (String s2 : tSet) {
                        sb.append("\t\t").append(s2).append(term);
                    }
                    continue;
                }
                sb.append("Solver : ").append((String)tSet.iterator().next()).append(term);
            }
            sb.delete(sb.length() - term.length(), sb.length());
            text.setText(sb.toString());
        }
        this.setMessage("test message", 1);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        this.solverCombo.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.solverCombo);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        this.optionsGroup.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.optionsGroup);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        text.setLayoutData((Object)formData);
        this.setControl((Control)this.solverComposite);
        this.algorithmChanged();
    }

    private void validatePage() {
        if (this.invalidParameters.isEmpty()) {
            this.setPageComplete(true);
            this.setErrorMessage(null);
        } else {
            this.setPageComplete(false);
            this.setErrorMessage("Invalid value entered for " + this.invalidParameters.iterator().next().toString());
        }
    }
}

