/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import uk.ac.ed.inf.biopepa.core.interfaces.Result;
import uk.ac.ed.inf.biopepa.core.sba.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicResult
implements Result {
    protected String simulator = "unknown";
    protected String[] actionNames;
    protected String[] componentNames;
    protected Map<String, Number> modelParameters = new HashMap<String, Number>();
    protected Map<String, Number> uModelParameters = Collections.unmodifiableMap(this.modelParameters);
    protected Map<String, Number> simulatorParameters = new HashMap<String, Number>();
    protected Map<String, Number> uSimulatorParameters = Collections.unmodifiableMap(this.simulatorParameters);
    protected boolean throughput = false;
    protected double[] throughputValues;
    protected double[] timePoints;
    protected double[][] results;
    protected double simulationRunTime;

    public BasicResult(Parameters parameters, Map<String, Number> modelParameters) {
        for (Map.Entry<Parameters.Parameter, Object> entry : parameters.getParameters().entrySet()) {
            if (entry.getKey().equals((Object)Parameters.Parameter.Components) || !(entry.getValue() instanceof Number)) continue;
            this.simulatorParameters.put(entry.getKey().getDescriptiveName(), (Number)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : modelParameters.entrySet()) {
            this.modelParameters.put((String)entry.getKey(), (Number)entry.getValue());
        }
    }

    public BasicResult() {
    }

    public void setSimulator(String sim) {
        this.simulator = sim;
    }

    public void setTimePoints(double[] times) {
        this.timePoints = times;
    }

    public void setResults(double[][] results) {
        this.results = results;
    }

    @Override
    public String[] getActionNames() {
        if (this.actionNames == null) {
            return new String[0];
        }
        return (String[])this.actionNames.clone();
    }

    @Override
    public double getActionThroughput(int index) {
        return this.throughputValues[index];
    }

    public void setComponentNames(String[] names) {
        this.componentNames = names;
    }

    @Override
    public String[] getComponentNames() {
        if (this.componentNames == null) {
            return new String[0];
        }
        return (String[])this.componentNames.clone();
    }

    @Override
    public Map<String, Number> getModelParameters() {
        return this.uModelParameters;
    }

    @Override
    public double getPopulation(int index) {
        return this.results[index][this.results[0].length - 1];
    }

    @Override
    public String getSimulatorName() {
        return this.simulator;
    }

    @Override
    public Map<String, Number> getSimulatorParameters() {
        return this.uSimulatorParameters;
    }

    @Override
    public double[] getTimeSeries(int index) {
        return this.results[index];
    }

    @Override
    public boolean throughputSupported() {
        return this.throughput;
    }

    @Override
    public double[] getTimePoints() {
        return this.timePoints;
    }

    @Override
    public void setSimulationRunTime(double s) {
        this.simulationRunTime = s;
    }

    @Override
    public double getSimulationRunTime() {
        return this.simulationRunTime;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void normaliseResult(double[] newTimePoints) {
        newResults = new double[this.componentNames.length][];
        index = 0;
        while (index < this.componentNames.length) {
            newResults[index] = new double[newTimePoints.length];
            ++index;
        }
        newThroughput = null;
        if (this.throughput) {
            newThroughput = new double[newTimePoints.length];
        }
        oldIndex = 0;
        newIndex = 0;
        ** GOTO lbl24
        {
            ++oldIndex;
            do {
                if (this.timePoints[oldIndex] < newTimePoints[newIndex] && oldIndex < this.timePoints.length) continue block1;
                nameIndex = 0;
                while (nameIndex < this.componentNames.length) {
                    newResults[nameIndex][newIndex] = this.results[nameIndex][oldIndex];
                    ++nameIndex;
                }
                if (this.throughput) {
                    newThroughput[newIndex] = this.throughputValues[oldIndex];
                }
                ++newIndex;
lbl24:
                // 2 sources

            } while (newIndex < newTimePoints.length);
        }
        this.results = newResults;
        this.timePoints = newTimePoints;
        if (this.throughput) {
            this.throughputValues = newThroughput;
        }
    }

    private double[] concatenateDoubleArrays(double[] a1, double[] a2, int offset) {
        double[] result = new double[a1.length + a2.length - offset];
        int index = 0;
        while (index < a1.length) {
            result[index] = a1[index];
            ++index;
        }
        index = offset;
        while (index < a2.length) {
            result[index + a1.length - offset] = a2[index];
            ++index;
        }
        return result;
    }

    @Override
    public void concatenateResults(Result result) {
        double[] extraTimePoints = result.getTimePoints();
        double[] additionalTimePoints = new double[extraTimePoints.length];
        double lastCurrent = this.timePoints[this.timePoints.length - 1];
        int index = 0;
        while (index < additionalTimePoints.length) {
            additionalTimePoints[index] = lastCurrent + extraTimePoints[index];
            ++index;
        }
        double[] newTimePoints = this.concatenateDoubleArrays(this.timePoints, additionalTimePoints, 1);
        this.timePoints = newTimePoints;
        double[][] newResults = new double[this.results.length][];
        int index2 = 0;
        while (index2 < newResults.length) {
            newResults[index2] = this.concatenateDoubleArrays(this.results[index2], result.getTimeSeries(index2), 1);
            ++index2;
        }
        this.results = newResults;
        if (this.throughput && result.throughputSupported()) {
            index2 = 0;
            while (index2 < this.throughputValues.length) {
                this.throughputValues[index2] = result.getActionThroughput(index2);
                ++index2;
            }
        }
        this.simulationRunTime += result.getSimulationRunTime();
    }
}

