/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.ed.inf.biopepa.core.compiler.ComponentData;
import uk.ac.ed.inf.biopepa.core.compiler.ComponentNode;
import uk.ac.ed.inf.biopepa.core.compiler.CooperationNode;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.PrefixData;
import uk.ac.ed.inf.biopepa.core.compiler.ProblemInfo;
import uk.ac.ed.inf.biopepa.core.compiler.ProblemKind;
import uk.ac.ed.inf.biopepa.core.compiler.SystemEquationNode;
import uk.ac.ed.inf.biopepa.core.compiler.TransportData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionCooperationAnalysis {
    private ModelCompiler compiledModel;
    private List<ProblemInfo> problems = new ArrayList<ProblemInfo>();
    private SystemEquationVisitor sev = new SystemEquationVisitor();

    ActionCooperationAnalysis() {
    }

    static List<ProblemInfo> checkActions(ModelCompiler compiledModel) {
        ActionCooperationAnalysis aca = new ActionCooperationAnalysis();
        aca.compiledModel = compiledModel;
        aca.sev.visit(compiledModel.getSystemEquation());
        return aca.problems;
    }

    private class Actions {
        Set<String> actions = new HashSet<String>();
        Set<String> transportations = new HashSet<String>();

        private Actions() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SystemEquationVisitor {
        Map<ComponentData, Set<String>> found = new HashMap<ComponentData, Set<String>>();

        private SystemEquationVisitor() {
        }

        private Map<ComponentNode, Actions> visit(SystemEquationNode node) {
            if (node instanceof ComponentNode) {
                return this.visit((ComponentNode)node);
            }
            if (node instanceof CooperationNode) {
                return this.visit((CooperationNode)node);
            }
            throw new IllegalArgumentException("Unrecognised subclass of SystemEquationNode.");
        }

        private Map<ComponentNode, Actions> visit(CooperationNode node) {
            Map<ComponentNode, Actions> left = this.visit(node.getLeft());
            Map<ComponentNode, Actions> right = this.visit(node.getRight());
            HashSet<String> coopSet = new HashSet<String>();
            String[] stringArray = node.getActions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                coopSet.add(s);
                ++n2;
            }
            boolean wildcard = coopSet.size() == 1 && coopSet.contains("*");
            for (ComponentNode leftCN : left.keySet()) {
                Actions leftActions = left.get(leftCN);
                for (ComponentNode rightCN : right.keySet()) {
                    HashSet<String> tSet;
                    String s;
                    ComponentData cd;
                    Actions rightActions = right.get(rightCN);
                    for (String transport : leftActions.transportations) {
                        if (!wildcard && !coopSet.contains(transport)) continue;
                        if (rightActions.transportations.contains(transport) && !leftCN.getComponent().equals(rightCN.getComponent())) {
                            cd = ActionCooperationAnalysis.this.compiledModel.getComponentData(leftCN.getComponent());
                            s = String.valueOf(ProblemKind.INVALID_TRANSPORTATION_COOPERATION.getMessage()) + " " + leftCN.getName() + " and " + rightCN.getName() + " over " + transport;
                            if (!this.found.containsKey(cd)) {
                                tSet = new HashSet();
                                tSet.add(s);
                                this.found.put(cd, tSet);
                                ActionCooperationAnalysis.this.problems.add(new ProblemInfo(s, cd));
                            } else if (!this.found.get(cd).contains(s)) {
                                this.found.get(cd).add(s);
                                ActionCooperationAnalysis.this.problems.add(new ProblemInfo(s, cd));
                            }
                            cd = ActionCooperationAnalysis.this.compiledModel.getComponentData(rightCN.getComponent());
                            s = String.valueOf(ProblemKind.INVALID_TRANSPORTATION_COOPERATION.getMessage()) + " " + rightCN.getName() + " and " + leftCN.getName() + " over " + transport;
                            if (!this.found.containsKey(cd)) {
                                tSet = new HashSet();
                                tSet.add(s);
                                this.found.put(cd, tSet);
                                ActionCooperationAnalysis.this.problems.add(new ProblemInfo(s, cd));
                                continue;
                            }
                            if (this.found.get(cd).contains(s)) continue;
                            this.found.get(cd).add(s);
                            ActionCooperationAnalysis.this.problems.add(new ProblemInfo(s, cd));
                            continue;
                        }
                        if (!rightActions.actions.contains(transport)) continue;
                        cd = ActionCooperationAnalysis.this.compiledModel.getComponentData(rightCN.getComponent());
                        s = "Illegal cooperation by " + rightCN.getComponent() + " on " + transport + " action. Cannot cooperate with transportation in species " + leftCN.getComponent() + ".";
                        if (!this.found.containsKey(cd)) {
                            tSet = new HashSet<String>();
                            tSet.add(s);
                            this.found.put(cd, tSet);
                            ActionCooperationAnalysis.this.problems.add(new ProblemInfo(s, cd));
                            continue;
                        }
                        if (this.found.get(cd).contains(s)) continue;
                        this.found.get(cd).add(s);
                        ActionCooperationAnalysis.this.problems.add(new ProblemInfo(s, cd));
                    }
                    for (String transport : rightActions.transportations) {
                        if (!wildcard && !coopSet.contains(transport) || !leftActions.actions.contains(transport)) continue;
                        cd = ActionCooperationAnalysis.this.compiledModel.getComponentData(leftCN.getComponent());
                        s = "Illegal cooperation by " + leftCN.getComponent() + " on " + transport + " action. Cannot cooperate with transportation in species " + rightCN.getComponent() + ".";
                        if (!this.found.containsKey(cd)) {
                            tSet = new HashSet();
                            tSet.add(s);
                            this.found.put(cd, tSet);
                            ActionCooperationAnalysis.this.problems.add(new ProblemInfo(s, cd));
                            continue;
                        }
                        if (this.found.get(cd).contains(s)) continue;
                        this.found.get(cd).add(s);
                        ActionCooperationAnalysis.this.problems.add(new ProblemInfo(s, cd));
                    }
                }
            }
            left.putAll(right);
            return left;
        }

        private Map<ComponentNode, Actions> visit(ComponentNode node) {
            ComponentData cd = ActionCooperationAnalysis.this.compiledModel.getComponentData(node.getComponent());
            Actions actions2 = new Actions();
            PrefixData[] prefixDataArray = cd.getPrefixes();
            int n = prefixDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                PrefixData pd = prefixDataArray[n2];
                if (pd instanceof TransportData) {
                    actions2.transportations.add(pd.getFunction());
                } else {
                    actions2.actions.add(pd.getFunction());
                }
                ++n2;
            }
            HashMap<ComponentNode, Actions> map = new HashMap<ComponentNode, Actions>();
            map.put(node, actions2);
            return map;
        }
    }
}

