/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.compiler.ActionData;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledFunction;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.PrefixData;
import uk.ac.ed.inf.biopepa.core.compiler.ProblemInfo;
import uk.ac.ed.inf.biopepa.core.compiler.TransportData;
import uk.ac.ed.inf.biopepa.core.dom.AST;
import uk.ac.ed.inf.biopepa.core.dom.Component;
import uk.ac.ed.inf.biopepa.core.dom.Cooperation;
import uk.ac.ed.inf.biopepa.core.dom.DoNothingVisitor;
import uk.ac.ed.inf.biopepa.core.dom.Expression;
import uk.ac.ed.inf.biopepa.core.dom.ExpressionStatement;
import uk.ac.ed.inf.biopepa.core.dom.FunctionCall;
import uk.ac.ed.inf.biopepa.core.dom.InfixExpression;
import uk.ac.ed.inf.biopepa.core.dom.LocatedName;
import uk.ac.ed.inf.biopepa.core.dom.Model;
import uk.ac.ed.inf.biopepa.core.dom.Name;
import uk.ac.ed.inf.biopepa.core.dom.Prefix;
import uk.ac.ed.inf.biopepa.core.dom.PropertyInitialiser;
import uk.ac.ed.inf.biopepa.core.dom.PropertyLiteral;
import uk.ac.ed.inf.biopepa.core.dom.Statement;
import uk.ac.ed.inf.biopepa.core.dom.UnsupportedVisitor;
import uk.ac.ed.inf.biopepa.core.dom.VariableDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredefinedLaws {
    private static Map<String, FunctionCall> functionMap = new HashMap<String, FunctionCall>();
    private static List<ProblemInfo> problems = new ArrayList<ProblemInfo>();
    private static ExpressionVisitor expressionVisitor = new ExpressionVisitor();
    private static EquationVisitor equationVisitor = new EquationVisitor();

    static List<ProblemInfo> checkPredefinedLaws(Model model, ModelCompiler compiledModel) {
        ExpressionStatement systemEquation = null;
        functionMap.clear();
        problems.clear();
        for (Statement statement : model.statements()) {
            if (statement instanceof VariableDeclaration) {
                VariableDeclaration vd = (VariableDeclaration)statement;
                if (!vd.getKind().equals((Object)VariableDeclaration.Kind.FUNCTION)) continue;
                try {
                    expressionVisitor.scan(vd.getRightHandSide());
                }
                catch (BioPEPAException e) {
                    problems.add(new ProblemInfo(e.getMessage(), vd.getRightHandSide().getSourceRange()));
                    continue;
                }
                if (PredefinedLaws.expressionVisitor.functionsFound.size() > 1) {
                    int i = 0;
                    for (FunctionCall fc : PredefinedLaws.expressionVisitor.functionsFound) {
                        CompiledFunction.Function f = CompiledFunction.getFunction(fc.getName().getIdentifier());
                        if (!f.isRateLaw()) continue;
                        ++i;
                    }
                    if (i <= true) continue;
                    problems.add(new ProblemInfo("Embedded function call", vd.getRightHandSide().getSourceRange()));
                    continue;
                }
                if (PredefinedLaws.expressionVisitor.functionsFound.size() != 1) continue;
                functionMap.put(vd.getName().getIdentifier(), PredefinedLaws.expressionVisitor.functionsFound.get(0));
                continue;
            }
            if (!(statement instanceof ExpressionStatement)) continue;
            systemEquation = (ExpressionStatement)statement;
        }
        PredefinedLaws.equationVisitor.model = compiledModel;
        try {
            systemEquation.accept(equationVisitor);
        }
        catch (BioPEPAException bioPEPAException) {
            problems.add(new ProblemInfo(bioPEPAException.getMessage(), systemEquation.getSourceRange()));
            return problems;
        }
        block6: for (Map.Entry entry : functionMap.entrySet()) {
            if (!PredefinedLaws.equationVisitor.map.containsKey(entry.getKey())) continue;
            FunctionCall fc = (FunctionCall)entry.getValue();
            String s = fc.getName().getIdentifier();
            CompiledFunction.Function f = CompiledFunction.getFunction(fc.getName().getIdentifier());
            for (int[] iArray : PredefinedLaws.equationVisitor.map.get(entry.getKey())) {
                if (!f.isRateLaw() || PredefinedLaws.match(s, iArray)) continue;
                problems.add(new ProblemInfo("Predefined function does not have the correct number of components with required behaviours", ((FunctionCall)entry.getValue()).getSourceRange()));
                continue block6;
            }
        }
        return problems;
    }

    private static int[] merge(int[] one, int[] two) {
        int[] iArray = new int[one.length];
        int i = 0;
        while (i < one.length) {
            iArray[i] = one[i] + two[i];
            ++i;
        }
        return iArray;
    }

    private static boolean match(String fName, int[] count) {
        if (AST.Literals.MASS_ACTION.toString().equals(fName)) {
            return count[0] + count[4] > 0 && count[2] == 0;
        }
        if (AST.Literals.MICHAELIS_MENTEN.toString().equals(fName)) {
            return count[0] == 1 && count[1] == 1 && count[2] == 0 && count[3] == 0 && count[4] == 1;
        }
        if (AST.Literals.COMPETITIVE_INHIBITION.toString().equals(fName)) {
            return count[0] == 1 && count[1] == 1 && count[2] == 1 && count[3] == 0 && count[4] == 1;
        }
        return false;
    }

    private static class EquationVisitor
    extends UnsupportedVisitor {
        Map<String, List<int[]>> map;
        ModelCompiler model;
        String s;

        private EquationVisitor() {
        }

        public boolean visit(ExpressionStatement statement) throws BioPEPAException {
            statement.getExpression().accept(this);
            return true;
        }

        public boolean visit(Component component) throws BioPEPAException {
            String sn;
            this.map = new HashMap<String, List<int[]>>();
            String ln = null;
            Name n = component.getName();
            boolean source = false;
            if (n instanceof LocatedName) {
                sn = ((LocatedName)n).getName();
                ln = ((LocatedName)n).getLocations().names().get(0).getIdentifier();
            } else {
                sn = n.getIdentifier();
            }
            PrefixData[] prefixDataArray = this.model.getComponentData(sn).getPrefixes();
            int n2 = prefixDataArray.length;
            int n3 = 0;
            while (n3 < n2) {
                block18: {
                    PrefixData pd;
                    block16: {
                        block19: {
                            block17: {
                                pd = prefixDataArray[n3];
                                if (ln == null) break block16;
                                if (!(pd instanceof ActionData)) break block17;
                                List<String> locations = ((ActionData)pd).getLocations();
                                if (locations.size() <= 0 || locations.contains(ln)) break block16;
                                break block18;
                            }
                            if (!(pd instanceof TransportData)) break block16;
                            if (!((TransportData)pd).getSourceLocation().equals(ln)) break block19;
                            source = true;
                            break block16;
                        }
                        if (!((TransportData)pd).getTargetLocation().equals(ln)) break block18;
                        source = false;
                    }
                    this.s = pd.getFunction();
                    int[] i = new int[5];
                    switch (pd.getOperator()) {
                        case REACTANT: {
                            i[0] = 1;
                            break;
                        }
                        case ACTIVATOR: {
                            i[1] = 1;
                            break;
                        }
                        case INHIBITOR: {
                            i[2] = 1;
                            break;
                        }
                        case GENERIC: {
                            i[3] = 1;
                            break;
                        }
                        case PRODUCT: {
                            i[4] = 1;
                            break;
                        }
                        case UNI_TRANSPORTATION: {
                            i[0] = source ? 1 : 0;
                            i[4] = source ? 0 : 1;
                        }
                        case BI_TRANSPORTATION: {
                            i[0] = 1;
                            i[4] = 1;
                            break;
                        }
                        default: {
                            throw new BioPEPAException("Unsupported Bio-PEPA operator.");
                        }
                    }
                    if (!this.map.containsKey(this.s)) {
                        this.map.put(this.s, new ArrayList());
                    }
                    this.map.get(this.s).add(i);
                }
                ++n3;
            }
            return true;
        }

        public boolean visit(Cooperation cooperation) throws BioPEPAException {
            List<Name> tActions = cooperation.getActionSet().names();
            cooperation.getLeftHandSide().accept(this);
            Map<String, List<int[]>> left = this.map;
            cooperation.getRightHandSide().accept(this);
            if (tActions.size() == 1 && tActions.get(0).getIdentifier().equals("*")) {
                for (Map.Entry<String, List<int[]>> entry : left.entrySet()) {
                    this.s = entry.getKey();
                    if (this.map.containsKey(this.s)) {
                        ArrayList<int[]> l = new ArrayList<int[]>();
                        for (int[] i1 : entry.getValue()) {
                            for (int[] i2 : this.map.get(this.s)) {
                                l.add(PredefinedLaws.merge(i1, i2));
                            }
                        }
                        this.map.put(this.s, l);
                        continue;
                    }
                    this.map.put(this.s, entry.getValue());
                }
                return true;
            }
            for (Expression expression : tActions) {
                this.s = ((Name)expression).getIdentifier();
                if (!left.containsKey(this.s) || !this.map.containsKey(this.s)) continue;
                ArrayList<int[]> l = new ArrayList<int[]>();
                for (int[] i1 : left.remove(this.s)) {
                    for (int[] i2 : this.map.get(this.s)) {
                        l.add(PredefinedLaws.merge(i1, i2));
                    }
                }
                this.map.put(this.s, l);
            }
            for (Map.Entry entry : left.entrySet()) {
                if (this.map.containsKey(entry.getKey())) {
                    this.map.get(entry.getKey()).addAll((Collection)entry.getValue());
                    continue;
                }
                this.map.put((String)entry.getKey(), (List)entry.getValue());
            }
            return true;
        }

        public boolean visit(Name name) throws BioPEPAException {
            name.getBinding().getVariableDeclaration().getRightHandSide().accept(this);
            return true;
        }
    }

    private static class ExpressionVisitor
    extends DoNothingVisitor {
        List<FunctionCall> functionsFound = new ArrayList<FunctionCall>();

        private ExpressionVisitor() {
        }

        public void scan(Expression expression) throws BioPEPAException {
            this.functionsFound.clear();
            expression.accept(this);
        }

        public boolean visit(Cooperation cooperation) throws BioPEPAException {
            throw new BioPEPAException("Unexpected cooperation");
        }

        public boolean visit(FunctionCall functionCall) throws BioPEPAException {
            this.functionsFound.add(functionCall);
            for (Expression e : functionCall.arguments()) {
                e.accept(this);
            }
            return true;
        }

        public boolean visit(InfixExpression infixExpression) throws BioPEPAException {
            infixExpression.getLeftHandSide().accept(this);
            infixExpression.getRightHandSide().accept(this);
            return true;
        }

        public boolean visit(Prefix prefix) throws BioPEPAException {
            throw new BioPEPAException("Unexpected prefix");
        }

        public boolean visit(PropertyInitialiser propertyInitialiser) throws BioPEPAException {
            throw new BioPEPAException("Unexpected property initialiser");
        }

        public boolean visit(PropertyLiteral propertyLiteral) throws BioPEPAException {
            throw new BioPEPAException("Unexpected property literal");
        }
    }
}

