/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import uk.ac.ed.inf.biopepa.core.compiler.ActionData;
import uk.ac.ed.inf.biopepa.core.compiler.CompartmentData;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledDynamicComponent;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpression;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpressionVisitor;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledFunction;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledNumber;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledOperatorNode;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledSystemVariable;
import uk.ac.ed.inf.biopepa.core.compiler.ComponentData;
import uk.ac.ed.inf.biopepa.core.compiler.ComponentNode;
import uk.ac.ed.inf.biopepa.core.compiler.CooperationNode;
import uk.ac.ed.inf.biopepa.core.compiler.FunctionalRateData;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.PrefixData;
import uk.ac.ed.inf.biopepa.core.compiler.ProblemInfo;
import uk.ac.ed.inf.biopepa.core.compiler.SystemEquationNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReactantRateParticipationCheck {
    private ModelCompiler compiledModel;
    private SystemEquationVisitor sev = new SystemEquationVisitor();
    private ReactantParticipantVisitor rrp = new ReactantParticipantVisitor();
    private List<ProblemInfo> problems = new ArrayList<ProblemInfo>();

    private ReactantRateParticipationCheck() {
    }

    static List<ProblemInfo> checkActions(ModelCompiler compiledModel) {
        ReactantRateParticipationCheck rrpc = new ReactantRateParticipationCheck();
        rrpc.compiledModel = compiledModel;
        rrpc.sev.visit(compiledModel.getSystemEquation());
        rrpc.checkExternalParticipants();
        return rrpc.problems;
    }

    public void checkExternalParticipants() {
        HashMap<FunctionalRateData, HashSet<String>> actionMap = new HashMap<FunctionalRateData, HashSet<String>>();
        Map<String, FunctionalRateData> frdMap = this.compiledModel.getFunctionalRateMap();
        for (Map.Entry<String, FunctionalRateData> entry : frdMap.entrySet()) {
            FunctionalRateData rateData = entry.getValue();
            ExternalParticipationVisitor epv = new ExternalParticipationVisitor();
            rateData.getRightHandSide().accept(epv);
            actionMap.put(rateData, epv.getParticipants());
        }
        for (ComponentData compdata : this.compiledModel.getComponents()) {
            HashSet<String> isReactants = this.componentReactantReactions(compdata);
            for (Map.Entry entry : actionMap.entrySet()) {
                FunctionalRateData rateData = (FunctionalRateData)entry.getKey();
                String reactionName = rateData.getName();
                String compName = compdata.getName();
                if (!((HashSet)entry.getValue()).contains(compName) || isReactants.contains(reactionName)) continue;
                ProblemInfo pi = new ProblemInfo("The component " + compName + " affects the rate of the reaction " + reactionName + " but is not a reactant", compdata);
                pi.severity = ProblemInfo.Severity.WARNING;
                this.problems.add(pi);
            }
        }
    }

    private HashSet<String> componentReactantReactions(ComponentData cd) {
        HashSet<String> reactions = new HashSet<String>();
        PrefixData[] prefixDataArray = cd.getPrefixes();
        int n = prefixDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionData actionData;
            PrefixData.Operator operator;
            PrefixData prefix = prefixDataArray[n2];
            if (prefix instanceof ActionData && ((operator = (actionData = (ActionData)prefix).getOperator()).equals((Object)PrefixData.Operator.REACTANT) || operator.equals((Object)PrefixData.Operator.ACTIVATOR) || operator.equals((Object)PrefixData.Operator.INHIBITOR) || operator.equals((Object)PrefixData.Operator.GENERIC))) {
                reactions.add(actionData.getFunction());
            }
            ++n2;
        }
        return reactions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExternalParticipationVisitor
    extends CompiledExpressionVisitor {
        HashSet<String> participants = new HashSet();

        ExternalParticipationVisitor() {
        }

        public HashSet<String> getParticipants() {
            return this.participants;
        }

        @Override
        public boolean visit(CompiledDynamicComponent component) {
            this.participants.add(component.getName());
            return false;
        }

        @Override
        public boolean visit(CompiledFunction function) {
            for (CompiledExpression ce : function.getArguments()) {
                ce.accept(this);
            }
            return false;
        }

        @Override
        public boolean visit(CompiledNumber number) {
            return false;
        }

        @Override
        public boolean visit(CompiledOperatorNode operator) {
            CompiledExpression left = operator.getLeft();
            CompiledExpression right = operator.getRight();
            if (left != null) {
                left.accept(this);
            }
            if (right != null) {
                right.accept(this);
            }
            return false;
        }

        @Override
        public boolean visit(CompiledSystemVariable variable) {
            return false;
        }
    }

    private class ReactantParticipantVisitor
    extends CompiledExpressionVisitor {
        String reactant;

        private ReactantParticipantVisitor() {
        }

        public boolean visit(CompiledDynamicComponent component) {
            return component.getName().equals(this.reactant);
        }

        public boolean visit(CompiledFunction function) {
            boolean found = false;
            for (CompiledExpression ce : function.getArguments()) {
                boolean bl = found = found || ce.accept(this);
            }
            return found;
        }

        public boolean visit(CompiledNumber number) {
            return false;
        }

        public boolean visit(CompiledOperatorNode operator) {
            CompiledExpression left = operator.getLeft();
            CompiledExpression right = operator.getRight();
            boolean leftBool = false;
            boolean rightBool = false;
            if (left != null) {
                leftBool = left.accept(this);
            }
            if (right != null) {
                rightBool = right.accept(this);
            }
            return leftBool || rightBool;
        }

        public boolean visit(CompiledSystemVariable variable) {
            return false;
        }
    }

    private class SystemEquationVisitor {
        private SystemEquationVisitor() {
        }

        void visit(SystemEquationNode node) {
            if (node instanceof ComponentNode) {
                this.visit((ComponentNode)node);
            } else if (node instanceof CooperationNode) {
                this.visit(((CooperationNode)node).getLeft());
                this.visit(((CooperationNode)node).getRight());
            } else {
                throw new IllegalArgumentException("Unrecognised subclass of SystemEquationNode.");
            }
        }

        void visit(ComponentNode node) {
            ComponentData cd = ReactantRateParticipationCheck.this.compiledModel.getComponentData(node.getComponent());
            CompartmentData compartmentData = node.getCompartment();
            PrefixData[] prefixDataArray = cd.getPrefixes();
            int n = prefixDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionData ad;
                PrefixData pd = prefixDataArray[n2];
                if (pd instanceof ActionData && (ad = (ActionData)pd).getOperator().equals((Object)PrefixData.Operator.REACTANT)) {
                    ProblemInfo pi;
                    FunctionalRateData frd = ReactantRateParticipationCheck.this.compiledModel.getFunctionalRate(pd.getFunction());
                    if (frd == null) {
                        pi = new ProblemInfo("The rate " + pd.getFunction() + " is not defined but used in " + node.toString(), pd);
                        ReactantRateParticipationCheck.this.problems.add(pi);
                    } else if (!frd.isPredefinedLaw() && (ad.getLocations().size() == 0 || compartmentData == null || ad.getLocations().contains(compartmentData.getName()))) {
                        ((ReactantRateParticipationCheck)ReactantRateParticipationCheck.this).rrp.reactant = node.getName();
                        if (!frd.getRightHandSide().accept(ReactantRateParticipationCheck.this.rrp)) {
                            pi = new ProblemInfo("The rate " + pd.getFunction() + " does not rely on " + ((ReactantRateParticipationCheck)ReactantRateParticipationCheck.this).rrp.reactant + ". Population count could decrease below zero.", pd);
                            pi.severity = ProblemInfo.Severity.WARNING;
                            ReactantRateParticipationCheck.this.problems.add(pi);
                        }
                    }
                }
                ++n2;
            }
        }
    }
}

