/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.analysis;

import java.util.HashSet;
import java.util.Set;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledDynamicComponent;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpression;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpressionVisitor;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledFunction;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledNumber;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledOperatorNode;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledSystemVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReactantsParticipantsVisitor
extends CompiledExpressionVisitor {
    private boolean reactantsInvolved = false;
    private HashSet<String> externalParticipants = new HashSet();

    public Set<String> getExternalParticipants() {
        return this.externalParticipants;
    }

    public boolean getReactantsInvolved() {
        return this.reactantsInvolved;
    }

    @Override
    public boolean visit(CompiledDynamicComponent component) {
        this.externalParticipants.add(component.getName());
        return false;
    }

    @Override
    public boolean visit(CompiledFunction function) {
        if (function.getFunction().isRateLaw()) {
            this.reactantsInvolved = true;
        }
        for (CompiledExpression ce : function.getArguments()) {
            ce.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(CompiledNumber number) {
        return false;
    }

    @Override
    public boolean visit(CompiledOperatorNode operator) {
        CompiledExpression left = operator.getLeft();
        CompiledExpression right = operator.getRight();
        if (left != null) {
            left.accept(this);
        }
        if (right != null) {
            right.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(CompiledSystemVariable variable) {
        return false;
    }
}

