/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.compiler;

import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.compiler.CompilerException;
import uk.ac.ed.inf.biopepa.core.compiler.Data;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.ProblemKind;
import uk.ac.ed.inf.biopepa.core.dom.PropertyInitialiser;
import uk.ac.ed.inf.biopepa.core.dom.VariableDeclaration;

public abstract class AbstractDefinitionCompiler {
    protected VariableDeclaration dec;
    protected ModelCompiler compiler;
    protected VariableDeclaration.Kind kind;

    public AbstractDefinitionCompiler(ModelCompiler compiler, VariableDeclaration.Kind kind, VariableDeclaration dec) {
        if (compiler == null || dec == null || dec.getKind() != kind) {
            throw new IllegalArgumentException();
        }
        this.dec = dec;
        this.compiler = compiler;
    }

    final Data getData() throws BioPEPAException {
        String name = this.dec.getName().getIdentifier();
        if (name == null) {
            throw new IllegalArgumentException("Declaration does not contain left hand side");
        }
        if (!(this.kind != VariableDeclaration.Kind.CONTAINER && this.kind != VariableDeclaration.Kind.SPECIES || this.dec.getRightHandSide() instanceof PropertyInitialiser)) {
            throw new IllegalArgumentException("Expected a PropertyInitialiser");
        }
        if (this.hasDuplicates(name)) {
            this.compiler.problemRequestor.accept(ProblemKind.DUPLICATE_USAGE, this.dec);
            throw new CompilerException();
        }
        return this.doGetData();
    }

    protected boolean hasDuplicates(String name) {
        return this.compiler.containsAnyDeclaration(name);
    }

    protected abstract Data doGetData() throws BioPEPAException;
}

