/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.compiler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uk.ac.ed.inf.biopepa.core.compiler.ActionData;
import uk.ac.ed.inf.biopepa.core.compiler.ComponentData;
import uk.ac.ed.inf.biopepa.core.compiler.ComponentNode;
import uk.ac.ed.inf.biopepa.core.compiler.CooperationNode;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.PrefixData;
import uk.ac.ed.inf.biopepa.core.compiler.SystemEquationNode;
import uk.ac.ed.inf.biopepa.core.compiler.TransportData;

class ActionSetCompiler {
    private ModelCompiler model;
    private Set<String> actionSet;
    private String[] sArray;

    ActionSetCompiler(ModelCompiler model) {
        this.model = model;
    }

    void computeWildCardSets() {
        this.traverse(this.model.getSystemEquation());
    }

    private void traverse(SystemEquationNode systemEquationNode) {
        if (systemEquationNode instanceof ComponentNode) {
            this.traverse((ComponentNode)systemEquationNode);
        } else if (systemEquationNode instanceof CooperationNode) {
            this.traverse((CooperationNode)systemEquationNode);
        }
    }

    private void traverse(ComponentNode componentNode) {
        ComponentData cd = this.model.getComponentData(componentNode.getComponent());
        this.actionSet = new HashSet<String>();
        PrefixData[] prefixDataArray = cd.getPrefixes();
        int n = prefixDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            String location;
            PrefixData pd = prefixDataArray[n2];
            if (pd instanceof ActionData) {
                List<String> locations = ((ActionData)pd).getLocations();
                if (locations.size() == 0) {
                    this.actionSet.add(pd.function);
                } else {
                    location = componentNode.getCompartment().getName();
                    for (String s : locations) {
                        if (!location.equals(s)) continue;
                        this.actionSet.add(pd.function);
                        break;
                    }
                }
            } else if (pd instanceof TransportData) {
                TransportData td = (TransportData)pd;
                location = componentNode.getCompartment().getName();
                if (location.equals(td.getSourceLocation()) || location.equals(td.getTargetLocation())) {
                    this.actionSet.add(pd.function);
                }
            }
            ++n2;
        }
    }

    private void traverse(CooperationNode cooperationNode) {
        this.traverse(cooperationNode.getLeft());
        Set<String> leftSet = this.actionSet;
        this.traverse(cooperationNode.getRight());
        this.sArray = cooperationNode.getActions();
        if (this.sArray.length == 1 && this.sArray[0].equals("*")) {
            ArrayList<String> al = new ArrayList<String>();
            for (String s : leftSet) {
                if (!this.actionSet.contains(s)) continue;
                al.add(s);
                this.model.checkAndGetFunctionalRate(s);
            }
            cooperationNode.setActions(al.toArray(new String[0]));
        }
        this.actionSet.addAll(leftSet);
    }
}

