/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.compiler;

import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.compiler.AbstractDefinitionCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.CompartmentData;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledNumber;
import uk.ac.ed.inf.biopepa.core.compiler.CompilerException;
import uk.ac.ed.inf.biopepa.core.compiler.Data;
import uk.ac.ed.inf.biopepa.core.compiler.ExpressionEvaluatorVisitor;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.ProblemKind;
import uk.ac.ed.inf.biopepa.core.compiler.PropertySetterException;
import uk.ac.ed.inf.biopepa.core.dom.Expression;
import uk.ac.ed.inf.biopepa.core.dom.InfixExpression;
import uk.ac.ed.inf.biopepa.core.dom.LocatedName;
import uk.ac.ed.inf.biopepa.core.dom.Name;
import uk.ac.ed.inf.biopepa.core.dom.PropertyInitialiser;
import uk.ac.ed.inf.biopepa.core.dom.PropertyLiteral;
import uk.ac.ed.inf.biopepa.core.dom.VariableDeclaration;

public class CompartmentCompiler
extends AbstractDefinitionCompiler {
    public CompartmentCompiler(ModelCompiler compiler, VariableDeclaration dec) {
        super(compiler, VariableDeclaration.Kind.CONTAINER, dec);
    }

    private CompartmentData getCompartmentData() throws BioPEPAException {
        CompartmentData data;
        PropertyInitialiser init = (PropertyInitialiser)this.dec.getRightHandSide();
        Name name = this.dec.getName();
        if (name instanceof LocatedName) {
            LocatedName ln = (LocatedName)name;
            if (ln.getLocations().names().size() > 1) {
                this.compiler.problemRequestor.accept(ProblemKind.INVALID_NUMBER_OF_LOCATIONS, name);
                throw new CompilerException();
            }
            data = new CompartmentData(ln.getName(), this.dec);
            data.setParent(ln.getLocations().names().get(0).getIdentifier());
        } else {
            data = new CompartmentData(this.dec.getName().getIdentifier(), this.dec);
        }
        for (Expression expression : init.properties()) {
            if (!(expression instanceof InfixExpression)) {
                throw new IllegalArgumentException("Expected an infix expression");
            }
            InfixExpression property = (InfixExpression)expression;
            if (!(property.getLeftHandSide() instanceof PropertyLiteral)) {
                throw new IllegalArgumentException("Expected a property literal");
            }
            PropertyLiteral literal = (PropertyLiteral)property.getLeftHandSide();
            try {
                if (literal.getKind() == PropertyLiteral.Kind.TYPE) {
                    if (!(property.getRightHandSide() instanceof PropertyLiteral)) {
                        throw new IllegalArgumentException("Expected a property literal");
                    }
                    data.setProperty(literal, (PropertyLiteral)property.getRightHandSide());
                    continue;
                }
                ExpressionEvaluatorVisitor v = new ExpressionEvaluatorVisitor(this.compiler);
                property.getRightHandSide().accept(v);
                if (!(v.getExpressionNode() instanceof CompiledNumber)) {
                    this.compiler.problemRequestor.accept(ProblemKind.DYNAMIC_VALUE, property);
                    throw new CompilerException();
                }
                data.setProperty(literal, ((CompiledNumber)v.getExpressionNode()).doubleValue());
            }
            catch (PropertySetterException e) {
                this.compiler.problemRequestor.accept(e.getExplanation(), property);
                throw new CompilerException();
            }
        }
        return data;
    }

    protected Data doGetData() throws BioPEPAException {
        return this.getCompartmentData();
    }
}

