/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.compiler;

import java.util.Map;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledDynamicComponent;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpression;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpressionVisitor;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledFunction;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledNumber;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledOperatorNode;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledSystemVariable;
import uk.ac.ed.inf.biopepa.core.compiler.DynamicExpressionModelContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompiledExpressionEvaluator
extends CompiledExpressionVisitor {
    Map<String, Number> componentCounts;
    double currentTime;
    DynamicExpressionModelContext modelContext;
    protected double result;

    public CompiledExpressionEvaluator(DynamicExpressionModelContext model, Map<String, Number> componentCounts, double time) {
        this.componentCounts = componentCounts;
        this.modelContext = model;
        this.currentTime = time;
    }

    public double getResult() {
        return this.result;
    }

    @Override
    public boolean visit(CompiledDynamicComponent component) {
        String name = component.getName();
        if (this.modelContext.containsComponent(name)) {
            Number count = this.componentCounts.get(name);
            this.result = count.doubleValue();
            return false;
        }
        if (this.modelContext.containsVariable(name)) {
            CompiledExpression varExp = this.modelContext.getDynamicExpression(name);
            varExp.accept(this);
            return false;
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean visit(CompiledFunction function) {
        block10: {
            block9: {
                if (function.getFunction().isRateLaw()) {
                    throw new IllegalStateException();
                }
                if (function.getFunction().args() != 1) break block9;
                function.getArguments().get(0).accept(this);
                double argument = this.result;
                switch (function.getFunction()) {
                    case LOG: {
                        this.result = Math.log(argument);
                        break block10;
                    }
                    case EXP: {
                        this.result = Math.exp(argument);
                        break block10;
                    }
                    case H: {
                        this.result = argument > 0.0 ? 1 : 0;
                        break block10;
                    }
                    case FLOOR: {
                        this.result = Math.floor(argument);
                        break block10;
                    }
                    case CEILING: {
                        this.result = Math.ceil(argument);
                        break block10;
                    }
                    case TANH: {
                        this.result = Math.tanh(argument);
                        break block10;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    @Override
    public boolean visit(CompiledNumber number) {
        this.result = number.getNumber().doubleValue();
        return false;
    }

    @Override
    public boolean visit(CompiledOperatorNode operator) {
        operator.getLeft().accept(this);
        double left = this.result;
        operator.getRight().accept(this);
        double right = this.result;
        switch (operator.getOperator()) {
            case PLUS: {
                this.result = left + right;
                break;
            }
            case MINUS: {
                this.result = left - right;
                break;
            }
            case DIVIDE: {
                this.result = left / right;
                break;
            }
            case MULTIPLY: {
                this.result = left * right;
                break;
            }
            case POWER: {
                this.result = Math.pow(left, right);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return false;
    }

    @Override
    public boolean visit(CompiledSystemVariable variable) {
        switch (variable.getVariable()) {
            case TIME: {
                this.result = this.currentTime;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return false;
    }
}

