/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.compiler;

import java.util.List;
import java.util.Map;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpressionEvaluator;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledFunction;
import uk.ac.ed.inf.biopepa.core.compiler.DynamicExpressionModelContext;
import uk.ac.ed.inf.biopepa.core.sba.SBAComponentBehaviour;
import uk.ac.ed.inf.biopepa.core.sba.SBAReaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompiledExpressionRateEvaluator
extends CompiledExpressionEvaluator {
    private SBAReaction reaction;

    public CompiledExpressionRateEvaluator(DynamicExpressionModelContext modelContext, Map<String, Number> componentCounts, double time, SBAReaction r) {
        super(modelContext, componentCounts, time);
        this.reaction = r;
    }

    @Override
    public boolean visit(CompiledFunction function) {
        block8: {
            block7: {
                if (!function.getFunction().isRateLaw()) break block7;
                switch (function.getFunction()) {
                    case fMA: {
                        function.getArguments().get(0).accept(this);
                        List<SBAComponentBehaviour> reactants = this.reaction.getReactants();
                        for (SBAComponentBehaviour reactant : reactants) {
                            Number count = (Number)this.componentCounts.get(reactant.getName());
                            double k = Math.pow(count.doubleValue(), reactant.getStoichiometry());
                            this.result *= k;
                        }
                        break block8;
                    }
                    case fMM: {
                        function.getArguments().get(0).accept(this);
                        double arg1 = this.result;
                        function.getArguments().get(1).accept(this);
                        double arg2 = this.result;
                        String substrate = null;
                        String enzyme = null;
                        for (SBAComponentBehaviour cb : this.reaction.getReactants()) {
                            if (cb.getType().equals((Object)SBAComponentBehaviour.Type.REACTANT)) {
                                substrate = cb.getName();
                            }
                            enzyme = cb.getName();
                            if (cb.getStoichiometry() == 1) continue;
                            throw new IllegalStateException();
                        }
                        Number substrateCount = (Number)this.componentCounts.get(substrate);
                        Number enzymeCount = (Number)this.componentCounts.get(enzyme);
                        double numerator = arg1 * substrateCount.doubleValue() * enzymeCount.doubleValue();
                        double denominator = arg2 * substrateCount.doubleValue();
                        this.result = numerator / denominator;
                        break block8;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            super.visit(function);
        }
        return false;
    }
}

