/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.compiler;

import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpression;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpressionVisitor;

public class CompiledNumber
extends CompiledExpression {
    Number number;

    public CompiledNumber(Number number) {
        if (number == null) {
            throw new NullPointerException();
        }
        this.number = number;
    }

    public Number getNumber() {
        return this.number;
    }

    public boolean evaluatesToLong() {
        return this.number instanceof Long;
    }

    public long longValue() {
        return this.number.longValue();
    }

    public boolean evaluatesToDouble() {
        return this.number instanceof Double;
    }

    public double doubleValue() {
        return this.number.doubleValue();
    }

    public String toString() {
        return this.number.toString();
    }

    public boolean accept(CompiledExpressionVisitor visitor) {
        return visitor.visit(this);
    }

    public boolean isDynamic() {
        return false;
    }

    public CompiledNumber clone() {
        CompiledNumber cn = new CompiledNumber(this.number);
        if (this.expandedForm != null) {
            cn.expandedForm = this.expandedForm.clone();
        }
        return cn;
    }
}

