/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.compiler;

import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpression;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpressionVisitor;
import uk.ac.ed.inf.biopepa.core.dom.InfixExpression;

public class CompiledOperatorNode
extends CompiledExpression {
    CompiledExpression left = null;
    CompiledExpression right = null;
    Operator operator = null;

    public void setLeft(CompiledExpression left) {
        this.left = left;
    }

    public void setRight(CompiledExpression right) {
        this.right = right;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    void setOperator(InfixExpression.Operator operator) {
        switch (operator) {
            case PLUS: {
                this.operator = Operator.PLUS;
                break;
            }
            case MINUS: {
                this.operator = Operator.MINUS;
                break;
            }
            case TIMES: {
                this.operator = Operator.MULTIPLY;
                break;
            }
            case DIVIDE: {
                this.operator = Operator.DIVIDE;
                break;
            }
            case POWER: {
                this.operator = Operator.POWER;
            }
        }
    }

    public CompiledExpression getLeft() {
        return this.left;
    }

    public CompiledExpression getRight() {
        return this.right;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.left == null) {
            System.out.println("Yeah left is null");
            System.out.println(this.right.toString());
        }
        if (this.operator == null) {
            System.out.println("Yeah operator is null");
            System.out.println(this.left.toString());
        }
        sb.append(this.left.toString()).append(this.operator.toString());
        sb.append(this.right.toString());
        return sb.toString();
    }

    public boolean accept(CompiledExpressionVisitor visitor) {
        return visitor.visit(this);
    }

    public boolean isDynamic() {
        if (this.left != null && this.left.isDynamic()) {
            return true;
        }
        return this.right != null && this.right.isDynamic();
    }

    public CompiledOperatorNode clone() {
        CompiledOperatorNode con = new CompiledOperatorNode();
        con.operator = this.operator;
        if (this.left != null) {
            con.left = this.left.clone();
        }
        if (this.right != null) {
            con.right = this.right.clone();
        }
        if (this.expandedForm != null) {
            con.expandedForm = this.expandedForm.clone();
        }
        return con;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        PLUS("+"),
        MINUS("-"),
        DIVIDE("/"),
        MULTIPLY("*"),
        POWER("^");

        private String op;

        private Operator(String s) {
            this.op = s;
        }

        public String toString() {
            return this.op;
        }
    }
}

