/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.compiler;

import java.util.ArrayList;
import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.compiler.CompilerException;
import uk.ac.ed.inf.biopepa.core.compiler.DefaultCompilerVisitor;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.PrefixData;
import uk.ac.ed.inf.biopepa.core.compiler.ProblemInfo;
import uk.ac.ed.inf.biopepa.core.compiler.ProblemKind;
import uk.ac.ed.inf.biopepa.core.compiler.SingleActionVisitor;
import uk.ac.ed.inf.biopepa.core.dom.ASTNode;
import uk.ac.ed.inf.biopepa.core.dom.Expression;
import uk.ac.ed.inf.biopepa.core.dom.InfixExpression;
import uk.ac.ed.inf.biopepa.core.dom.LocatedName;
import uk.ac.ed.inf.biopepa.core.dom.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentPrefixVisitor
extends DefaultCompilerVisitor {
    private String identifier;
    private ArrayList<PrefixData> prefixes;

    public ComponentPrefixVisitor(ModelCompiler compiler, String identifier) {
        this(compiler, identifier, new ArrayList<PrefixData>());
    }

    private ComponentPrefixVisitor(ModelCompiler compiler, String identifier, ArrayList<PrefixData> prefixes) {
        super(compiler);
        this.identifier = identifier;
        this.prefixes = prefixes;
    }

    public PrefixData[] getActions() {
        return this.prefixes.toArray(new PrefixData[this.prefixes.size()]);
    }

    @Override
    public boolean visit(InfixExpression infixExpression) throws BioPEPAException {
        if (infixExpression.getOperator() == InfixExpression.Operator.PLUS) {
            return this.handleChoice(infixExpression);
        }
        Expression rhs = infixExpression.getRightHandSide();
        if (!(rhs instanceof Name)) {
            this.compiler.problemRequestor.accept(ProblemKind.INVALID_TARGET_COMPONENT, rhs);
            throw new CompilerException();
        }
        if (rhs instanceof LocatedName) {
            LocatedName ln = (LocatedName)rhs;
            if (!ln.getName().equals(this.identifier)) {
                this.compiler.problemRequestor.accept(ProblemKind.INVALID_TARGET_COMPONENT, rhs);
                throw new CompilerException();
            }
            int i = ln.getLocations().names().size() - 1;
            while (i >= 0) {
                if (!this.compiler.isDynamic(ln.getIdentifier(i))) {
                    if (ln.getLocations().names().size() == 1) {
                        this.compiler.problemRequestor.accept(ProblemInfo.Severity.WARNING, "Action is undefined as " + ln.getIdentifier(i) + " is not declared in the model component.", (ASTNode)infixExpression);
                    } else {
                        this.compiler.problemRequestor.accept(ProblemInfo.Severity.WARNING, "Action is undefined as " + ln.getIdentifier(i) + " is not declared in the model component.", (ASTNode)ln);
                    }
                }
                --i;
            }
        } else if (!((Name)rhs).getIdentifier().equals(this.identifier)) {
            this.compiler.problemRequestor.accept(ProblemKind.INVALID_TARGET_COMPONENT, rhs);
            throw new CompilerException();
        }
        SingleActionVisitor v = new SingleActionVisitor(this.compiler);
        infixExpression.accept(v);
        this.checkAndAdd(infixExpression.getLeftHandSide(), v.data);
        return true;
    }

    private void checkAndAdd(Expression lhs, PrefixData data) throws BioPEPAException {
        for (PrefixData insertedData : this.prefixes) {
            if (!insertedData.function.equals(data.function)) continue;
            this.compiler.problemRequestor.accept(ProblemKind.DUPLICATE_REACTION_FOUND, lhs);
            throw new CompilerException();
        }
        this.prefixes.add(data);
    }

    private boolean handleChoice(InfixExpression infixExpression) throws BioPEPAException {
        ComponentPrefixVisitor lhs = new ComponentPrefixVisitor(this.compiler, this.identifier, this.prefixes);
        infixExpression.getLeftHandSide().accept(lhs);
        ComponentPrefixVisitor rhs = new ComponentPrefixVisitor(this.compiler, this.identifier, this.prefixes);
        infixExpression.getRightHandSide().accept(rhs);
        return true;
    }
}

