/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.compiler;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.compiler.CompartmentData;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpression;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledNumber;
import uk.ac.ed.inf.biopepa.core.compiler.CompilerException;
import uk.ac.ed.inf.biopepa.core.compiler.ComponentNode;
import uk.ac.ed.inf.biopepa.core.compiler.CooperationNode;
import uk.ac.ed.inf.biopepa.core.compiler.DefaultCompilerVisitor;
import uk.ac.ed.inf.biopepa.core.compiler.ExpressionEvaluatorVisitor;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.ProblemInfo;
import uk.ac.ed.inf.biopepa.core.compiler.ProblemKind;
import uk.ac.ed.inf.biopepa.core.compiler.SpeciesData;
import uk.ac.ed.inf.biopepa.core.compiler.SystemEquationData;
import uk.ac.ed.inf.biopepa.core.compiler.SystemEquationNode;
import uk.ac.ed.inf.biopepa.core.dom.ASTNode;
import uk.ac.ed.inf.biopepa.core.dom.Component;
import uk.ac.ed.inf.biopepa.core.dom.Cooperation;
import uk.ac.ed.inf.biopepa.core.dom.Expression;
import uk.ac.ed.inf.biopepa.core.dom.LocatedName;
import uk.ac.ed.inf.biopepa.core.dom.Name;
import uk.ac.ed.inf.biopepa.core.dom.PropertyLiteral;

public class CompositionalVisitor
extends DefaultCompilerVisitor {
    protected SystemEquationNode result = null;
    private boolean locationsRequired = false;

    public CompositionalVisitor(ModelCompiler compiler) {
        super(compiler);
        this.locationsRequired = compiler.getNumberOfDefinedCompartments() > 0;
    }

    public SystemEquationNode getData() {
        return this.result;
    }

    public boolean visit(Name name) throws BioPEPAException {
        SystemEquationData data = this.compiler.checkAndGetComposition(name.getIdentifier());
        if (data == null) {
            this.compiler.problemRequestor.accept(ProblemKind.VARIABLE_USED_BUT_NOT_DEFINED, name);
            throw new CompilerException();
        }
        this.result = data.getSystemEquationNode();
        return true;
    }

    public boolean visit(Component component) throws BioPEPAException {
        String identifier;
        Expression level = component.getLevel();
        ExpressionEvaluatorVisitor v = new ExpressionEvaluatorVisitor(this.compiler);
        level.accept(v);
        CompiledExpression compiledExpression = v.getExpressionNode();
        ComponentNode nodeInfo = new ComponentNode(compiledExpression);
        Name name = component.getName();
        if (name instanceof LocatedName) {
            identifier = ((LocatedName)name).getName();
            List<Name> names = ((LocatedName)name).getLocations().names();
            if (names.size() > 1) {
                this.compiler.problemRequestor.accept(ProblemKind.INVALID_NUMBER_OF_LOCATIONS, component);
                throw new CompilerException();
            }
            CompartmentData cd = this.compiler.checkAndGetCompartmentData(names.get(0).getIdentifier());
            if (cd == null) {
                this.compiler.problemRequestor.accept(ProblemKind.LOCATION_USED_BUT_NOT_DEFINED, component);
                throw new CompilerException();
            }
            nodeInfo.setCompartment(cd);
        } else {
            if (this.locationsRequired) {
                this.compiler.problemRequestor.accept(ProblemInfo.Severity.ERROR, String.valueOf(name.getIdentifier()) + " does specify a location.", (ASTNode)component);
            }
            identifier = component.getName().getIdentifier();
        }
        if (this.compiler.checkAndGetComponentData(identifier) == null) {
            this.compiler.problemRequestor.accept(ProblemKind.SPECIES_NOT_DECLARED, component);
            throw new CompilerException();
        }
        nodeInfo.setComponent(identifier);
        if (!(compiledExpression instanceof CompiledNumber)) {
            this.compiler.problemRequestor.accept(ProblemKind.DYNAMIC_VALUE, level);
            throw new CompilerException();
        }
        CompiledNumber enn = (CompiledNumber)compiledExpression;
        if (!enn.evaluatesToLong()) {
            this.compiler.problemRequestor.accept(ProblemKind.NON_INTEGER_VALUE, level);
            throw new CompilerException();
        }
        long count = enn.longValue();
        if (count < 0L) {
            this.compiler.problemRequestor.accept(ProblemKind.INITIAL_COUNT_LT_ZERO, level);
            throw new CompilerException();
        }
        SpeciesData data = this.compiler.checkAndGetSpeciesData(identifier);
        if (data != null) {
            if (data.getMaximumConcentration() < count) {
                this.compiler.problemRequestor.accept(ProblemKind.INITIAL_COUNT_GT_MAX, level);
                throw new CompilerException();
            }
            if (data.isSetProperty(PropertyLiteral.Kind.MIN) && data.getMinimalConcentration() > count) {
                this.compiler.problemRequestor.accept(ProblemKind.INITIAL_COUNT_LT_MIN, level);
                throw new CompilerException();
            }
        }
        nodeInfo.setCount(count);
        this.result = nodeInfo;
        return true;
    }

    public boolean visit(Cooperation cooperation) throws BioPEPAException {
        CooperationNode result = new CooperationNode();
        CompositionalVisitor lhsVisitor = new CompositionalVisitor(this.compiler);
        cooperation.getLeftHandSide().accept(lhsVisitor);
        CompositionalVisitor rhsVisitor = new CompositionalVisitor(this.compiler);
        cooperation.getRightHandSide().accept(rhsVisitor);
        result.setLeft(lhsVisitor.getData());
        result.setRight(rhsVisitor.getData());
        ArrayList<String> actions2 = new ArrayList<String>();
        List<Name> tActions = cooperation.getActionSet().names();
        if (tActions.size() == 1 && tActions.get(0).getIdentifier().equals("*")) {
            actions2.add("*");
        } else {
            for (Name name : tActions) {
                String actionName = name.getIdentifier();
                if (this.compiler.checkAndGetFunctionalRate(actionName) == null) {
                    this.compiler.problemRequestor.accept(ProblemKind.FUNCTIONAL_RATE_USED_BUT_NOT_DECLARED, name);
                    throw new CompilerException();
                }
                if (actions2.contains(actionName)) {
                    this.compiler.problemRequestor.accept(ProblemKind.DUPLICATE_ACTION_FOUND, name);
                }
                actions2.add(actionName);
            }
        }
        result.setActions(actions2.toArray(new String[actions2.size()]));
        this.result = result;
        return true;
    }
}

