/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.compiler;

import java.util.List;
import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.compiler.ActionData;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledNumber;
import uk.ac.ed.inf.biopepa.core.compiler.DefaultCompilerVisitor;
import uk.ac.ed.inf.biopepa.core.compiler.ExpressionEvaluatorVisitor;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.PrefixData;
import uk.ac.ed.inf.biopepa.core.compiler.ProblemKind;
import uk.ac.ed.inf.biopepa.core.compiler.TransportData;
import uk.ac.ed.inf.biopepa.core.dom.ASTNode;
import uk.ac.ed.inf.biopepa.core.dom.Expression;
import uk.ac.ed.inf.biopepa.core.dom.InfixExpression;
import uk.ac.ed.inf.biopepa.core.dom.LocatedName;
import uk.ac.ed.inf.biopepa.core.dom.Name;
import uk.ac.ed.inf.biopepa.core.dom.Prefix;
import uk.ac.ed.inf.biopepa.core.dom.Transport;

public class SingleActionVisitor
extends DefaultCompilerVisitor {
    PrefixData data = null;

    public SingleActionVisitor(ModelCompiler compiler) {
        super(compiler);
    }

    public boolean visit(Name name) throws BioPEPAException {
        String id = name.getIdentifier();
        if (this.data == null) {
            this.data = new ActionData();
        }
        this.data.setFunction(id);
        if (this.compiler.checkAndGetFunctionalRate(id) == null) {
            this.compiler.problemRequestor.accept(ProblemKind.FUNCTIONAL_RATE_USED_BUT_NOT_DECLARED, name);
            return false;
        }
        return true;
    }

    public boolean visit(Prefix prefix) throws BioPEPAException {
        this.data = new ActionData();
        prefix.getActionType().accept(this);
        Expression stoichometry = prefix.getStoichometry();
        ExpressionEvaluatorVisitor v = new ExpressionEvaluatorVisitor(this.compiler);
        stoichometry.accept(v);
        if (!(v.getExpressionNode() instanceof CompiledNumber)) {
            this.compiler.problemRequestor.accept(ProblemKind.DYNAMIC_VALUE, stoichometry);
            return false;
        }
        CompiledNumber enn = (CompiledNumber)v.getExpressionNode();
        if (!enn.evaluatesToLong()) {
            this.compiler.problemRequestor.accept(ProblemKind.NON_INTEGER_VALUE, stoichometry);
            return false;
        }
        this.data.setStoichometry(enn.longValue());
        return true;
    }

    public boolean visit(Transport transport) throws BioPEPAException {
        TransportData td = new TransportData();
        this.data = td;
        transport.getActonType().accept(this);
        Name name = (Name)transport.getLeftHandSide();
        String id = name.getIdentifier();
        if (this.compiler.checkAndGetCompartmentData(id) == null) {
            this.compiler.problemRequestor.accept(ProblemKind.LOCATION_USED_BUT_NOT_DEFINED, name);
            return false;
        }
        td.setSourceLocation(id);
        name = (Name)transport.getRightHandSide();
        id = name.getIdentifier();
        if (this.compiler.checkAndGetCompartmentData(id) == null) {
            this.compiler.problemRequestor.accept(ProblemKind.LOCATION_USED_BUT_NOT_DEFINED, name);
            return false;
        }
        td.setTargetLocation(id);
        switch (transport.getOperator()) {
            case BMOVE: {
                td.setOperator(PrefixData.Operator.BI_TRANSPORTATION);
                break;
            }
            case UMOVE: {
                td.setOperator(PrefixData.Operator.UNI_TRANSPORTATION);
                break;
            }
            default: {
                this.compiler.problemRequestor.accept(ProblemKind.INVALID_OPERATOR_FOR_TRANSPORT, transport);
                return false;
            }
        }
        return true;
    }

    public boolean visit(InfixExpression infixExpression) throws BioPEPAException {
        infixExpression.getLeftHandSide().accept(this);
        this.data.declaration = infixExpression;
        Name name = (Name)infixExpression.getRightHandSide();
        if (this.data instanceof TransportData) {
            if (infixExpression.getOperator() != InfixExpression.Operator.GENERIC) {
                this.compiler.problemRequestor.accept(ProblemKind.INVALID_OPERATOR_FOR_TRANSPORT, ". Generic operator should be used to denote transportation", (ASTNode)infixExpression);
                return false;
            }
            if (name instanceof LocatedName) {
                this.compiler.problemRequestor.accept(ProblemKind.INVALID_LOCATED_NAME_USE, name);
                return false;
            }
        } else {
            if (name instanceof LocatedName) {
                List<Name> names = ((LocatedName)name).getLocations().names();
                ActionData pd = (ActionData)this.data;
                for (Name n : names) {
                    String s = n.getIdentifier();
                    if (this.compiler.checkAndGetCompartmentData(s) == null) {
                        this.compiler.problemRequestor.accept(ProblemKind.LOCATION_USED_BUT_NOT_DEFINED, n);
                        return false;
                    }
                    pd.addLocation(s);
                }
            }
            switch (infixExpression.getOperator()) {
                case ACTIVATOR: {
                    this.data.setOperator(PrefixData.Operator.ACTIVATOR);
                    break;
                }
                case GENERIC: {
                    this.data.setOperator(PrefixData.Operator.GENERIC);
                    break;
                }
                case INHIBITOR: {
                    this.data.setOperator(PrefixData.Operator.INHIBITOR);
                    break;
                }
                case PRODUCT: {
                    this.data.setOperator(PrefixData.Operator.PRODUCT);
                    break;
                }
                case REACTANT: {
                    this.data.setOperator(PrefixData.Operator.REACTANT);
                    break;
                }
                default: {
                    this.compiler.problemRequestor.accept(ProblemKind.INVALID_OPERATOR_FOR_REACTION, infixExpression);
                    return false;
                }
            }
        }
        return true;
    }
}

