/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.compiler;

import uk.ac.ed.inf.biopepa.core.compiler.CompartmentData;
import uk.ac.ed.inf.biopepa.core.compiler.Data;
import uk.ac.ed.inf.biopepa.core.compiler.ProblemKind;
import uk.ac.ed.inf.biopepa.core.compiler.PropertySetterException;
import uk.ac.ed.inf.biopepa.core.dom.ASTNode;
import uk.ac.ed.inf.biopepa.core.dom.PropertyLiteral;

public class SpeciesData
extends Data {
    private long maximumCount = Long.MIN_VALUE;
    private long minimalCount = Long.MIN_VALUE;
    private CompartmentData compartment = null;

    SpeciesData(String name, ASTNode declaration) {
        super(name, declaration);
    }

    boolean isSetProperty(PropertyLiteral literal) {
        return this.isSetProperty(literal.getKind());
    }

    boolean isSetProperty(PropertyLiteral.Kind kind) {
        if (kind == null) {
            throw new IllegalArgumentException();
        }
        if (kind == PropertyLiteral.Kind.MAX) {
            return this.maximumCount != Long.MIN_VALUE;
        }
        if (kind == PropertyLiteral.Kind.MIN) {
            return this.minimalCount != Long.MIN_VALUE;
        }
        if (kind == PropertyLiteral.Kind.V) {
            return this.compartment != null;
        }
        throw new IllegalArgumentException();
    }

    void setProperty(PropertyLiteral literal, long result) throws PropertySetterException {
        if (result < 0L) {
            throw new PropertySetterException(ProblemKind.GTE_ZERO);
        }
        if (literal.getKind() == PropertyLiteral.Kind.MAX) {
            if (this.minimalCount != Long.MIN_VALUE && result < this.minimalCount) {
                throw new PropertySetterException(ProblemKind.MAX_LT_MIN);
            }
            this.maximumCount = result;
            return;
        }
        if (literal.getKind() == PropertyLiteral.Kind.MIN) {
            if (this.maximumCount != Long.MIN_VALUE && result >= this.maximumCount) {
                throw new PropertySetterException(ProblemKind.MIN_GT_MAX);
            }
            this.minimalCount = result;
            return;
        }
        throw new PropertySetterException(ProblemKind.ILLEGAL_PROPERTY);
    }

    public long getMaximumConcentration() {
        return this.maximumCount;
    }

    public long getMinimalConcentration() {
        return this.minimalCount;
    }

    public CompartmentData getCompartment() {
        return this.compartment;
    }

    void setCompartment(CompartmentData compartmentData) {
        this.compartment = compartmentData;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[Species] Name=");
        buf.append(this.getName());
        buf.append(",MaximumMolecularCount=");
        buf.append(this.getMaximumConcentration());
        buf.append(",MinimalMolecularCount=");
        buf.append(this.getMinimalConcentration());
        buf.append(",Compartment=");
        buf.append(this.compartment != null ? this.compartment.getName() : "null");
        return buf.toString();
    }

    public int compareTo(Object o) {
        SpeciesData s = (SpeciesData)o;
        int i = this.compartment.name.compareTo(s.compartment.name);
        if (i != 0) {
            return i;
        }
        return this.name.compareTo(s.name);
    }
}

