/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.compiler;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.compiler.AbstractDefinitionCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.CompartmentData;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledNumber;
import uk.ac.ed.inf.biopepa.core.compiler.CompilerException;
import uk.ac.ed.inf.biopepa.core.compiler.Data;
import uk.ac.ed.inf.biopepa.core.compiler.ExpressionEvaluatorVisitor;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.ProblemKind;
import uk.ac.ed.inf.biopepa.core.compiler.PropertySetterException;
import uk.ac.ed.inf.biopepa.core.compiler.SpeciesData;
import uk.ac.ed.inf.biopepa.core.dom.Expression;
import uk.ac.ed.inf.biopepa.core.dom.InfixExpression;
import uk.ac.ed.inf.biopepa.core.dom.LocatedName;
import uk.ac.ed.inf.biopepa.core.dom.Name;
import uk.ac.ed.inf.biopepa.core.dom.PropertyInitialiser;
import uk.ac.ed.inf.biopepa.core.dom.PropertyLiteral;
import uk.ac.ed.inf.biopepa.core.dom.VariableDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpeciesDefinitionCompiler
extends AbstractDefinitionCompiler {
    public SpeciesDefinitionCompiler(ModelCompiler compiler, VariableDeclaration dec) {
        super(compiler, VariableDeclaration.Kind.SPECIES, dec);
    }

    private List<SpeciesData> getSpeciesData() throws BioPEPAException {
        SpeciesData data;
        Name name = this.dec.getName();
        ArrayList<SpeciesData> species = new ArrayList<SpeciesData>();
        if (name instanceof LocatedName) {
            LocatedName lName = (LocatedName)name;
            List<Name> names = lName.getLocations().names();
            int i = names.size() - 1;
            while (i >= 0) {
                CompartmentData compartmentData = this.compiler.checkAndGetCompartmentData(names.get(i).getIdentifier());
                if (compartmentData == null) {
                    this.compiler.problemRequestor.accept(ProblemKind.LOCATION_USED_BUT_NOT_DEFINED, name);
                    throw new CompilerException();
                }
                data = new SpeciesData(lName.getIdentifier(i), this.dec);
                data.setCompartment(compartmentData);
                species.add(data);
                --i;
            }
        } else {
            data = new SpeciesData(name.getIdentifier(), this.dec);
            species.add(data);
        }
        PropertyInitialiser init = (PropertyInitialiser)this.dec.getRightHandSide();
        for (Expression expression : init.properties()) {
            PropertyLiteral literal;
            InfixExpression property;
            block16: {
                if (!(expression instanceof InfixExpression)) {
                    throw new IllegalArgumentException("Expected an infix expression");
                }
                property = (InfixExpression)expression;
                if (!(property.getLeftHandSide() instanceof PropertyLiteral)) {
                    throw new IllegalArgumentException("Expected a property literal");
                }
                literal = (PropertyLiteral)property.getLeftHandSide();
                try {
                    if (((SpeciesData)species.get(0)).isSetProperty(literal)) {
                        this.compiler.problemRequestor.accept(ProblemKind.DUPLICATE_PROPERTY_DEFINITION, literal);
                    }
                    break block16;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.compiler.problemRequestor.accept(ProblemKind.ILLEGAL_PROPERTY, literal);
                }
                continue;
            }
            ExpressionEvaluatorVisitor v = new ExpressionEvaluatorVisitor(this.compiler);
            property.getRightHandSide().accept(v);
            if (!(v.getExpressionNode() instanceof CompiledNumber)) {
                this.compiler.problemRequestor.accept(ProblemKind.DYNAMIC_VALUE, property);
                throw new CompilerException();
            }
            CompiledNumber enn = (CompiledNumber)v.getExpressionNode();
            if (!enn.evaluatesToLong()) {
                this.compiler.problemRequestor.accept(ProblemKind.NON_INTEGER_VALUE, property);
                throw new CompilerException();
            }
            try {
                for (SpeciesData sd : species) {
                    sd.setProperty(literal, enn.longValue());
                }
            }
            catch (PropertySetterException e) {
                this.compiler.problemRequestor.accept(e.getExplanation(), property);
                throw new CompilerException();
            }
        }
        if (!((SpeciesData)species.get(0)).isSetProperty(PropertyLiteral.Kind.MAX)) {
            this.compiler.problemRequestor.accept(ProblemKind.MAXIMUM_COUNT_MUST_BE_SPECIFIED, this.dec);
            throw new CompilerException();
        }
        return species;
    }

    @Override
    protected Data doGetData() throws BioPEPAException {
        throw new UnsupportedOperationException();
    }

    protected List<SpeciesData> doGetDataList() throws BioPEPAException {
        return this.getSpeciesData();
    }
}

