/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.dom;

import java.util.List;
import uk.ac.ed.inf.biopepa.core.dom.Component;
import uk.ac.ed.inf.biopepa.core.dom.Cooperation;
import uk.ac.ed.inf.biopepa.core.dom.Expression;
import uk.ac.ed.inf.biopepa.core.dom.ExpressionStatement;
import uk.ac.ed.inf.biopepa.core.dom.InfixExpression;
import uk.ac.ed.inf.biopepa.core.dom.Model;
import uk.ac.ed.inf.biopepa.core.dom.Name;
import uk.ac.ed.inf.biopepa.core.dom.NameSet;
import uk.ac.ed.inf.biopepa.core.dom.NumberLiteral;
import uk.ac.ed.inf.biopepa.core.dom.Statement;
import uk.ac.ed.inf.biopepa.core.dom.VariableDeclaration;

public class AddReactionTracer {
    public static void addReactionTracer(Model astModel, String reactionName, String tracerName) {
        List<Statement> statements = astModel.statements();
        VariableDeclaration newComponentDec = astModel.ast.newVariableDeclaration();
        newComponentDec.setKind(VariableDeclaration.Kind.COMPONENT);
        Name name = astModel.ast.newName();
        name.setIdentifier(tracerName);
        newComponentDec.setName(name);
        InfixExpression compExpr = newComponentDec.ast.newInfixExpression();
        compExpr.setOperator(InfixExpression.Operator.PRODUCT);
        Name rName = compExpr.ast.newName();
        rName.setIdentifier(reactionName);
        compExpr.setLeftHandSide(rName);
        compExpr.setRightHandSide(name);
        newComponentDec.setRightHandSide(compExpr);
        statements.add(newComponentDec);
        for (Statement s : statements) {
            if (!(s instanceof ExpressionStatement)) continue;
            ExpressionStatement systemEq = (ExpressionStatement)s;
            Expression system = systemEq.getExpression();
            Cooperation newSystem = astModel.ast.newCooperation();
            NameSet actionSet = newSystem.ast.newNameSet();
            Name newName = actionSet.ast.newName();
            newName.setIdentifier("*");
            actionSet.names.add(newName);
            newSystem.setActionSet(actionSet);
            newSystem.setLeftHandSide(system);
            Component comp = newSystem.ast.newComponent();
            NumberLiteral level = comp.ast.newNumberLiteral();
            level.setToken("0");
            comp.setName(name);
            comp.setLevel(level);
            newSystem.setRightHandSide(comp);
            systemEq.setExpression(newSystem);
            break;
        }
    }
}

