/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.dom;

import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.dom.AST;
import uk.ac.ed.inf.biopepa.core.dom.ASTVisitor;
import uk.ac.ed.inf.biopepa.core.dom.Expression;

public class InfixExpression
extends Expression {
    private Expression leftHandSide;
    private Operator operator;
    private Expression rightHandSide;

    InfixExpression(AST ast) {
        super(ast);
    }

    public Expression getLeftHandSide() {
        return this.leftHandSide;
    }

    public void setLeftHandSide(Expression leftHandSide) {
        this.leftHandSide = leftHandSide;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operand) {
        this.operator = operand;
    }

    public Expression getRightHandSide() {
        return this.rightHandSide;
    }

    public void setRightHandSide(Expression rightHandSide) {
        this.rightHandSide = rightHandSide;
    }

    public void accept(ASTVisitor visitor) throws BioPEPAException {
        visitor.visit(this);
    }

    public void fillInDeclarationName(Expression declName) {
        if (this.rightHandSide == null) {
            this.rightHandSide = declName;
        } else {
            this.leftHandSide.fillInDeclarationName(declName);
            this.rightHandSide.fillInDeclarationName(declName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        PRODUCT(AST.Literals.PRODUCT.getToken()),
        REACTANT(AST.Literals.REACTANT.getToken()),
        ACTIVATOR(AST.Literals.ACTIVATOR.getToken()),
        INHIBITOR(AST.Literals.INHIBITOR.getToken()),
        GENERIC(AST.Literals.GENERIC_MODIFIER.getToken()),
        PLUS(AST.Literals.PLUS.getToken()),
        MINUS(AST.Literals.MINUS.getToken()),
        DIVIDE(AST.Literals.DIVIDE.getToken()),
        TIMES(AST.Literals.TIMES.getToken()),
        POWER(AST.Literals.POWER.getToken()),
        EQUALS(AST.Literals.EQUALS.getToken()),
        UMOVE(AST.Literals.UMOVE.getToken()),
        BMOVE(AST.Literals.BMOVE.getToken());

        private String literal;

        private Operator(String literal) {
            this.literal = literal;
        }

        public String getLiteral() {
            return this.literal;
        }

        public String toString() {
            return this.getLiteral();
        }
    }
}

