/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.dom;

import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.dom.ASTVisitor;
import uk.ac.ed.inf.biopepa.core.dom.Component;
import uk.ac.ed.inf.biopepa.core.dom.Cooperation;
import uk.ac.ed.inf.biopepa.core.dom.ExpressionStatement;
import uk.ac.ed.inf.biopepa.core.dom.FunctionCall;
import uk.ac.ed.inf.biopepa.core.dom.InfixExpression;
import uk.ac.ed.inf.biopepa.core.dom.Model;
import uk.ac.ed.inf.biopepa.core.dom.Name;
import uk.ac.ed.inf.biopepa.core.dom.NameSet;
import uk.ac.ed.inf.biopepa.core.dom.NumberLiteral;
import uk.ac.ed.inf.biopepa.core.dom.PostfixExpression;
import uk.ac.ed.inf.biopepa.core.dom.Prefix;
import uk.ac.ed.inf.biopepa.core.dom.PropertyInitialiser;
import uk.ac.ed.inf.biopepa.core.dom.PropertyLiteral;
import uk.ac.ed.inf.biopepa.core.dom.Statement;
import uk.ac.ed.inf.biopepa.core.dom.SystemVariable;
import uk.ac.ed.inf.biopepa.core.dom.Transport;
import uk.ac.ed.inf.biopepa.core.dom.VariableDeclaration;

public class OverrideValueVisitor
implements ASTVisitor {
    private String nodeName;
    private String nodeValue;
    private boolean valueOverridden = false;

    public OverrideValueVisitor(String name, String value) {
        this.nodeName = name;
        this.nodeValue = value;
        this.valueOverridden = false;
    }

    public boolean getValueOverridden() {
        return this.valueOverridden;
    }

    public boolean visit(NameSet nameSet) throws BioPEPAException {
        return false;
    }

    public boolean visit(Component component) throws BioPEPAException {
        String componentName = component.getName().getIdentifier();
        if (componentName.equals(this.nodeName)) {
            NumberLiteral level = component.ast.newNumberLiteral();
            level.setToken(this.nodeValue);
            component.setLevel(level);
            this.valueOverridden = true;
        }
        return true;
    }

    public boolean visit(Cooperation cooperation) throws BioPEPAException {
        cooperation.getLeftHandSide().accept(this);
        cooperation.getRightHandSide().accept(this);
        return true;
    }

    public boolean visit(ExpressionStatement statement) throws BioPEPAException {
        statement.getExpression().accept(this);
        return true;
    }

    public boolean visit(FunctionCall functionCall) throws BioPEPAException {
        return false;
    }

    public boolean visit(InfixExpression infixExpression) throws BioPEPAException {
        infixExpression.getLeftHandSide().accept(this);
        infixExpression.getRightHandSide().accept(this);
        return true;
    }

    public boolean visit(Model model) throws BioPEPAException {
        for (Statement s : model.statements()) {
            s.accept(this);
        }
        return true;
    }

    public boolean visit(Name name) throws BioPEPAException {
        return false;
    }

    public boolean visit(NumberLiteral numberLiteral) throws BioPEPAException {
        return false;
    }

    public boolean visit(PostfixExpression postfixExpression) throws BioPEPAException {
        return false;
    }

    public boolean visit(Prefix prefix) throws BioPEPAException {
        return false;
    }

    public boolean visit(PropertyInitialiser propertyInitialiser) throws BioPEPAException {
        return false;
    }

    public boolean visit(PropertyLiteral propertyLiteral) throws BioPEPAException {
        return false;
    }

    public boolean visit(VariableDeclaration variableDeclaration) throws BioPEPAException {
        String varName = variableDeclaration.getName().getIdentifier();
        VariableDeclaration.Kind varKind = variableDeclaration.getKind();
        if (varName.equals(this.nodeName)) {
            if (varKind.equals((Object)VariableDeclaration.Kind.VARIABLE)) {
                NumberLiteral value = variableDeclaration.ast.newNumberLiteral();
                value.setToken(this.nodeValue);
                variableDeclaration.setRightHandSide(value);
                this.valueOverridden = true;
            } else if (varKind.equals((Object)VariableDeclaration.Kind.FUNCTION) && this.nodeValue.equals("off")) {
                NumberLiteral value = variableDeclaration.ast.newNumberLiteral();
                value.setToken("0");
                variableDeclaration.setRightHandSide(value);
                this.valueOverridden = true;
            }
        }
        return true;
    }

    public boolean visit(Transport transport) throws BioPEPAException {
        return false;
    }

    public boolean visit(SystemVariable variable) throws BioPEPAException {
        return false;
    }
}

