/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.imports;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import uk.ac.ed.inf.biopepa.core.imports.NetworKinLine;
import uk.ac.ed.inf.biopepa.core.sba.LineStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworKinTranslate {
    private List<NetworKinLine> networkLines;
    private LinkedList<Reaction> reactions;
    private Collection<BioPEPAComponent> biopepaComponents;

    public NetworKinTranslate(List<NetworKinLine> lines) {
        this.networkLines = lines;
    }

    public void translate() {
        HashMap<Object, Protein> proteinMap = new HashMap<Object, Protein>();
        for (NetworKinLine nline : this.networkLines) {
            Composite kinase = new Composite(nline.getKinase());
            String string = nline.getResidue();
            String proteinName = nline.getProtein();
            Composite protein = new Composite(proteinName);
            Protein proteinValue = (Protein)proteinMap.get(proteinName);
            if (proteinValue == null) {
                proteinValue = new Protein(protein);
                proteinMap.put(proteinName, proteinValue);
            }
            proteinValue.addKinaseAtResidue(kinase, string);
        }
        this.reactions = new LinkedList();
        Stack<Protein> proteinStack = new Stack<Protein>();
        for (Map.Entry entry : proteinMap.entrySet()) {
            proteinStack.add((Protein)entry.getValue());
        }
        while (!proteinStack.isEmpty()) {
            Protein protein = (Protein)proteinStack.pop();
            Composite proteinComposite = protein.getComposite();
            for (Map.Entry entry : protein.residueMap.entrySet()) {
                String residue = (String)entry.getKey();
                for (Composite kinase : (HashSet)entry.getValue()) {
                    HashSet<Composite> reactants = new HashSet<Composite>();
                    HashSet<Composite> products = new HashSet<Composite>();
                    String kName = kinase.printSyntax();
                    String reactionName = "attach_" + kName + "_" + residue;
                    reactants.add(proteinComposite);
                    reactants.add(kinase);
                    Protein productProtein = protein.attachKinaseAtResidue(kinase, residue);
                    Composite product = productProtein.getComposite();
                    products.add(product);
                    Reaction r = new Reaction(reactionName, reactants, products);
                    this.reactions.addLast(r);
                    proteinStack.add(productProtein);
                }
            }
        }
        HashMap<Composite, BioPEPAComponent> hashMap = new HashMap<Composite, BioPEPAComponent>();
        for (Reaction reaction : this.reactions) {
            BioPEPAComponent reactantComp;
            String reactionName = reaction.getName();
            for (Composite reactant : reaction.getReactants()) {
                reactantComp = (BioPEPAComponent)hashMap.get(reactant);
                if (reactantComp == null) {
                    reactantComp = new BioPEPAComponent(reactant);
                    hashMap.put(reactant, reactantComp);
                }
                reactantComp.addReactantReaction(reactionName);
            }
            for (Composite product : reaction.getProducts()) {
                reactantComp = (BioPEPAComponent)hashMap.get(product);
                if (reactantComp == null) {
                    reactantComp = new BioPEPAComponent(product);
                    hashMap.put(product, reactantComp);
                }
                reactantComp.addProductReaction(reactionName);
            }
        }
        this.biopepaComponents = hashMap.values();
    }

    public String getBioPepaString() {
        LineStringBuilder sb = new LineStringBuilder();
        for (BioPEPAComponent component : this.biopepaComponents) {
            sb.appendLine(component.printSyntax());
        }
        return sb.toString();
    }

    public String reactionsString() {
        LineStringBuilder sb = new LineStringBuilder();
        for (Reaction reaction : this.reactions) {
            sb.appendLine(reaction.printSyntax());
        }
        return sb.toString();
    }

    private class BioPEPAComponent {
        Composite name;
        HashSet<String> reactantReactions;
        HashSet<String> productReactions;

        BioPEPAComponent(Composite name) {
            this.name = name;
            this.reactantReactions = new HashSet();
            this.productReactions = new HashSet();
        }

        public void addReactantReaction(String name) {
            this.reactantReactions.add(name);
        }

        public void addProductReaction(String name) {
            this.productReactions.add(name);
        }

        public String printSyntax() {
            String result = String.valueOf(this.name.printSyntax()) + " = ";
            for (String r : this.reactantReactions) {
                result = String.valueOf(result) + " " + r + " << ";
            }
            for (String r : this.productReactions) {
                result = String.valueOf(result) + " " + r + " >> ";
            }
            return String.valueOf(result) + " ;";
        }
    }

    private class Composite {
        HashSet<String> constituents = new HashSet();

        Composite() {
        }

        Composite(String component) {
            this.constituents.add(component);
        }

        public Composite combine(Composite additional) {
            Composite result = new Composite();
            result.constituents.addAll(this.constituents);
            result.constituents.addAll(additional.constituents);
            return result;
        }

        public String printSyntax() {
            String[] names = this.constituents.toArray(new String[this.constituents.size()]);
            if (names.length == 0) {
                return "UnknownConstituents";
            }
            String name = names[0];
            int index = 1;
            while (index < names.length) {
                name = String.valueOf(name) + ":" + names[index];
                ++index;
            }
            return name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Composite)) {
                return false;
            }
            Composite c = (Composite)obj;
            boolean result = this.constituents.equals(c.constituents);
            return result;
        }

        public int hashCode() {
            return this.constituents.hashCode();
        }
    }

    private class Protein {
        HashMap<String, HashSet<Composite>> residueMap;
        Composite composite;

        Protein(Composite name) {
            this.composite = name;
            this.residueMap = new HashMap();
        }

        public Composite getComposite() {
            return this.composite;
        }

        public void addKinaseAtResidue(Composite kinase, String residue) {
            HashSet<Composite> kinases = this.residueMap.get(residue);
            if (kinases == null) {
                kinases = new HashSet();
                this.residueMap.put(residue, kinases);
            }
            kinases.add(kinase);
        }

        public Protein attachKinaseAtResidue(Composite kinase, String residue) {
            Composite newProteinName = this.composite.combine(kinase);
            Protein newProtein = new Protein(newProteinName);
            newProtein.residueMap = (HashMap)this.residueMap.clone();
            newProtein.residueMap.remove(residue);
            return newProtein;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Reaction {
        HashSet<Composite> reactants;
        HashSet<Composite> products;
        String name;

        Reaction(String name, HashSet<Composite> reactants, HashSet<Composite> products) {
            this.name = name;
            this.reactants = reactants;
            this.products = products;
        }

        public String getName() {
            return this.name;
        }

        public Set<Composite> getReactants() {
            return this.reactants;
        }

        public Set<Composite> getProducts() {
            return this.products;
        }

        public String printSyntax() {
            LineStringBuilder sb = new LineStringBuilder();
            sb.append(this.name);
            sb.append(": ");
            boolean first = true;
            for (Composite reactant : this.reactants) {
                if (!first) {
                    sb.append(" + ");
                }
                first = false;
                sb.append(reactant.printSyntax());
            }
            sb.append(" ----> ");
            first = true;
            for (Composite product : this.products) {
                if (!first) {
                    sb.append(" + ");
                }
                first = false;
                sb.append(product.printSyntax());
            }
            return sb.toString();
        }
    }
}

