/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.sba;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.dom.Model;
import uk.ac.ed.inf.biopepa.core.dom.OverrideValueVisitor;
import uk.ac.ed.inf.biopepa.core.interfaces.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExperimentLine {
    private String experimentLineName;
    private Result experimentLineResult;
    public Map<String, Number> initialComponentPops;
    public Map<String, Number> rateValues;
    public Map<String, Boolean> reactionActivations;
    public Map<String, Number> specialDefines;

    public ExperimentLine(String name) {
        this.experimentLineName = name;
        this.experimentLineResult = null;
        this.initialComponentPops = new HashMap<String, Number>();
        this.rateValues = new HashMap<String, Number>();
        this.reactionActivations = new HashMap<String, Boolean>();
        this.specialDefines = new HashMap<String, Number>();
    }

    public String getName() {
        return this.experimentLineName;
    }

    public void setName(String name) {
        this.experimentLineName = name;
    }

    public void setResult(Result r) {
        this.experimentLineResult = r;
    }

    public boolean hasResult() {
        return this.experimentLineResult != null;
    }

    public Result getResult() {
        return this.experimentLineResult;
    }

    public void addInitialConcentration(String compName, Number value) {
        this.initialComponentPops.put(compName, value);
    }

    public Map<String, Number> getInitialPopulations() {
        return this.initialComponentPops;
    }

    public Number getInitialPopulation(String compName) {
        return this.initialComponentPops.get(compName);
    }

    public Map<String, Number> getRateValues() {
        return this.rateValues;
    }

    public void addRateValue(String rateName, Number value) {
        this.rateValues.put(rateName, value);
    }

    public Number getRateValue(String rateName) {
        return this.rateValues.get(rateName);
    }

    public Map<String, Boolean> getReactionActivations() {
        return this.reactionActivations;
    }

    public Set<String> getRateNames() {
        return this.rateValues.keySet();
    }

    public boolean isReactionActiviated(String reactionName) {
        Boolean answer = this.reactionActivations.get(reactionName);
        if (answer == null) {
            return true;
        }
        return answer;
    }

    public void addReactionActivation(String reactionName, boolean activated) {
        this.reactionActivations.put(reactionName, activated);
    }

    public Set<String> getReactionNames() {
        return this.reactionActivations.keySet();
    }

    public void addSpecialDefine(String name, Number value) {
        this.specialDefines.put(name, value);
    }

    public Number getSpecialDefine(String name) {
        return this.specialDefines.get(name);
    }

    public void applyToAst(Model astModel) throws BioPEPAException {
        OverrideValueVisitor ovvisitor;
        String value;
        String name;
        for (Map.Entry<String, Number> entry : this.initialComponentPops.entrySet()) {
            name = entry.getKey();
            value = Integer.toString(entry.getValue().intValue());
            ovvisitor = new OverrideValueVisitor(name, value);
            astModel.accept(ovvisitor);
        }
        for (Map.Entry<String, Number> entry : this.rateValues.entrySet()) {
            name = entry.getKey();
            value = entry.getValue().toString();
            ovvisitor = new OverrideValueVisitor(name, value);
            astModel.accept(ovvisitor);
        }
        for (Map.Entry<String, Serializable> entry : this.reactionActivations.entrySet()) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            name = entry.getKey();
            value = "off";
            ovvisitor = new OverrideValueVisitor(name, value);
            astModel.accept(ovvisitor);
        }
    }
}

