/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.sba;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import uk.ac.ed.inf.biopepa.core.sba.ExperimentLine;
import uk.ac.ed.inf.biopepa.core.sba.LineStringBuilder;
import uk.ac.ed.inf.biopepa.core.sba.SBAModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExperimentSet {
    boolean separateGraphs = true;
    private LinkedList<ExperimentLine> experimentLines = new LinkedList();

    public boolean getSeparateGraphs() {
        return this.separateGraphs;
    }

    public void setSeparateGraphs(boolean sepGraphs) {
        this.separateGraphs = sepGraphs;
    }

    public void addExperimentLine(ExperimentLine experLine) {
        this.experimentLines.add(experLine);
    }

    public LinkedList<ExperimentLine> getExperimentLines() {
        return this.experimentLines;
    }

    public String toCsvSummary(SBAModel model) {
        return this.toCsvString(model, 3, 60);
    }

    public String toCsvString(SBAModel model) {
        return this.toCsvString(model, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public LinkedList<LinkedList<String>> makeListTable(SBAModel sbaModel) {
        HashSet<String> componentNames = new HashSet<String>();
        HashSet<String> rateNames = new HashSet<String>();
        HashSet<String> reactionNames = new HashSet<String>();
        for (ExperimentLine experLine : this.experimentLines) {
            componentNames.addAll(experLine.getInitialPopulations().keySet());
            rateNames.addAll(experLine.getRateNames());
            reactionNames.addAll(experLine.getReactionNames());
        }
        LinkedList<String> headerNames = new LinkedList<String>();
        headerNames.addLast("line-name");
        for (String cName : componentNames) {
            headerNames.addLast(cName);
        }
        for (String rName : rateNames) {
            headerNames.addLast(rName);
        }
        for (String rName : reactionNames) {
            headerNames.addLast(rName);
        }
        LinkedList<LinkedList<String>> resultTable = new LinkedList<LinkedList<String>>();
        resultTable.addLast(headerNames);
        for (ExperimentLine experLine : this.experimentLines) {
            LinkedList<String> values = new LinkedList<String>();
            values.addLast(experLine.getName());
            for (String compName : componentNames) {
                Number pop = experLine.getInitialPopulation(compName);
                Long defaultPop = sbaModel.getNamedComponentCount(compName);
                String popString = pop != null ? pop.toString() : ((Object)defaultPop).toString();
                values.addLast(popString);
            }
            for (String rateName : rateNames) {
                Number rate = experLine.getRateValue(rateName);
                Integer defaultRate = 0;
                String rateString = rate != null ? rate.toString() : (defaultRate != null ? ((Object)defaultRate).toString() : "0");
                values.addLast(rateString);
            }
            for (String rName : reactionNames) {
                if (experLine.isReactionActiviated(rName)) {
                    values.addLast("on");
                    continue;
                }
                values.addLast("off");
            }
            resultTable.addLast(values);
        }
        return resultTable;
    }

    public String toCsvString(SBAModel model, int maxLines, int maxWidth) {
        LineStringBuilder sb = new LineStringBuilder();
        HashSet<String> componentNames = new HashSet<String>();
        HashSet<String> rateNames = new HashSet<String>();
        HashSet<String> reactionNames = new HashSet<String>();
        List<ExperimentLine> theseLines = this.experimentLines;
        if (this.experimentLines.size() > maxLines) {
            theseLines = this.experimentLines.subList(0, maxLines - 1);
        }
        for (ExperimentLine experLine : theseLines) {
            componentNames.addAll(experLine.getInitialPopulations().keySet());
            rateNames.addAll(experLine.getRateNames());
            reactionNames.addAll(experLine.getReactionNames());
        }
        StringBuilder header = new StringBuilder();
        header.append("line-name");
        for (String cName : componentNames) {
            header.append(", " + cName);
        }
        for (String rName : rateNames) {
            header.append(", " + rName);
        }
        for (String rName : reactionNames) {
            header.append(", " + rName);
        }
        String headerString = header.toString();
        if (header.length() > maxWidth) {
            headerString = headerString.substring(0, maxWidth - 5);
            headerString = headerString.concat(" ...");
        }
        sb.appendLine(headerString);
        for (ExperimentLine experLine : theseLines) {
            LineStringBuilder thisLine = new LineStringBuilder();
            thisLine.append(experLine.getName());
            for (String compName : componentNames) {
                Number pop = experLine.getInitialPopulation(compName);
                Long defaultPop = model.getNamedComponentCount(compName);
                String popString = pop != null ? pop.toString() : ((Object)defaultPop).toString();
                thisLine.append(", " + popString);
            }
            for (String rateName : rateNames) {
                Number rate = experLine.getRateValue(rateName);
                Integer defaultRate = 0;
                String rateString = rate != null ? rate.toString() : (defaultRate != null ? ((Object)defaultRate).toString() : "0");
                thisLine.append(", " + rateString);
            }
            for (String rName : reactionNames) {
                if (experLine.isReactionActiviated(rName)) {
                    thisLine.append(", on");
                    continue;
                }
                thisLine.append(", off");
            }
            String thisLineString = thisLine.toString();
            if (thisLineString.length() > maxWidth) {
                thisLineString = thisLineString.substring(0, maxWidth - 5);
                thisLineString = thisLineString.concat(" ...");
            }
            sb.appendLine(thisLine.toString());
        }
        if (this.experimentLines.size() > theseLines.size()) {
            sb.appendLine(" ... ");
        }
        return sb.toString();
    }
}

