/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.sba;

import au.com.bytecode.opencsv.CSVReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.sba.ExperimentLine;
import uk.ac.ed.inf.biopepa.core.sba.ExperimentSet;
import uk.ac.ed.inf.biopepa.core.sba.SBAModel;
import uk.ac.ed.inf.biopepa.core.sba.SBAReaction;

public class ExperimentSetReader {
    private String csvReadError = "";
    private ExperimentSet resultSet = null;
    private SBAModel sbaModel;
    private ModelCompiler modelCompiler;

    public ExperimentSetReader(SBAModel sbam, ModelCompiler mc) {
        this.sbaModel = sbam;
        this.modelCompiler = mc;
    }

    public String getReadError() {
        return this.csvReadError;
    }

    public ExperimentSet getExperimentSet() {
        return this.resultSet;
    }

    public boolean arrayContains(Object[] array, Object object) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object arrayObj = objectArray[n2];
            if (arrayObj.equals(object)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readCsvFile(String filename, String[] specialNames) {
        this.csvReadError = "";
        this.resultSet = null;
        if (filename == null) {
            this.csvReadError = "Filename null";
            return;
        }
        try {
            FileReader freader = new FileReader(filename);
            CSVReader reader = new CSVReader((Reader)freader);
            String[] nextLine = reader.readNext();
            if (nextLine == null) {
                return;
            }
            String[] names = new String[nextLine.length];
            int i = 0;
            while (i < nextLine.length) {
                names[i] = nextLine[i].trim();
                ++i;
            }
            SBAReaction[] modelReactions = this.sbaModel.getReactions();
            Object[] modelReactionNames = new String[modelReactions.length];
            int i2 = 0;
            while (i2 < modelReactions.length) {
                modelReactionNames[i2] = modelReactions[i2].getName();
                ++i2;
            }
            ExperimentSet experSet = new ExperimentSet();
            int i3 = 0;
            while ((nextLine = reader.readNext()) != null) {
                if (nextLine.length != names.length) {
                    this.csvReadError = "Parse Error; could not parse the csv file";
                    return;
                }
                String defaultLineName = "Ex-" + i3;
                ExperimentLine experimentLine = new ExperimentLine(defaultLineName);
                int j = 0;
                while (j < names.length) {
                    double value;
                    if (names[j].trim().equals("line-name")) {
                        experimentLine.setName(nextLine[j].trim());
                    } else if (this.arrayContains(specialNames, names[j])) {
                        value = Double.parseDouble(nextLine[j]);
                        experimentLine.addSpecialDefine(names[j], value);
                    } else if (this.modelCompiler.containsComponent(names[j])) {
                        value = Double.parseDouble(nextLine[j]);
                        experimentLine.addInitialConcentration(names[j], value);
                    } else if (this.arrayContains(modelReactionNames, names[j])) {
                        if (nextLine[j].trim().equals("off")) {
                            experimentLine.addReactionActivation(names[j], false);
                        } else {
                            if (!nextLine[j].trim().equals("on")) {
                                this.csvReadError = "Reaction activation unrecognised Your line is:" + nextLine[j] + "it must be either \"on\" or \"off\"";
                                return;
                            }
                            experimentLine.addReactionActivation(names[j], true);
                        }
                    } else {
                        if (!this.modelCompiler.containsVariable(names[j])) {
                            this.csvReadError = "Not-found; The name: " + names[j] + " mentioned in the csv file is" + " not found in the model";
                            return;
                        }
                        value = Double.parseDouble(nextLine[j]);
                        experimentLine.addRateValue(names[j], value);
                    }
                    ++j;
                }
                experSet.addExperimentLine(experimentLine);
                ++i3;
            }
            this.resultSet = experSet;
            return;
        }
        catch (FileNotFoundException e) {
            this.resultSet = null;
            this.csvReadError = "File not found";
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            this.resultSet = null;
            e.printStackTrace();
        }
    }
}

