/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.sba;

import java.util.HashMap;
import uk.ac.ed.inf.biopepa.core.BasicResult;
import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpression;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpressionEvaluator;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledNumber;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledOperatorNode;
import uk.ac.ed.inf.biopepa.core.compiler.ComponentNode;
import uk.ac.ed.inf.biopepa.core.interfaces.ProgressMonitor;
import uk.ac.ed.inf.biopepa.core.interfaces.Result;
import uk.ac.ed.inf.biopepa.core.interfaces.Solver;
import uk.ac.ed.inf.biopepa.core.sba.Parameters;
import uk.ac.ed.inf.biopepa.core.sba.SBAModel;
import uk.ac.ed.inf.biopepa.core.sba.SBAReaction;

public class NativeRungaKutta
implements Solver {
    public String getDescriptiveName() {
        return "A native implementation of Rutta Kunga";
    }

    public String getShortName() {
        return "native-rk";
    }

    public Parameters getRequiredParameters() {
        Parameters parameters = new Parameters();
        parameters.add(Parameters.Parameter.Start_Time);
        parameters.add(Parameters.Parameter.Stop_Time);
        parameters.add(Parameters.Parameter.Data_Points);
        parameters.add(Parameters.Parameter.Components);
        parameters.add(Parameters.Parameter.Step_Size);
        parameters.add(Parameters.Parameter.Absolute_Error);
        parameters.add(Parameters.Parameter.Relative_Error);
        return parameters;
    }

    public Solver.SolverResponse getResponse(SBAModel model) {
        return new Solver.SolverResponse(){

            public String getMessage() {
                if (model.nonDifferentiableFunctions) {
                    return "The model uses functions that may invalidate the results from ODE analysis.";
                }
                return null;
            }

            public Solver.SolverResponse.Suitability getSuitability() {
                if (model.nonDifferentiableFunctions) {
                    return Solver.SolverResponse.Suitability.WARNING;
                }
                return Solver.SolverResponse.Suitability.PERMISSIBLE;
            }
        };
    }

    private CompiledExpression odeAdd(CompiledExpression left, CompiledExpression bareRight, int affect) {
        CompiledExpression right;
        if (affect == 0) {
            return left;
        }
        if (affect == 1) {
            right = bareRight;
        } else {
            CompiledOperatorNode mult = new CompiledOperatorNode();
            mult.setOperator(CompiledOperatorNode.Operator.MULTIPLY);
            mult.setLeft(new CompiledNumber(new Integer(affect)));
            mult.setRight(bareRight);
            right = mult;
        }
        if (left == null) {
            return right;
        }
        CompiledOperatorNode addition = new CompiledOperatorNode();
        addition.setOperator(CompiledOperatorNode.Operator.PLUS);
        addition.setLeft(left);
        addition.setRight(right);
        return addition;
    }

    private double[] createTimePoints(double startTime, double stopTime, Integer dataPoints) {
        double[] timepoints = new double[dataPoints.intValue()];
        double fakeTime = startTime;
        double timeStep = (stopTime - startTime) / dataPoints.doubleValue();
        int timeIndex = 0;
        while (timeIndex < dataPoints) {
            timepoints[timeIndex] = fakeTime;
            fakeTime += timeStep;
            ++timeIndex;
        }
        return timepoints;
    }

    public Result startTimeSeriesAnalysis(SBAModel sbaModel, Parameters parameters, ProgressMonitor monitor) throws BioPEPAException {
        ComponentNode[] componentNodes;
        BasicResult result = new BasicResult();
        Integer dataPoints = (Integer)parameters.getValue(Parameters.Parameter.Data_Points);
        double startTime = (Double)parameters.getValue(Parameters.Parameter.Start_Time);
        double stopTime = (Double)parameters.getValue(Parameters.Parameter.Stop_Time);
        double stepSize = (Double)parameters.getValue(Parameters.Parameter.Step_Size);
        double[] timepoints = this.createTimePoints(startTime, stopTime, dataPoints);
        String[] componentNames = (String[])parameters.getValue(Parameters.Parameter.Components);
        double[][] results = new double[componentNames.length][];
        int index = 0;
        while (index < results.length) {
            results[index] = new double[timepoints.length];
            ++index;
        }
        result.setTimePoints(timepoints);
        result.setResults(results);
        result.setComponentNames(componentNames);
        HashMap<String, Number> componentCounts = new HashMap<String, Number>();
        ComponentNode[] componentNodeArray = componentNodes = sbaModel.getComponents();
        int n = componentNodes.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentNode cn = componentNodeArray[n2];
            Double componentCount = 0.0;
            String componentName = cn.getName();
            componentCount = new Double(cn.getCount());
            componentCounts.put(componentName, componentCount);
            ++n2;
        }
        double simulationTime = startTime;
        int timeIndex = 0;
        SBAReaction[] reactions = sbaModel.getReactions();
        CompiledExpression[] odes = new CompiledExpression[componentNodes.length];
        int odeIndex = 0;
        while (odeIndex < odes.length) {
            String componentName = componentNodes[odeIndex].getName();
            CompiledExpression ode = null;
            SBAReaction[] sBAReactionArray = reactions;
            int n3 = reactions.length;
            int n4 = 0;
            while (n4 < n3) {
                SBAReaction reaction = sBAReactionArray[n4];
                int affect = reaction.netAffect(componentName);
                ode = this.odeAdd(ode, reaction.getRate(), affect);
                ++n4;
            }
            odes[odeIndex] = ode;
            ++odeIndex;
        }
        monitor.beginTask(timepoints.length);
        while (simulationTime <= stopTime && timeIndex < timepoints.length) {
            if (timepoints[timeIndex] <= simulationTime) {
                int compIndex = 0;
                while (compIndex < componentNames.length) {
                    double count;
                    Number countNum = (Number)componentCounts.get(componentNames[compIndex]);
                    results[compIndex][timeIndex] = count = countNum.doubleValue();
                    ++compIndex;
                }
                monitor.worked(1);
                ++timeIndex;
            }
            double[] k0values = new double[componentNodes.length];
            int index2 = 0;
            while (index2 < componentNodes.length) {
                double currentValue;
                String compName = componentNodes[index2].getName();
                k0values[index2] = currentValue = ((Number)componentCounts.get(compName)).doubleValue();
                ++index2;
            }
            double[] k1values = new double[componentNodes.length];
            int index3 = 0;
            while (index3 < componentNodes.length) {
                CompiledExpression changeExp = odes[index3];
                if (changeExp != null) {
                    CompiledExpressionEvaluator eval = new CompiledExpressionEvaluator(sbaModel, componentCounts, simulationTime);
                    changeExp.accept(eval);
                    double value = eval.getResult();
                    k1values[index3] = stepSize * value;
                } else {
                    k1values[index3] = 0.0;
                }
                ++index3;
            }
            index3 = 0;
            while (index3 < componentNodes.length) {
                String compName = componentNodes[index3].getName();
                double currentValue = k0values[index3];
                double change = k1values[index3];
                componentCounts.put(compName, currentValue + change / 2.0);
                ++index3;
            }
            double[] k2values = new double[componentNodes.length];
            int index4 = 0;
            while (index4 < componentNodes.length) {
                CompiledExpression changeExp = odes[index4];
                if (changeExp != null) {
                    CompiledExpressionEvaluator eval = new CompiledExpressionEvaluator(sbaModel, componentCounts, simulationTime + stepSize / 2.0);
                    changeExp.accept(eval);
                    double value = eval.getResult();
                    k2values[index4] = stepSize * value;
                } else {
                    k2values[index4] = 0.0;
                }
                ++index4;
            }
            index4 = 0;
            while (index4 < componentNodes.length) {
                String compName = componentNodes[index4].getName();
                double currentValue = k0values[index4];
                double change = k2values[index4];
                componentCounts.put(compName, currentValue + change / 2.0);
                ++index4;
            }
            double[] k3values = new double[componentNodes.length];
            int index5 = 0;
            while (index5 < componentNodes.length) {
                CompiledExpression changeExp = odes[index5];
                if (changeExp != null) {
                    CompiledExpressionEvaluator eval = new CompiledExpressionEvaluator(sbaModel, componentCounts, simulationTime + stepSize / 2.0);
                    changeExp.accept(eval);
                    double value = eval.getResult();
                    k3values[index5] = stepSize * value;
                } else {
                    k3values[index5] = 0.0;
                }
                ++index5;
            }
            index5 = 0;
            while (index5 < componentNodes.length) {
                String compName = componentNodes[index5].getName();
                double currentValue = k0values[index5];
                double change = k3values[index5];
                componentCounts.put(compName, currentValue + change);
                ++index5;
            }
            double[] k4values = new double[componentNodes.length];
            int index6 = 0;
            while (index6 < componentNodes.length) {
                CompiledExpression changeExp = odes[index6];
                if (changeExp != null) {
                    CompiledExpressionEvaluator eval = new CompiledExpressionEvaluator(sbaModel, componentCounts, simulationTime + stepSize);
                    changeExp.accept(eval);
                    double value = eval.getResult();
                    k4values[index6] = stepSize * value;
                } else {
                    k4values[index6] = 0.0;
                }
                ++index6;
            }
            index6 = 0;
            while (index6 < componentNodes.length) {
                String compName = componentNodes[index6].getName();
                double currentValue = k0values[index6];
                double k1 = k1values[index6];
                double k2 = k2values[index6];
                double k3 = k3values[index6];
                double k4 = k4values[index6];
                double change = 0.16666666666666666 * (k1 + k2 + k2 + k3 + k3 + k4);
                double newValue = currentValue + change;
                componentCounts.put(compName, newValue);
                ++index6;
            }
            simulationTime += stepSize;
        }
        return result;
    }
}

