/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.sba;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameters {
    Map<Parameter, Object> parameters = new HashMap<Parameter, Object>();

    public Map<Parameter, Object> getParameters() {
        return this.parameters;
    }

    public Object getValue(Parameter parameter) {
        return this.parameters.get((Object)parameter);
    }

    public void setValue(Parameter parameter, Object value) {
        if (parameter.parameterClass.isInstance(value)) {
            this.parameters.put(parameter, value);
        } else if (parameter.equals((Object)Parameter.Components) && value instanceof String) {
            StringBuilder sb = new StringBuilder((String)value);
            ArrayList<String> al = new ArrayList<String>();
            try {
                while (sb.length() > 0) {
                    int index = sb.indexOf(":");
                    int length = Integer.parseInt(sb.substring(0, index));
                    sb.delete(0, index + 1);
                    al.add(sb.substring(0, length));
                    sb.delete(0, length);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(String.valueOf(parameter.descriptiveName) + " requires a legal bencoded string.");
            }
            this.parameters.put(parameter, al.toArray(new String[0]));
        } else if (value instanceof String) {
            try {
                Constructor<?> constructor = parameter.parameterClass.getConstructor(String.class);
                Object o = constructor.newInstance(value);
                this.parameters.put(parameter, o);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Value is not of type " + parameter.parameterClass.getName() + " and cannot be constructed using a String as a parameter.");
            }
        } else {
            throw new IllegalArgumentException("Value is not of type " + parameter.parameterClass.getName());
        }
    }

    public Parameter[] arrayOfKeys() {
        Parameter[] p = new Parameter[this.parameters.size()];
        Parameter[] q = Parameter.values();
        int i = 0;
        Parameter[] parameterArray = q;
        int n = q.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter param = parameterArray[n2];
            if (this.parameters.containsKey((Object)param)) {
                p[i++] = param;
            }
            ++n2;
        }
        return p;
    }

    public Set<Parameter> setOfKeys() {
        return this.parameters.keySet();
    }

    void add(Parameter parameter) {
        if (parameter == null) {
            throw new NullPointerException();
        }
        this.parameters.put(parameter, parameter.getDefault());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Parameter {
        Start_Time("Start time", "start-time", Double.class, 0.0),
        Stop_Time("Stop time", "stop-time", Double.class, 100.0),
        Step_Size("Step size", "step-size", Double.class, 0.001),
        Data_Points("Number of data points", "data-points", Integer.class, 100),
        Components("Components", "components", new String[0].getClass(), new String[0]),
        Independent_Replications("Number of independent replications", "replications", Integer.class, 1),
        Relative_Error("Relative error", "relative-error", Double.class, 1.0E-4),
        Absolute_Error("Absolute error", "absolute-error", Double.class, 1.0E-4),
        Confidence_Interval("Confidence interval", "confidence-interval", Double.class, 0.05);

        Class<?> parameterClass;
        String argument;
        String descriptiveName;
        Object defaultValue;

        private Parameter(String name, String argument, Class<?> parameterClass, Object defaultValue) {
            this.descriptiveName = name;
            this.argument = argument;
            this.parameterClass = parameterClass;
            this.defaultValue = defaultValue;
        }

        public Object getDefault() {
            return this.defaultValue;
        }

        public String getDescriptiveName() {
            return this.descriptiveName;
        }

        public String toString() {
            return this.descriptiveName;
        }

        public String getKey() {
            return this.argument;
        }

        public Class<? extends Object> getType() {
            return this.parameterClass;
        }

        public Object parseString(String value) {
            try {
                return this.parameterClass.getConstructor(String.class).newInstance(value);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

