/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.sba;

import java.util.LinkedList;
import java.util.List;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpression;
import uk.ac.ed.inf.biopepa.core.compiler.TransportData;
import uk.ac.ed.inf.biopepa.core.sba.SBAComponentBehaviour;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SBAReaction {
    String name;
    String reversibleName;
    String forwardName;
    private String originalName;
    boolean reversible = false;
    private boolean enabled = true;
    TransportData transportation = null;
    List<SBAComponentBehaviour> reactants = new LinkedList<SBAComponentBehaviour>();
    List<SBAComponentBehaviour> products = new LinkedList<SBAComponentBehaviour>();
    CompiledExpression reactionRate;

    SBAReaction(String name, CompiledExpression rate) {
        this.originalName = name;
        this.name = name;
        this.reactionRate = rate;
    }

    public String getName() {
        return this.name;
    }

    public List<SBAComponentBehaviour> getReactants() {
        LinkedList<SBAComponentBehaviour> newList = new LinkedList<SBAComponentBehaviour>();
        newList.addAll(this.reactants);
        return newList;
    }

    public List<SBAComponentBehaviour> getProducts() {
        LinkedList<SBAComponentBehaviour> newList = new LinkedList<SBAComponentBehaviour>();
        newList.addAll(this.products);
        return newList;
    }

    public CompiledExpression getRate() {
        return this.reactionRate;
    }

    void setReversible(boolean reversible) {
        this.reversible = reversible;
        if (reversible) {
            for (SBAComponentBehaviour cb : this.reactants) {
                if (cb.type.equals((Object)SBAComponentBehaviour.Type.REACTANT)) continue;
                throw new IllegalStateException("");
            }
        }
    }

    public boolean isReversible() {
        return this.reversible;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    boolean addComponent(SBAComponentBehaviour c) {
        if (c == null) {
            throw new NullPointerException("SBAComponent must be non-null.");
        }
        if (c.type.equals((Object)SBAComponentBehaviour.Type.PRODUCT)) {
            if (this.products.contains(c)) {
                return false;
            }
            return this.products.add(c);
        }
        if (this.reactants.contains(c)) {
            return false;
        }
        if (this.reversible && !c.type.equals((Object)SBAComponentBehaviour.Type.REACTANT)) {
            throw new IllegalStateException("");
        }
        return this.reactants.add(c);
    }

    public SBAReaction clone() {
        SBAReaction r = new SBAReaction(this.originalName, this.reactionRate);
        r.name = this.name;
        for (SBAComponentBehaviour cb : this.reactants) {
            r.reactants.add(cb.clone());
        }
        for (SBAComponentBehaviour cb : this.products) {
            r.products.add(cb.clone());
        }
        r.reversible = this.reversible;
        r.transportation = this.transportation;
        return r;
    }

    public static SBAReaction merge(SBAReaction one, SBAReaction two) {
        if (one == null) {
            throw new NullPointerException("First SBAReaction cannot be null.");
        }
        if (two == null) {
            throw new NullPointerException("Second SBAReaction cannot be null.");
        }
        if (!one.originalName.equals(two.originalName)) {
            throw new IllegalArgumentException("Can only merge on identical action names.");
        }
        if (one.reversible != two.reversible) {
            throw new IllegalArgumentException("Cannot merge reversible and non-reversible reactions.");
        }
        if (one.transportation != two.transportation) {
            throw new IllegalArgumentException("Cannot merge transportation reactions.");
        }
        SBAReaction r = one.clone();
        r.reversible = one.reversible;
        for (SBAComponentBehaviour cb : two.reactants) {
            r.reactants.add(cb);
        }
        for (SBAComponentBehaviour cb : two.products) {
            r.products.add(cb);
        }
        return r;
    }

    public int netAffect(String componentName) {
        int net = 0;
        for (SBAComponentBehaviour reactant : this.reactants) {
            if (!reactant.getName().equals(componentName)) continue;
            net -= reactant.stoichiometry;
        }
        for (SBAComponentBehaviour product : this.products) {
            if (!product.getName().equals(componentName)) continue;
            net += product.stoichiometry;
        }
        return net;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(", ");
        for (SBAComponentBehaviour cb : this.reactants) {
            sb.append(cb.toString()).append(" + ");
        }
        if (this.reactants.size() > 0) {
            sb.delete(sb.length() - 3, sb.length());
        }
        if (this.reversible) {
            sb.append("  <->  ");
        } else {
            sb.append("  ->  ");
        }
        for (SBAComponentBehaviour cb : this.products) {
            sb.append(cb.toString()).append(" + ");
        }
        if (this.products.size() > 0) {
            sb.delete(sb.length() - 3, sb.length());
        }
        return sb.toString();
    }
}

