/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.sba.export;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.interfaces.Result;
import uk.ac.ed.inf.biopepa.core.sba.SBAModel;
import uk.ac.ed.inf.biopepa.core.sba.StringConsumer;
import uk.ac.ed.inf.biopepa.core.sba.export.SimulationTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BioNessieTraceLog
implements SimulationTracer.SimulationTraceLog {
    private StringConsumer scon;
    private boolean completeConsumer = true;
    private String[] cnames;

    public void setCompleteConsumer(boolean complete) {
        this.completeConsumer = complete;
    }

    public BioNessieTraceLog(StringConsumer scon, SBAModel model) {
        this.scon = scon;
    }

    @Override
    public void traceLogFooter(Result result) throws IOException {
        if (this.completeConsumer) {
            this.scon.closeStringConsumer();
        }
    }

    public void parameterSweepFormat(Result result) throws IOException {
        String[] cnames = result.getComponentNames();
        this.scon.append("T");
        String[] stringArray = cnames;
        int n = cnames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.scon.append("|");
            this.scon.append(name);
            ++n2;
        }
        this.scon.endLine();
        double[] timepoints = result.getTimePoints();
        int timeIndex = 0;
        while (timeIndex < timepoints.length) {
            double time = timepoints[timeIndex];
            this.scon.append(Double.toString(time));
            int nameIndex = 0;
            while (nameIndex < cnames.length) {
                double value = result.getTimeSeries(nameIndex)[timeIndex];
                this.scon.append("|" + value);
                ++nameIndex;
            }
            this.scon.endLine();
            ++timeIndex;
        }
    }

    @Override
    public void traceLogHeader(HashMap<String, Number> componentCounts) throws IOException {
        if (this.completeConsumer) {
            this.scon.openStringConsumer();
        }
        Set<String> cnamesSet = componentCounts.keySet();
        this.cnames = new String[cnamesSet.size()];
        int nameIndex = 0;
        Iterator<String> iterator = cnamesSet.iterator();
        while (iterator.hasNext()) {
            String cname;
            this.cnames[nameIndex] = cname = iterator.next();
            ++nameIndex;
        }
        this.scon.append("Time");
        String[] stringArray = this.cnames;
        int n = this.cnames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.scon.append(" ");
            this.scon.append(name);
            ++n2;
        }
        this.scon.endLine();
        this.scon.append("0.0");
        this.endEvent(0.0, 0.0, componentCounts);
    }

    @Override
    public void displayComponentCounts(HashMap<String, Number> componentCounts) throws IOException {
    }

    @Override
    public void displayEnabledReaction(String reactionName, double rateValue) throws IOException {
    }

    @Override
    public void startEvent(String rname, double totalTime) throws BioPEPAException, IOException {
        this.scon.append(Double.toString(totalTime));
    }

    @Override
    public void outputComponentUpdate(String rName, int newValue) throws IOException {
    }

    @Override
    public void endEvent(double thisDelay, double totalRate, HashMap<String, Number> componentCounts) throws IOException {
        int nameIndex = 0;
        while (nameIndex < this.cnames.length) {
            double value = componentCounts.get(this.cnames[nameIndex]).doubleValue();
            this.scon.append(" " + value);
            ++nameIndex;
        }
        this.scon.endLine();
    }

    @Override
    public void reportDeadlocked() throws IOException {
    }
}

