/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.sba.export;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import uk.ac.ed.inf.biopepa.core.interfaces.Result;
import uk.ac.ed.inf.biopepa.core.sba.FileStringConsumer;
import uk.ac.ed.inf.biopepa.core.sba.SBAModel;

public class SBRMLResultExport {
    private SBAModel sbaModel;
    private String modelName;

    public SBRMLResultExport(SBAModel model) {
        this.sbaModel = model;
    }

    public void setModelName(String name) {
        this.modelName = name;
    }

    public void exportResults(String filename, Result results) throws IOException {
        FileStringIndenter fs = new FileStringIndenter(filename);
        fs.openStringConsumer();
        GregorianCalendar c = new GregorianCalendar();
        Date s = c.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(s);
        fs.appendLine("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        fs.append("<sbrml xmlns=\"http://www.sbrml.org/sbrml/level1/version1\" ");
        fs.append("version=\"1\" level=\"1\" creationDate=\"" + dateString + "\">");
        fs.endLine();
        fs.increaseIndent();
        fs.indentedLine("<ontologyTerms>");
        fs.increaseIndent();
        fs.indentedLine("<ontologyTerm id=\"term1\" term=\"Temporal Behaviour\" sourceTermId=\"TEDDY_0000107\" ontologyURI=\"http://teddyontology.sourceforge.net/teddy/rel-2007-09-03/ontology/teddy.owl\"/>");
        fs.indentedLine("<ontologyTerm id=\"term3\" term=\"time\" sourceTermId=\"SBO:0000345\" ontologyURI=\"http://www.ebi.ac.uk/sbo/\"/>");
        fs.indentedLine("<ontologyTerm id=\"term4\" term=\"concentration\" sourceTermId=\"SBO:0000196\" ontologyURI=\"http://www.ebi.ac.uk/sbo/\"/>");
        fs.indentedLine("<ontologyTerm id=\"term5\" term=\"particle numbers\" sourceTermId=\"SBRML:00002\" ontologyURI=\"urn:sbrml:ontologyterms\" />");
        fs.indentedLine("</ontologyTerms>");
        fs.decreaseIndent();
        fs.indentedLine("<model name = \"" + this.modelName + "\" />");
        fs.indentedLine("<operations>");
        fs.increaseIndent();
        fs.indentedLine("<operation id=\"op1\" name=\"Time Course\" ontologyTerm=\"term1\">");
        fs.increaseIndent();
        fs.indentedLine("<!-- term2 isn't defined, I'm not sure how to go about this -->");
        fs.indentedLine("<method name=\"Stochastic Simulation Algorithm\" ontologyTerm=\"term2\"/>");
        fs.indentedLine("<software name=\" BioPEPA Eclipse Plug-in\" URL=\"http://www.biopepa.org\"/>");
        fs.indentedLine("<result>");
        fs.increaseIndent();
        fs.indentedLine("<resultComponent id=\"component1\">");
        fs.increaseIndent();
        fs.indentedLine("<dimensionDescription>");
        fs.increaseIndent();
        fs.indentedLine("<compositeDescription name=\"Time\" ontologyTerm=\"term3\" indexType=\"double\">");
        fs.increaseIndent();
        fs.indentedLine("<compositeDescription name=\"species\" indexType=\"string\">");
        fs.increaseIndent();
        fs.indentedLine("<tupleDescription>");
        fs.increaseIndent();
        fs.indentedLine("<atomicDescription name=\"Concentration\" ontologyTerm=\"term4\" valueType=\"double\"/>");
        fs.indentedLine("<atomicDescription name=\"Particle Numbers\" ontologyTerm=\"term5\" valueType=\"integer\"/>");
        fs.decreaseIndent();
        fs.indentedLine("</tupleDescription>");
        fs.decreaseIndent();
        fs.indentedLine("</compositeDescription>");
        fs.decreaseIndent();
        fs.indentedLine("</compositeDescription>");
        fs.decreaseIndent();
        fs.indentedLine("</dimensionDescription>");
        fs.indentedLine("<dimension>");
        fs.increaseIndent();
        String[] compNames = results.getComponentNames();
        double[] timePoints = results.getTimePoints();
        double[][] timeSeries = new double[compNames.length][];
        int nameIndex = 0;
        while (nameIndex < compNames.length) {
            timeSeries[nameIndex] = results.getTimeSeries(nameIndex);
            ++nameIndex;
        }
        int timeIndex = 0;
        while (timeIndex < timePoints.length) {
            fs.indentedLine("<compositeValue indexValue=\"" + timePoints[timeIndex] + "\">");
            fs.increaseIndent();
            int nameIndex2 = 0;
            while (nameIndex2 < timeSeries.length) {
                fs.indentedLine("<compositeValue indexValue = \"" + compNames[nameIndex2] + "\">");
                fs.increaseIndent();
                fs.indentedString("<atomicValue>");
                fs.append(String.valueOf(timeSeries[nameIndex2][timeIndex]) + "</atomicValue>");
                fs.endLine();
                fs.decreaseIndent();
                fs.indentedLine("</compositeValue>");
                ++nameIndex2;
            }
            fs.decreaseIndent();
            fs.indentedLine("</compositeValue>");
            ++timeIndex;
        }
        fs.decreaseIndent();
        fs.indentedLine("</dimension>");
        fs.decreaseIndent();
        fs.indentedLine("</resultComponent>");
        fs.decreaseIndent();
        fs.indentedLine("</result>");
        fs.decreaseIndent();
        fs.indentedLine("</operation>");
        fs.decreaseIndent();
        fs.indentedLine("</operations>");
        fs.decreaseIndent();
        fs.indentedLine("</sbrml>");
        fs.closeStringConsumer();
    }

    private class FileStringIndenter
    extends FileStringConsumer {
        private int indent;

        public FileStringIndenter(String filename) {
            super(filename);
            this.indent = 0;
        }

        public void indentLine() throws IOException {
            int i = 0;
            while (i < this.indent) {
                this.append("  ");
                ++i;
            }
        }

        public void indentedLine(String s) throws IOException {
            this.indentLine();
            this.appendLine(s);
        }

        public void indentedString(String s) throws IOException {
            this.indentLine();
            this.append(s);
        }

        public void increaseIndent() {
            ++this.indent;
        }

        public void decreaseIndent() {
            --this.indent;
        }
    }
}

