/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.sba.export;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import uk.ac.ed.inf.biopepa.core.BasicResult;
import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpression;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpressionEvaluator;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpressionRateEvaluator;
import uk.ac.ed.inf.biopepa.core.compiler.ComponentNode;
import uk.ac.ed.inf.biopepa.core.interfaces.ProgressMonitor;
import uk.ac.ed.inf.biopepa.core.interfaces.Result;
import uk.ac.ed.inf.biopepa.core.sba.ExperimentLine;
import uk.ac.ed.inf.biopepa.core.sba.PhaseLine;
import uk.ac.ed.inf.biopepa.core.sba.SBAComponentBehaviour;
import uk.ac.ed.inf.biopepa.core.sba.SBAModel;
import uk.ac.ed.inf.biopepa.core.sba.SBAReaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulationTracer {
    private int numberFiringsLimit = Integer.MAX_VALUE;
    private double timeLimit = Double.MAX_VALUE;
    private SBAModel sbaModel;
    private Random generator = new Random();
    private double dataPointStep = 1.0;
    private TraceResults simulationResults;
    private LinkedList<Result> listOfAllResults;
    private PhaseLine[] phaseLines;
    SimulationCompleter simulationCompleter;

    public SimulationTracer(SBAModel model) {
        this.sbaModel = model;
    }

    public void setTimeLimit(double newTimeLimit) {
        this.timeLimit = newTimeLimit;
    }

    public void setFiringsLimit(int newLimit) {
        this.numberFiringsLimit = newLimit;
    }

    private double expDelay(double mean) {
        return -mean * Math.log(this.generator.nextDouble());
    }

    public void setDataPointStep(double newDataPointStep) {
        this.dataPointStep = newDataPointStep;
    }

    public Result getSimulationResults() {
        return this.simulationResults;
    }

    public LinkedList<Result> getAllSimulationResults() {
        return this.listOfAllResults;
    }

    public void setPhaseLines(PhaseLine[] phaseLines) {
        this.phaseLines = phaseLines;
    }

    public void generateLotsOfTraces(List<SimulationTraceLog> traceLoggers) throws BioPEPAException, IOException {
        this.listOfAllResults = new LinkedList();
        TraceResults aggregatedResults = null;
        for (SimulationTraceLog traceLog : traceLoggers) {
            this.generateSimulationTrace(traceLog);
            this.listOfAllResults.addLast(this.simulationResults);
            if (aggregatedResults == null) {
                aggregatedResults = this.simulationResults;
                continue;
            }
            aggregatedResults.aggregateResults(this.simulationResults);
        }
        this.simulationResults = aggregatedResults;
    }

    public void calculateDistribution(String comp, Integer value, int runs, ProgressMonitor pg) throws BioPEPAException, IOException {
        this.simulationCompleter = new SimulationCompleter(comp, value);
        pg.beginTask(runs);
        this.simulationCompleter.initialise(0.0, this.timeLimit, runs);
        int i = 0;
        while (i < runs) {
            this.generateSimulationTrace(new NullTraceLog());
            pg.worked(1);
            ++i;
        }
        pg.done();
    }

    public double[] getDistributionTimePoints() {
        return this.simulationCompleter.computeTimePoints();
    }

    public double[] getDistributionCdf() throws BioPEPAException {
        return this.simulationCompleter.computeCdf();
    }

    public double[] getDistributionPdf() {
        return this.simulationCompleter.computePdf();
    }

    public void generateSimulationTrace(SimulationTraceLog traceLog) throws BioPEPAException, IOException {
        String[] componentNames = this.sbaModel.getComponentNames();
        HashMap<String, Number> componentCounts = new HashMap<String, Number>();
        ComponentNode[] componentNodeArray = this.sbaModel.getComponents();
        int n = componentNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentNode cn = componentNodeArray[n2];
            Integer componentCount = 0;
            String componentName = cn.getName();
            componentCount = new Integer((int)cn.getCount());
            componentCounts.put(componentName, componentCount);
            ++n2;
        }
        traceLog.traceLogHeader(componentCounts);
        SBAReaction[] sbaReactions = this.sbaModel.getReactions();
        TraceResults results = this.timeLimit == Double.MAX_VALUE ? new TraceResultsUnlimitedTime(componentNames, 0.0) : new TraceResultsFixedTime(componentNames, 0.0);
        double totalTime = 0.0;
        int numberOfFirings = this.numberFiringsLimit;
        int currentPhase = 0;
        if (this.phaseLines == null) {
            ExperimentLine zeroPhase = new ExperimentLine("zero-phase");
            this.phaseLines = new PhaseLine[1];
            this.phaseLines[0] = new PhaseLine(zeroPhase, this.timeLimit);
        }
        PhaseLine currentPhaseLine = this.phaseLines[currentPhase];
        double currentPhaseDelay = currentPhaseLine.getDuration();
        ExperimentLine currentLine = currentPhaseLine.getExperimentLine();
        while (numberOfFirings-- >= 0 && totalTime < this.timeLimit) {
            int newValue;
            Number current;
            double totalRate = 0.0;
            traceLog.displayComponentCounts(componentCounts);
            double[] reactionRates = new double[sbaReactions.length];
            int index = 0;
            while (index < sbaReactions.length) {
                double rateValue;
                SBAReaction reaction = sbaReactions[index];
                CompiledExpressionRateEvaluator rateEval = new CompiledExpressionRateEvaluator(this.sbaModel, componentCounts, totalTime, reaction);
                reaction.getRate().accept(rateEval);
                reactionRates[index] = rateValue = rateEval.getResult();
                traceLog.displayEnabledReaction(reaction.getName(), rateValue);
                totalRate += rateValue;
                ++index;
            }
            double thisDelay = this.expDelay(1.0 / totalRate);
            if (totalRate <= 0.0) {
                traceLog.reportDeadlocked();
                results.completeDeadLock(componentCounts);
                break;
            }
            if (thisDelay > currentPhaseDelay) {
                totalTime += currentPhaseDelay;
                if (++currentPhase >= this.phaseLines.length) {
                    currentPhase = 0;
                }
                currentPhaseLine = this.phaseLines[currentPhase];
                currentPhaseDelay = currentPhaseLine.getDuration();
                currentLine = currentPhaseLine.getExperimentLine();
                results.updateResults(totalTime, componentCounts);
                continue;
            }
            totalTime += thisDelay;
            currentPhaseDelay -= thisDelay;
            double passedProbability = 0.0;
            double picker = this.generator.nextDouble();
            double chooser = totalRate * picker;
            SBAReaction chosen = null;
            int index2 = 0;
            while (index2 < sbaReactions.length) {
                SBAReaction reaction = sbaReactions[index2];
                double rateValue = reactionRates[index2];
                if (chooser < (passedProbability += rateValue)) {
                    chosen = reaction;
                    break;
                }
                ++index2;
            }
            if (chosen == null) {
                traceLog.reportDeadlocked();
                results.completeDeadLock(componentCounts);
                break;
            }
            String rname = chosen.getName();
            traceLog.startEvent(rname, totalTime);
            results.updateResults(totalTime, componentCounts);
            for (SBAComponentBehaviour cb : chosen.getReactants()) {
                if (!cb.getType().equals((Object)SBAComponentBehaviour.Type.REACTANT)) continue;
                String rName = cb.getName();
                current = componentCounts.get(rName);
                if (current == null) {
                    throw new BioPEPAException("reactant (" + rName + ") not in map");
                }
                newValue = current.intValue() - cb.getStoichiometry();
                componentCounts.put(rName, newValue);
                traceLog.outputComponentUpdate(rName, newValue);
            }
            for (SBAComponentBehaviour cb : chosen.getProducts()) {
                String pName = cb.getName();
                current = componentCounts.get(pName);
                if (current == null) {
                    throw new BioPEPAException("product (" + pName + ") not in map");
                }
                newValue = current.intValue() + cb.getStoichiometry();
                componentCounts.put(pName, newValue);
                traceLog.outputComponentUpdate(pName, newValue);
            }
            traceLog.endEvent(thisDelay, totalRate, componentCounts);
            if (this.simulationCompleter != null && this.simulationCompleter.targetComplete(totalTime, componentCounts, currentLine)) break;
        }
        traceLog.traceLogFooter(results);
        this.simulationResults = results;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NullTraceLog
    implements SimulationTraceLog {
        @Override
        public void displayComponentCounts(HashMap<String, Number> componentCounts) throws IOException {
        }

        @Override
        public void displayEnabledReaction(String rName, double rValue) throws IOException {
        }

        @Override
        public void endEvent(double thisDelay, double totalRate, HashMap<String, Number> componentCounts) throws IOException {
        }

        @Override
        public void outputComponentUpdate(String rName, int newValue) throws IOException {
        }

        @Override
        public void reportDeadlocked() throws IOException {
        }

        @Override
        public void startEvent(String rname, double totalTime) throws BioPEPAException, IOException {
        }

        @Override
        public void traceLogFooter(Result _result) throws IOException {
        }

        @Override
        public void traceLogHeader(HashMap<String, Number> componentCounts) throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SimulationCompleter {
        private String targetName;
        private Number targetValue;
        private boolean targetMet = false;
        private double startTime;
        private int timepointsSize;
        private int numberResults;
        private int[] buckets;

        SimulationCompleter(String componentName, Number value) {
            this.targetName = componentName;
            this.targetValue = value;
        }

        public void initialise(double startTime, double stopTime, int runs) {
            double fakeTime = startTime;
            while (fakeTime < SimulationTracer.this.timeLimit) {
                ++this.timepointsSize;
                fakeTime += SimulationTracer.this.dataPointStep;
            }
            this.buckets = new int[this.timepointsSize];
            this.startTime = startTime;
            this.numberResults = runs;
        }

        public boolean targetComplete(double currentTime, HashMap<String, Number> componentCounts, ExperimentLine currentLine) {
            Number count = componentCounts.get(this.targetName);
            if (count == null) {
                CompiledExpression exp = SimulationTracer.this.sbaModel.getDynamicExpression(this.targetName);
                CompiledExpressionEvaluator expVisitor = new CompiledExpressionEvaluator(SimulationTracer.this.sbaModel, componentCounts, currentTime);
                exp.accept(expVisitor);
                double expValue = expVisitor.getResult();
                count = (int)Math.floor(expValue);
            }
            if (count.intValue() >= this.targetValue.intValue()) {
                int bucket;
                double timeSinceStart = Math.max(0.0, currentTime - this.startTime);
                int n = bucket = (int)Math.floor(timeSinceStart / SimulationTracer.this.dataPointStep);
                this.buckets[n] = this.buckets[n] + 1;
                return true;
            }
            return false;
        }

        public double[] computeTimePoints() {
            double[] timepoints = new double[this.buckets.length];
            double time = this.startTime;
            int i = 0;
            while (i < this.buckets.length) {
                timepoints[i] = time;
                time += SimulationTracer.this.dataPointStep;
                ++i;
            }
            return timepoints;
        }

        public double[] computeCdf() throws BioPEPAException {
            double[] cdfPoints = new double[this.buckets.length];
            int completed = 0;
            int index = 0;
            while (index < cdfPoints.length) {
                double accumulativeProbability = (double)(completed += this.buckets[index]) / (double)this.numberResults;
                cdfPoints[index] = 100.0 * accumulativeProbability;
                if (accumulativeProbability > 1.001) {
                    BioPEPAException e = new BioPEPAException("cdf value above one");
                    throw e;
                }
                ++index;
            }
            return cdfPoints;
        }

        public double[] computePdf() {
            double[] pdfPoints = new double[this.buckets.length];
            int index = 0;
            while (index < pdfPoints.length) {
                pdfPoints[index] = 100.0 * ((double)this.buckets[index] / (double)this.numberResults);
                ++index;
            }
            return pdfPoints;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SimulationTraceLog {
        public void traceLogHeader(HashMap<String, Number> var1) throws IOException;

        public void traceLogFooter(Result var1) throws IOException;

        public void displayComponentCounts(HashMap<String, Number> var1) throws IOException;

        public void displayEnabledReaction(String var1, double var2) throws IOException;

        public void startEvent(String var1, double var2) throws BioPEPAException, IOException;

        public void outputComponentUpdate(String var1, int var2) throws IOException;

        public void endEvent(double var1, double var3, HashMap<String, Number> var5) throws IOException;

        public void reportDeadlocked() throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface TraceResults
    extends Result {
        public boolean updateResults(double var1, HashMap<String, Number> var3);

        public void completeDeadLock(HashMap<String, Number> var1);

        public void aggregateResults(TraceResults var1);

        public int numberOfAggregatedResults();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TraceResultsFixedTime
    extends BasicResult
    implements TraceResults {
        protected int ourTimeIndex;
        int numberOfResults;

        @Override
        public int numberOfAggregatedResults() {
            return this.numberOfResults;
        }

        @Override
        public void aggregateResults(TraceResults extraResults) {
            int numberExtraResults = extraResults.numberOfAggregatedResults();
            int totalNumberResults = this.numberOfResults + numberExtraResults;
            int nameIndex = 0;
            while (nameIndex < this.results.length) {
                double[] theseResults = this.results[nameIndex];
                double[] newResults = extraResults.getTimeSeries(nameIndex);
                int timeIndex = 0;
                while (timeIndex < theseResults.length) {
                    double newValue;
                    this.results[nameIndex][timeIndex] = newValue = (theseResults[timeIndex] * (double)this.numberOfResults + newResults[timeIndex] * (double)numberExtraResults) / (double)totalNumberResults;
                    ++timeIndex;
                }
                ++nameIndex;
            }
            this.numberOfResults = totalNumberResults;
        }

        TraceResultsFixedTime(String[] compNames, double startTime) {
            this.componentNames = compNames;
            int timepointsSize = 0;
            double fakeTime = startTime;
            while (fakeTime < SimulationTracer.this.timeLimit) {
                ++timepointsSize;
                fakeTime += SimulationTracer.this.dataPointStep;
            }
            this.timePoints = new double[timepointsSize];
            fakeTime = startTime;
            int index = 0;
            while (index < timepointsSize) {
                this.timePoints[index] = fakeTime;
                fakeTime += SimulationTracer.this.dataPointStep;
                ++index;
            }
            this.results = new double[this.componentNames.length][];
            int i = 0;
            while (i < this.componentNames.length) {
                this.results[i] = new double[timepointsSize];
                ++i;
            }
            this.ourTimeIndex = 0;
            this.numberOfResults = 1;
        }

        @Override
        public boolean updateResults(double newTotalTime, HashMap<String, Number> componentCounts) {
            while (this.ourTimeIndex < this.timePoints.length && this.timePoints[this.ourTimeIndex] <= newTotalTime) {
                int index = 0;
                while (index < this.componentNames.length) {
                    double thisValue;
                    this.results[index][this.ourTimeIndex] = thisValue = componentCounts.get(this.componentNames[index]).doubleValue();
                    ++index;
                }
                ++this.ourTimeIndex;
            }
            return true;
        }

        @Override
        public void completeDeadLock(HashMap<String, Number> componentCounts) {
            this.updateResults(SimulationTracer.this.timeLimit, componentCounts);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TraceResultsUnlimitedTime
    implements TraceResults {
        private String[] componentNames;
        private LinkedList<Number>[] results;
        private LinkedList<Number> timepoints;
        private double ourTimeIndex;
        int numberOfResults;
        protected double simulationRunTime;

        @Override
        public int numberOfAggregatedResults() {
            return this.numberOfResults;
        }

        @Override
        public void aggregateResults(TraceResults extraResults) {
            int numberExtraResults = extraResults.numberOfAggregatedResults();
            int totalNumberResults = this.numberOfResults + numberExtraResults;
            int nameIndex = 0;
            while (nameIndex < this.results.length) {
                LinkedList<Number> theseResults = this.results[nameIndex];
                double[] newResults = extraResults.getTimeSeries(nameIndex);
                LinkedList<Double> updatedResults = new LinkedList<Double>();
                int timeIndex = 0;
                while (timeIndex < Math.min(newResults.length, theseResults.size())) {
                    double newValue = (theseResults.get(timeIndex).doubleValue() * (double)this.numberOfResults + newResults[timeIndex] * (double)numberExtraResults) / (double)totalNumberResults;
                    updatedResults.addLast(newValue);
                    ++timeIndex;
                }
                this.results[nameIndex] = updatedResults;
                ++nameIndex;
            }
            this.numberOfResults = totalNumberResults;
        }

        TraceResultsUnlimitedTime(String[] compNames, double startTime) {
            this.componentNames = compNames;
            this.timepoints = new LinkedList();
            this.results = new LinkedList[this.componentNames.length];
            int index = 0;
            while (index < this.componentNames.length) {
                this.results[index] = new LinkedList();
                ++index;
            }
            this.numberOfResults = 1;
        }

        @Override
        public boolean updateResults(double newTotalTime, HashMap<String, Number> componentCounts) {
            while (this.ourTimeIndex <= newTotalTime) {
                this.timepoints.addLast(this.ourTimeIndex);
                int index = 0;
                while (index < this.componentNames.length) {
                    double thisValue = componentCounts.get(this.componentNames[index]).doubleValue();
                    this.results[index].addLast(thisValue);
                    ++index;
                }
                this.ourTimeIndex += SimulationTracer.this.dataPointStep;
            }
            return true;
        }

        @Override
        public void completeDeadLock(HashMap<String, Number> componentCounts) {
            this.updateResults(SimulationTracer.this.timeLimit, componentCounts);
        }

        @Override
        public String[] getActionNames() {
            return null;
        }

        @Override
        public double getActionThroughput(int index) {
            return 0.0;
        }

        @Override
        public String[] getComponentNames() {
            return this.componentNames;
        }

        @Override
        public Map<String, Number> getModelParameters() {
            return null;
        }

        @Override
        public double getPopulation(int index) {
            return this.results[index].getLast().doubleValue();
        }

        @Override
        public String getSimulatorName() {
            return "Trace-simulation";
        }

        @Override
        public Map<String, Number> getSimulatorParameters() {
            return null;
        }

        private double[] convertLinkedList(LinkedList<Number> list) {
            double[] values = new double[list.size()];
            int index = 0;
            for (Number value : list) {
                values[index] = value.doubleValue();
                ++index;
            }
            return values;
        }

        @Override
        public double[] getTimePoints() {
            return this.convertLinkedList(this.timepoints);
        }

        @Override
        public double[] getTimeSeries(int index) {
            return this.convertLinkedList(this.results[index]);
        }

        @Override
        public boolean throughputSupported() {
            return false;
        }

        @Override
        public void setSimulationRunTime(double s) {
            this.simulationRunTime = s;
        }

        @Override
        public double getSimulationRunTime() {
            return this.simulationRunTime;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void normaliseResult(double[] newTimePoints) {
            newResults = new LinkedList[this.componentNames.length];
            index = 0;
            while (index < this.componentNames.length) {
                newResults[index] = new LinkedList<E>();
                ++index;
            }
            oldIndex = 0;
            newIndex = 0;
            ** GOTO lbl20
            {
                ++oldIndex;
                do {
                    if (this.timepoints.get(oldIndex).doubleValue() < newTimePoints[newIndex] && oldIndex < this.timepoints.size()) continue block1;
                    nameIndex = 0;
                    while (nameIndex < this.componentNames.length) {
                        newResults[nameIndex].add(this.results[nameIndex].get(oldIndex));
                        ++nameIndex;
                    }
                    ++newIndex;
lbl20:
                    // 2 sources

                } while (newIndex < newTimePoints.length);
            }
            this.results = newResults;
            this.timepoints = new LinkedList<E>();
            timeIndex = 0;
            while (timeIndex < newTimePoints.length) {
                this.timepoints.add(newTimePoints[timeIndex]);
                ++timeIndex;
            }
        }

        @Override
        public void concatenateResults(Result result) throws BioPEPAException {
            throw new BioPEPAException("Concatenation of results unsupported");
        }
    }
}

