/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.sba.export;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.interfaces.Exporter;
import uk.ac.ed.inf.biopepa.core.interfaces.Result;
import uk.ac.ed.inf.biopepa.core.sba.FileStringConsumer;
import uk.ac.ed.inf.biopepa.core.sba.LineStringBuilder;
import uk.ac.ed.inf.biopepa.core.sba.PhaseLine;
import uk.ac.ed.inf.biopepa.core.sba.SBAComponentBehaviour;
import uk.ac.ed.inf.biopepa.core.sba.SBAModel;
import uk.ac.ed.inf.biopepa.core.sba.SBAReaction;
import uk.ac.ed.inf.biopepa.core.sba.StringConsumer;
import uk.ac.ed.inf.biopepa.core.sba.export.SimulationTracer;

public class TraviandoExport
implements Exporter {
    private static final String description;
    private SBAModel model;
    private int numberFiringsLimit = Integer.MAX_VALUE;
    private double timeLimit = Double.MAX_VALUE;
    private double dataPointStep = 1.0;
    private PhaseLine[] phaseLines;
    private boolean displayComments = true;
    private String modelComment = "Trace generated automagically from BioPEPA Eclipse Plugin";
    private String modelName = null;
    private Result simulationResults;

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("Traviando export");
        description = sb.toString();
    }

    public void setDataPointStep(double newDataPointStep) {
        this.dataPointStep = newDataPointStep;
    }

    public void setPhaseLines(PhaseLine[] phaseLines) {
        this.phaseLines = phaseLines;
    }

    public void setFiringsLimit(int newLimit) {
        this.numberFiringsLimit = newLimit;
    }

    public void setTimeLimit(double newLimit) {
        this.timeLimit = newLimit;
    }

    public void setDisplayComments(boolean b) {
        this.displayComments = b;
    }

    public void setModelComment(String comment) {
        this.modelComment = comment;
    }

    public String canExport() {
        if (this.model == null) {
            throw new IllegalStateException("Model has not been set using setModel/1");
        }
        return null;
    }

    public String getDescription() {
        return description;
    }

    public String getExportPrefix() {
        return "xml";
    }

    public String getLongName() {
        return "Traviandor trace analyser";
    }

    public String getShortName() {
        return "Trav";
    }

    public Object requiredDataStructure() {
        return SBAModel.class;
    }

    public void setModel(SBAModel model) throws UnsupportedOperationException {
        if (model == null) {
            throw new NullPointerException("SBA model must be non-null");
        }
        if (this.model != null) {
            throw new IllegalStateException("Model has already been set.");
        }
        this.model = model;
    }

    public void setModel(ModelCompiler compiledModel) {
        throw new UnsupportedOperationException();
    }

    public void setName(String modelName) {
        this.modelName = modelName;
    }

    public Object toDataStructure() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        if (this.model == null) {
            throw new IllegalStateException("Model has not been set using setModel/1");
        }
        LineStringBuilder travSb = new LineStringBuilder();
        try {
            TraviandoTraceLog traceLog = new TraviandoTraceLog(travSb, this.model);
            traceLog.setModelName(this.modelName);
            traceLog.setModelComment(this.modelComment);
            traceLog.setDisplayComments(this.displayComments);
            SimulationTracer simTracer = new SimulationTracer(this.model);
            simTracer.generateSimulationTrace(traceLog);
        }
        catch (BioPEPAException e) {
            travSb.appendLine(e.getMessage());
        }
        catch (IOException e) {
            travSb.appendLine(e.getMessage());
        }
        return travSb.toString();
    }

    public Result getSimulationResults() {
        return this.simulationResults;
    }

    public void exportToFile(String filename) throws IOException {
        FileStringConsumer fsc = new FileStringConsumer(filename);
        try {
            fsc.openStringConsumer();
            TraviandoTraceLog traceLog = new TraviandoTraceLog(fsc, this.model);
            traceLog.setModelName(this.modelName);
            traceLog.setModelComment(this.modelComment);
            traceLog.setDisplayComments(this.displayComments);
            SimulationTracer simTracer = new SimulationTracer(this.model);
            simTracer.setTimeLimit(this.timeLimit);
            simTracer.setFiringsLimit(this.numberFiringsLimit);
            simTracer.setDataPointStep(this.dataPointStep);
            simTracer.setPhaseLines(this.phaseLines);
            simTracer.generateSimulationTrace(traceLog);
            this.simulationResults = simTracer.getSimulationResults();
        }
        catch (BioPEPAException e) {
            fsc.appendLine(e.getMessage());
        }
        fsc.closeStringConsumer();
    }

    public void justDrawTheGraph() throws IOException {
        try {
            SimulationTracer simTracer = new SimulationTracer(this.model);
            SimulationTracer.NullTraceLog traceLog = new SimulationTracer.NullTraceLog();
            simTracer.setTimeLimit(this.timeLimit);
            simTracer.setFiringsLimit(this.numberFiringsLimit);
            simTracer.setDataPointStep(this.dataPointStep);
            simTracer.setPhaseLines(this.phaseLines);
            simTracer.generateSimulationTrace(traceLog);
            this.simulationResults = simTracer.getSimulationResults();
        }
        catch (BioPEPAException bioPEPAException) {
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TraviandoTraceLog
    implements SimulationTracer.SimulationTraceLog {
        private StringConsumer scon;
        private boolean completeConsumer = true;
        private HashMap<String, String> compVarNames;
        private HashMap<String, String> reactionIdMap;
        private HashMap<String, String> compIdMap;
        private String[] componentNames;
        private SBAReaction[] sbaReactions;
        private String modelName = "";
        private String modelComment = "";
        private boolean displayComments = false;

        public void setCompleteConsumer(boolean complete) {
            this.completeConsumer = complete;
        }

        public TraviandoTraceLog(StringConsumer scon, SBAModel model) {
            this.scon = scon;
            this.compVarNames = new HashMap();
            this.reactionIdMap = new HashMap();
            this.compIdMap = new HashMap();
            this.componentNames = model.getComponentNames();
            this.sbaReactions = model.getReactions();
        }

        public void setModelName(String name) {
            this.modelName = name;
        }

        public void setModelComment(String comment) {
            this.modelComment = comment;
        }

        public void setDisplayComments(boolean display) {
            this.displayComments = display;
        }

        @Override
        public void traceLogFooter(Result result) throws IOException {
            this.scon.appendLine("</Sequence>");
            this.scon.appendLine("</Trace>");
            if (this.completeConsumer) {
                this.scon.closeStringConsumer();
            }
        }

        @Override
        public void traceLogHeader(HashMap<String, Number> componentCounts) throws IOException {
            if (this.completeConsumer) {
                this.scon.openStringConsumer();
            }
            this.scon.appendLine("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
            this.scon.appendLine("<!-- Trace file of model " + this.modelName + " -->");
            this.scon.appendLine("<Trace model=\"" + this.modelName + "\" generator=\"BioPEPA-Eclipse-Plugin\" >");
            this.scon.appendLine("<Comment> " + this.modelComment + " </Comment>");
            this.scon.appendLine("<!-- declaration of processes -->");
            int i = 0;
            while (i < this.componentNames.length) {
                String procName = this.componentNames[i];
                this.scon.appendLine("<Process id=\"" + i + "\" name=\"" + procName + "\" >");
                int index = 0;
                while (index < this.sbaReactions.length) {
                    SBAReaction reaction = this.sbaReactions[index];
                    boolean containsThis = false;
                    boolean containsOther = false;
                    for (SBAComponentBehaviour product : reaction.getProducts()) {
                        String pName = product.getName();
                        if (procName.equals(pName)) {
                            containsThis = true;
                            continue;
                        }
                        containsOther = true;
                    }
                    for (SBAComponentBehaviour reactant : reaction.getReactants()) {
                        if (procName.equals(reactant.getName())) {
                            containsThis = true;
                            continue;
                        }
                        containsOther = true;
                    }
                    if (containsThis && !containsOther) {
                        String idName = "a_" + index;
                        String rName = reaction.getName();
                        this.scon.appendLine("<Action id=\"" + idName + "\" name =\"" + rName + "\" />");
                        this.reactionIdMap.put(rName, idName);
                    }
                    ++index;
                }
                this.compIdMap.put(procName, Integer.toString(i));
                String popName = "pop_" + i;
                this.scon.appendLine("<Var id = \"" + popName + "\" name=\"" + procName + "\" />");
                this.scon.appendLine("</Process>");
                this.compVarNames.put(procName, popName);
                ++i;
            }
            this.scon.appendLine("<Interactions>");
            int index = 0;
            while (index < this.sbaReactions.length) {
                SBAReaction reaction = this.sbaReactions[index];
                List<SBAComponentBehaviour> products = reaction.getProducts();
                List<SBAComponentBehaviour> reactants = reaction.getReactants();
                String reactionId = "sa_" + index;
                if (products.size() + reactants.size() > 1) {
                    this.scon.appendLine("<Undiraction id=\"" + reactionId + "\" name=\"" + reaction.getName() + "\" >");
                    this.reactionIdMap.put(reaction.getName(), reactionId);
                    for (SBAComponentBehaviour p : products) {
                        this.scon.appendLine("<Touch>" + this.compIdMap.get(p.getName()) + "</Touch>");
                    }
                    for (SBAComponentBehaviour r : reactants) {
                        this.scon.appendLine("<Touch>" + this.compIdMap.get(r.getName()) + "</Touch>");
                    }
                    this.scon.appendLine("</Undiraction>");
                }
                ++index;
            }
            this.scon.appendLine("</Interactions>");
            this.scon.appendLine("<Sequence type=\"not-sure\">");
            this.scon.appendLine("<S>");
            String[] stringArray = this.componentNames;
            int n = this.componentNames.length;
            int n2 = 0;
            while (n2 < n) {
                String compName = stringArray[n2];
                String compId = this.compVarNames.get(compName);
                Number compCount = componentCounts.get(compName);
                this.outputAssignment(compId, compCount.intValue());
                ++n2;
            }
            this.scon.appendLine("</S>");
        }

        private void outputComponentCounts(HashMap<String, Number> componentCounts) throws IOException {
            this.scon.appendLine(" <!-- ");
            for (Map.Entry<String, Number> entry : componentCounts.entrySet()) {
                this.scon.appendLine("Component: " + entry.getKey() + " = " + entry.getValue());
            }
            this.scon.appendLine(" --> ");
        }

        private void outputAssignment(String procName, int count) throws IOException {
            this.scon.appendLine("<V id=\"" + procName + "\" val=\"" + count + "\" />");
        }

        @Override
        public void displayComponentCounts(HashMap<String, Number> componentCounts) throws IOException {
            if (this.displayComments) {
                this.outputComponentCounts(componentCounts);
            }
        }

        @Override
        public void displayEnabledReaction(String reactionName, double rateValue) throws IOException {
            if (this.displayComments) {
                this.scon.appendLine(" <!-- " + reactionName + " has rate " + rateValue + " (which is : " + ") --> ");
            }
        }

        @Override
        public void startEvent(String rname, double totalTime) throws BioPEPAException, IOException {
            String idName = this.reactionIdMap.get(rname);
            if (idName == null) {
                throw new BioPEPAException("Reaction: " + rname + " not found in reaction id map");
            }
            this.scon.appendLine("<A id=\"" + idName + "\" t=\"" + totalTime + "\"" + " i=\"" + rname + ".1\" >");
        }

        @Override
        public void outputComponentUpdate(String rName, int newValue) throws IOException {
            this.outputAssignment(this.compVarNames.get(rName), newValue);
        }

        @Override
        public void endEvent(double thisDelay, double totalRate, HashMap<String, Number> componentCounts) throws IOException {
            if (this.displayComments) {
                this.scon.appendLine(" <!-- This firing's delay is: " + thisDelay + " --> ");
                this.scon.appendLine(" <!-- The rate is: " + totalRate + " --> ");
                this.outputComponentCounts(componentCounts);
            }
            this.scon.appendLine("</A>");
        }

        @Override
        public void reportDeadlocked() throws IOException {
            this.scon.appendLine("<!-- Total rate = zero, deadlocked state -->");
        }
    }
}

