/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import uk.ac.ed.inf.biopepa.ui.BioPEPAModelImpl;
import uk.ac.ed.inf.biopepa.ui.editors.BioPEPAEditor;
import uk.ac.ed.inf.biopepa.ui.interfaces.BioPEPAModel;

public class BioPEPAManager {
    private Map<IResource, BioPEPAModel> map = new HashMap<IResource, BioPEPAModel>();
    private Map<BioPEPAModel, Integer> editorCount = new HashMap<BioPEPAModel, Integer>();
    private IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                IResourceDelta resourceDelta = event.getDelta();
                if (resourceDelta == null) {
                    return;
                }
                resourceDelta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (!BioPEPAManager.isValidBioPEPAFile(delta.getResource())) {
                            return true;
                        }
                        switch (delta.getKind()) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                if (!BioPEPAManager.this.map.containsKey(delta.getResource())) break;
                                ((BioPEPAModel)BioPEPAManager.this.map.remove(delta.getResource())).dispose();
                                break;
                            }
                            case 4: 
                            case 256: {
                                if ((delta.getFlags() & 0x100) == 0 || !BioPEPAManager.this.map.containsKey(delta.getResource())) break;
                                ((BioPEPAModel)BioPEPAManager.this.map.get(delta.getResource())).parse();
                                break;
                            }
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    };

    public static boolean isValidBioPEPAFile(IResource resource) {
        if (resource == null) {
            return false;
        }
        return resource.getType() == 1 && resource.getFileExtension().equals("biopepa");
    }

    BioPEPAManager() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener, 10);
    }

    public void editorOpened(BioPEPAEditor editor) {
        BioPEPAModel model = editor.getModel();
        Integer count = this.editorCount.get(model);
        if (count == null) {
            this.editorCount.put(model, 1);
        } else {
            this.editorCount.put(model, count + 1);
        }
    }

    public void editorClosed(BioPEPAEditor editor) {
        BioPEPAModel model = editor.getModel();
        Integer count = this.editorCount.get(model);
        if (count == 1) {
            this.editorCount.remove(model);
            IResource resource = null;
            for (Map.Entry<IResource, BioPEPAModel> me : this.map.entrySet()) {
                if (me.getValue() != model) continue;
                resource = me.getKey();
                break;
            }
            this.map.remove(resource);
            model.dispose();
        } else {
            this.editorCount.put(model, count - 1);
        }
    }

    public BioPEPAModel getModel(IResource resource) {
        if (resource == null || !resource.exists()) {
            return null;
        }
        BioPEPAModel model = this.map.get(resource);
        if (model == null && BioPEPAManager.isValidBioPEPAFile(resource)) {
            try {
                model = new BioPEPAModelImpl(resource);
                this.map.put(resource, model);
                model.parse();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return model;
    }

    public void shutdown() {
        for (BioPEPAModel model : this.map.values()) {
            model.dispose();
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
    }
}

