/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui.editors;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import uk.ac.ed.inf.biopepa.ui.BioPEPAPlugin;
import uk.ac.ed.inf.biopepa.ui.editors.BioPEPADocumentProvider;
import uk.ac.ed.inf.biopepa.ui.editors.BioPEPAViewerConfiguration;
import uk.ac.ed.inf.biopepa.ui.interfaces.BioPEPAModel;
import uk.ac.ed.inf.biopepa.ui.views.BioPEPAOutline;

public class BioPEPAEditor
extends TextEditor {
    BioPEPAModel model;
    BioPEPAOutline outline = null;

    public BioPEPAEditor() {
        this.setSourceViewerConfiguration(new BioPEPAViewerConfiguration());
        this.setDocumentProvider((IDocumentProvider)new BioPEPADocumentProvider());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        IResource resource = (IResource)input.getAdapter(IResource.class);
        this.model = BioPEPAPlugin.getDefault().getBioPEPAManager().getModel(resource);
        BioPEPAPlugin.getDefault().getBioPEPAManager().editorOpened(this);
        BioPEPAEditor.checkPerspective(site.getPage());
    }

    public BioPEPAModel getModel() {
        return this.model;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContentOutlinePage.class) {
            if (this.outline == null || this.outline.getControl() == null || this.outline.getControl().isDisposed()) {
                this.outline = new BioPEPAOutline(this.model);
                this.model.addListener(this.outline);
            }
            return this.outline;
        }
        return super.getAdapter(adapter);
    }

    public void dispose() {
        super.dispose();
        BioPEPAPlugin.getDefault().getBioPEPAManager().editorClosed(this);
    }

    static void checkPerspective(IWorkbenchPage page) {
        boolean result;
        IPerspectiveDescriptor descriptor = page.getPerspective();
        if (descriptor == null) {
            return;
        }
        String currentPerspective = descriptor.getId();
        if (!currentPerspective.equals("uk.ac.ed.inf.biopepa.eclipse.ui.BioPEPAPerspective") && (result = MessageDialog.openQuestion((Shell)page.getWorkbenchWindow().getShell(), (String)"Switch to Bio-PEPA Perspective", (String)"This resource is associated with the Bio-PEPA perspective. Would you like to switch to the Bio-PEPA Perspective now?"))) {
            IWorkbench workbench = BioPEPAPlugin.getDefault().getWorkbench();
            page.setPerspective(workbench.getPerspectiveRegistry().findPerspectiveWithId("uk.ac.ed.inf.biopepa.eclipse.ui.BioPEPAPerspective"));
        }
    }
}

