/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui.views;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import uk.ac.ed.inf.biopepa.core.compiler.CompartmentData;
import uk.ac.ed.inf.biopepa.core.compiler.ComponentNode;
import uk.ac.ed.inf.biopepa.core.sba.SBAComponentBehaviour;
import uk.ac.ed.inf.biopepa.core.sba.SBAModel;
import uk.ac.ed.inf.biopepa.core.sba.SBAReaction;
import uk.ac.ed.inf.biopepa.ui.BioPEPAEvent;
import uk.ac.ed.inf.biopepa.ui.interfaces.BioPEPAListener;
import uk.ac.ed.inf.biopepa.ui.interfaces.BioPEPAModel;

public class BioPEPAOutline
extends ContentOutlinePage
implements BioPEPAListener {
    private Runnable runnable = new Runnable(){

        public void run() {
            TreeViewer tv = BioPEPAOutline.this.getTreeViewer();
            tv.setInput((Object)BioPEPAOutline.this.bt);
            if (BioPEPAOutline.this.expanded != null) {
                tv.setExpandedElements(BioPEPAOutline.this.expanded);
            }
        }
    };
    private BioPEPAModel model;
    private BioPEPATree[] bt;
    private Object[] expanded;

    public BioPEPAOutline(BioPEPAModel model) {
        this.model = model;
    }

    public void modelChanged(BioPEPAEvent event) {
        if (event.getEvent().equals((Object)BioPEPAEvent.Event.PARSED) || event.getEvent().equals((Object)BioPEPAEvent.Event.MODIFIED)) {
            this.refreshTree();
        } else if (event.getEvent().equals((Object)BioPEPAEvent.Event.EXCEPTION)) {
            this.refreshTree();
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getTreeViewer().setContentProvider((IContentProvider)new OutlineContentProvider());
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)new OutlineLabelProvider());
        this.refreshTree();
    }

    private void refreshTree() {
        if (this.model.getSBAModel() == null) {
            this.bt = new BioPEPATree[1];
            this.bt[0] = new BioPEPATree();
            this.bt[0].name = "Non-parseable Bio-PEPA model";
        } else {
            String name;
            int sIndex;
            SBAReaction[] reaction;
            Object potentialReactant22;
            int isProduct;
            int isReactant;
            this.expanded = null;
            if (this.bt != null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        TreeViewer tv = BioPEPAOutline.this.getTreeViewer();
                        BioPEPAOutline.this.expanded = tv.getExpandedElements();
                    }
                });
            }
            SBAModel sbaModel = this.model.getSBAModel();
            CompartmentData[] compartments = sbaModel.getCompartments();
            ComponentNode[] species = sbaModel.getComponents();
            SBAReaction[] reactions = sbaModel.getReactions();
            int c = 0;
            boolean needCompartmentTree = compartments.length != 0;
            boolean[] speciesSources = new boolean[species.length];
            boolean[] speciesSinks = new boolean[species.length];
            int numberSources = 0;
            int numberSinks = 0;
            int sIndex2 = 0;
            while (sIndex2 < species.length) {
                isReactant = 0;
                isProduct = 0;
                potentialReactant22 = species[sIndex2];
                String sourceName = potentialReactant22.getName();
                SBAReaction[] sBAReactionArray = reactions;
                int n = reactions.length;
                int n2 = 0;
                while (n2 < n) {
                    reaction = sBAReactionArray[n2];
                    for (SBAComponentBehaviour cb : reaction.getReactants()) {
                        if (!cb.getName().equals(sourceName) || !cb.getType().equals((Object)SBAComponentBehaviour.Type.REACTANT)) continue;
                        isReactant = 1;
                    }
                    for (SBAComponentBehaviour cb : reaction.getProducts()) {
                        if (!cb.getName().equals(sourceName)) continue;
                        isProduct = 1;
                    }
                    speciesSources[sIndex2] = isReactant != 0 && isProduct == 0;
                    speciesSinks[sIndex2] = isReactant == 0 && isProduct != 0;
                    ++n2;
                }
                ++sIndex2;
            }
            potentialReactant22 = speciesSources;
            isProduct = speciesSources.length;
            isReactant = 0;
            while (isReactant < isProduct) {
                boolean sourceBool = potentialReactant22[isReactant];
                if (sourceBool) {
                    ++numberSources;
                }
                ++isReactant;
            }
            potentialReactant22 = speciesSinks;
            isProduct = speciesSinks.length;
            isReactant = 0;
            while (isReactant < isProduct) {
                boolean sinkBool = potentialReactant22[isReactant];
                if (sinkBool) {
                    ++numberSinks;
                }
                ++isReactant;
            }
            LinkedList<SBAReaction> sourceActions = new LinkedList<SBAReaction>();
            LinkedList<SBAReaction> sinkActions = new LinkedList<SBAReaction>();
            reaction = reactions;
            int sourceName = reactions.length;
            int potentialReactant22 = 0;
            while (potentialReactant22 < sourceName) {
                SBAReaction reaction2 = reaction[potentialReactant22];
                List reactants = reaction2.getReactants();
                List products = reaction2.getProducts();
                boolean isSink = false;
                boolean isSource = true;
                for (SBAComponentBehaviour cb : reactants) {
                    if (!cb.getType().equals((Object)SBAComponentBehaviour.Type.REACTANT)) continue;
                    isSource = false;
                    isSink = true;
                    break;
                }
                if (isSink && products.isEmpty()) {
                    sinkActions.add(reaction2);
                }
                if (isSource && !products.isEmpty()) {
                    sourceActions.add(reaction2);
                }
                ++potentialReactant22;
            }
            int numberChildren = 1 + (needCompartmentTree ? 1 : 0) + 1 + (numberSources > 0 ? 1 : 0) + (numberSinks > 0 ? 1 : 0) + (sourceActions.size() > 0 ? 1 : 0) + (sinkActions.size() > 0 ? 1 : 0);
            this.bt = new BioPEPATree[numberChildren];
            int i = 0;
            while (i < this.bt.length) {
                this.bt[i] = new BioPEPATree();
                ++i;
            }
            BioPEPATree bt2 = null;
            if (needCompartmentTree) {
                this.bt[c].name = String.valueOf(compartments.length) + " Location" + (compartments.length > 1 ? "s" : "");
                this.bt[c].id = "Locations";
                int i2 = 0;
                while (i2 < compartments.length) {
                    CompartmentData cd = compartments[i2];
                    bt2 = new BioPEPATree();
                    bt2.setNameAndID(cd.getName());
                    bt2.parent = this.bt[c];
                    BioPEPATree bt3 = new BioPEPATree();
                    bt3.setNameAndID(cd.getType().toString());
                    bt2.children.add(bt3);
                    bt3 = new BioPEPATree();
                    bt3.setNameAndID("Volume = " + cd.getVolume());
                    bt3.parent = bt2;
                    bt2.children.add(bt3);
                    this.bt[c].children.add(bt2);
                    if (!Double.isNaN(cd.getStepSize())) {
                        bt3 = new BioPEPATree();
                        bt3.setNameAndID("Step-size = " + cd.getStepSize());
                        bt2.children.add(bt3);
                    }
                    ++i2;
                }
                ++c;
            }
            this.bt[c].name = String.valueOf(species.length) + " Species";
            this.bt[c].id = "Species";
            String lastname = null;
            bt2 = null;
            int i3 = 0;
            while (i3 < species.length) {
                if (!species[i3].getComponent().equals(lastname)) {
                    if (bt2 != null && bt2.children.size() > 1) {
                        bt2.name = "(" + bt2.children.size() + ") " + bt2.name;
                    }
                    bt2 = new BioPEPATree();
                    bt2.setNameAndID(species[i3].getComponent());
                    bt2.parent = this.bt[c];
                    lastname = bt2.name;
                    this.bt[c].children.add(bt2);
                }
                StringBuilder sb = new StringBuilder();
                BioPEPATree bt3 = new BioPEPATree();
                if (needCompartmentTree) {
                    sb.append("in ");
                    sb.append(species[i3].getCompartment().getName());
                    sb.append(" ");
                }
                sb.append("with initial #molecules = ");
                sb.append(species[i3].getCount());
                if (speciesSources[i3]) {
                    sb.append(" (is-source)");
                }
                if (speciesSinks[i3]) {
                    sb.append(" (is-sink)");
                }
                bt3.setNameAndID(sb.toString());
                bt3.parent = bt2;
                bt2.children.add(bt3);
                ++i3;
            }
            if (bt2.children.size() > 1) {
                bt2.name = "(" + bt2.children.size() + ") " + bt2.name;
            }
            this.bt[++c].name = String.valueOf(reactions.length) + " Reaction" + (reactions.length > 1 ? "s" : "");
            this.bt[c].id = "Reactions";
            i3 = 0;
            while (i3 < reactions.length) {
                bt2 = new BioPEPATree();
                String enabled = reactions[i3].isEnabled() ? "" : "     disabled";
                bt2.setNameAndID(String.valueOf(reactions[i3].toString()) + enabled);
                bt2.parent = this.bt[c];
                this.bt[c].children.add(bt2);
                ++i3;
            }
            if (numberSources > 0) {
                this.bt[++c].name = String.valueOf(numberSources) + " Sources";
                this.bt[c].id = "Sources";
                sIndex = 0;
                while (sIndex < species.length) {
                    if (speciesSources[sIndex]) {
                        BioPEPATree sourceTree = new BioPEPATree();
                        ComponentNode comp = species[sIndex];
                        sourceTree.setNameAndID(comp.getName());
                        sourceTree.parent = this.bt[c];
                        this.bt[c].children.add(sourceTree);
                    }
                    ++sIndex;
                }
            }
            if (numberSinks > 0) {
                this.bt[++c].name = String.valueOf(numberSinks) + " Sinks";
                this.bt[c].id = "Sinks";
                sIndex = 0;
                while (sIndex < species.length) {
                    if (speciesSinks[sIndex]) {
                        BioPEPATree sinkTree = new BioPEPATree();
                        ComponentNode comp = species[sIndex];
                        sinkTree.setNameAndID(comp.getName());
                        sinkTree.parent = this.bt[c];
                        this.bt[c].children.add(sinkTree);
                    }
                    ++sIndex;
                }
            }
            if (sourceActions.size() > 0) {
                this.bt[++c].name = String.valueOf(sourceActions.size()) + " source actions";
                this.bt[c].id = "source actions";
                for (SBAReaction reaction3 : sourceActions) {
                    BioPEPATree sourceTree = new BioPEPATree();
                    name = reaction3.toString();
                    sourceTree.setNameAndID(name);
                    sourceTree.parent = this.bt[c];
                    this.bt[c].children.add(sourceTree);
                }
            }
            if (sinkActions.size() > 0) {
                this.bt[++c].name = String.valueOf(sinkActions.size()) + " sink actions";
                this.bt[c].id = "sink actions";
                for (SBAReaction reaction4 : sinkActions) {
                    BioPEPATree sinkTree = new BioPEPATree();
                    name = reaction4.toString();
                    sinkTree.setNameAndID(name);
                    sinkTree.parent = this.bt[c];
                    this.bt[c].children.add(sinkTree);
                }
            }
        }
        Display.getDefault().asyncExec(this.runnable);
    }

    private class BioPEPATree {
        String name;
        String id;
        List<BioPEPATree> children = new ArrayList<BioPEPATree>();
        BioPEPATree parent = null;

        private BioPEPATree() {
        }

        public void setNameAndID(String name) {
            this.name = name;
            this.id = name;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof BioPEPATree)) {
                return false;
            }
            BioPEPATree bpt = (BioPEPATree)o;
            return this.id != null && bpt.id != null && this.id.equals(bpt.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }

    private class OutlineContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private OutlineContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return ((BioPEPATree)parentElement).children.toArray();
        }

        public Object getParent(Object element) {
            return ((BioPEPATree)element).parent;
        }

        public boolean hasChildren(Object element) {
            return ((BioPEPATree)element).children.size() != 0;
        }
    }

    private class OutlineLabelProvider
    extends LabelProvider {
        private OutlineLabelProvider() {
        }

        public String getText(Object element) {
            return ((BioPEPATree)element).name;
        }
    }
}

