/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui.wizards.export;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.interfaces.Exporter;
import uk.ac.ed.inf.biopepa.core.sba.SBAModel;
import uk.ac.ed.inf.biopepa.core.sba.export.Exporters;
import uk.ac.ed.inf.biopepa.ui.interfaces.BioPEPAModel;

public class ExportPage
extends WizardPage {
    public static final String name = "";
    private String optionsTitle = "Export options for ";
    Exporter exporter = null;
    Group description;
    Label descriptiveText;
    BioPEPAModel model;

    protected ExportPage(BioPEPAModel model) {
        super(name);
        this.setTitle("BioPEPA Export Wizard");
        this.setDescription("Please select the format you would like to export the Bio-PEPA file to.");
        this.model = model;
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        final Combo exportCombo = new Combo(composite, 8);
        this.description = new Group(composite, 0);
        this.description.setText("Description");
        this.descriptiveText = new Label((Composite)this.description, 64);
        Group exportOptions = new Group(composite, 0);
        exportOptions.setText(this.optionsTitle);
        final String[] choices = Exporters.getShortNames();
        exportCombo.setItems(choices);
        exportCombo.select(0);
        this.exporter = Exporters.getSolverInstance((String)choices[0]);
        this.checkPage();
        exportCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int i = exportCombo.getSelectionIndex();
                if (i == -1) {
                    return;
                }
                ExportPage.this.exporter = Exporters.getSolverInstance((String)choices[i]);
                ExportPage.this.checkPage();
            }
        });
        composite.setLayout((Layout)new FormLayout());
        this.description.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        exportCombo.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment((Control)exportCombo);
        this.description.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        this.descriptiveText.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.description);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        exportOptions.setLayoutData((Object)formData);
        Composite exportParent = new Composite((Composite)exportOptions, 0);
        exportParent.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)composite);
    }

    public void checkPage() {
        this.setPageComplete(false);
        if (this.exporter == null) {
            this.setErrorMessage("Exporter not found. Please try selecting another.");
            return;
        }
        String s = this.exporter.getDescription();
        if (s != null || s != name) {
            this.descriptiveText.setText(s);
            this.description.setVisible(true);
        } else {
            this.description.setVisible(false);
        }
        Object o = this.exporter.requiredDataStructure();
        if (o.equals(ModelCompiler.class)) {
            this.exporter.setModel(this.model.getCompiledModel());
        } else if (o.equals(SBAModel.class)) {
            this.exporter.setModel(this.model.getSBAModel());
        } else {
            this.setErrorMessage("Cannot supply model in an acceptable form to use this exporter. Please try selecting another.");
            return;
        }
        String response = this.exporter.canExport();
        if (response != null) {
            this.setErrorMessage("Cannot use exporter. " + response);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public Exporter getExporter() {
        return this.exporter;
    }
}

