/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui.wizards.export;

import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SaveAsDialog;
import uk.ac.ed.inf.biopepa.core.sba.FileStringConsumer;
import uk.ac.ed.inf.biopepa.core.sba.SBAModel;
import uk.ac.ed.inf.biopepa.core.sba.StringConsumer;
import uk.ac.ed.inf.biopepa.core.sba.export.BioNessieTraceLog;
import uk.ac.ed.inf.biopepa.core.sba.export.ManyTraceLogger;
import uk.ac.ed.inf.biopepa.core.sba.export.SimulationTracer;
import uk.ac.ed.inf.biopepa.core.sba.export.TraviandoExport;
import uk.ac.ed.inf.biopepa.ui.interfaces.BioPEPAModel;
import uk.ac.ed.inf.biopepa.ui.interfaces.IResourceProvider;
import uk.ac.ed.inf.biopepa.ui.wizards.export.SimulationTraceJob;
import uk.ac.ed.inf.biopepa.ui.wizards.timeseries.PhasesPage;

public class TraviandoExportWizard
extends Wizard
implements IResourceProvider {
    BioPEPAModel model;
    private ExportPage exportPage;
    private PhasesPage phasesPage;

    public TraviandoExportWizard(BioPEPAModel model) {
        if (model == null) {
            throw new NullPointerException("Error; model does not exist.");
        }
        this.model = model;
        this.setHelpAvailable(false);
        this.setWindowTitle("Export options for Bio-PEPA");
    }

    public void addPages() {
        this.exportPage = new ExportPage("Export a Traviando Trace");
        this.addPage((IWizardPage)this.exportPage);
        this.phasesPage = new PhasesPage(this.model);
        this.addPage((IWizardPage)this.phasesPage);
    }

    public TraviandoExport.TraviandoTraceLog createTraviandoTraceLogger(int index, IPath traviandoFilePath, SimulationTraceJob traceJob) {
        IPath numberPath = traviandoFilePath.removeFileExtension();
        if (index > 0) {
            numberPath = numberPath.addFileExtension(Integer.toString(index));
        }
        numberPath = numberPath.addFileExtension("xml");
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(numberPath);
        String filePath = file.getLocation().toOSString();
        FileStringConsumer fsc = new FileStringConsumer(filePath);
        TraviandoExport.TraviandoTraceLog travLog = new TraviandoExport.TraviandoTraceLog((StringConsumer)fsc, this.model.getSBAModel());
        travLog.setCompleteConsumer(true);
        String modelName = numberPath.removeFileExtension().lastSegment();
        travLog.setModelName(modelName);
        travLog.setDisplayComments(this.exportPage.getDisplayComments());
        travLog.setModelComment(this.exportPage.getModelComment());
        traceJob.addOutputFile(file);
        return travLog;
    }

    public BioNessieTraceLog createBioNessieTraceLogger(int index, IPath bioNessieFilePath, SimulationTraceJob traceJob) {
        IPath numberPath = bioNessieFilePath.removeFileExtension();
        if (index > 0) {
            numberPath = numberPath.addFileExtension(Integer.toString(index));
        }
        numberPath = numberPath.addFileExtension("bn");
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(numberPath);
        String filePath = file.getLocation().toOSString();
        FileStringConsumer fsc = new FileStringConsumer(filePath);
        BioNessieTraceLog travLog = new BioNessieTraceLog((StringConsumer)fsc, this.model.getSBAModel());
        travLog.setCompleteConsumer(true);
        traceJob.addOutputFile(file);
        return travLog;
    }

    public boolean performFinish() {
        SBAModel sbaModel = this.model.getSBAModel();
        IPath modelPath = this.model.getUnderlyingResource().getFullPath();
        String modelName = modelPath.removeFileExtension().lastSegment();
        SimulationTracer simTrace = new SimulationTracer(sbaModel);
        SimulationTraceJob traceJob = new SimulationTraceJob(modelName);
        int numberRuns = this.exportPage.getNumberRuns();
        LinkedList<SimulationTracer.SimulationTraceLog> traceLoggers = new LinkedList<SimulationTracer.SimulationTraceLog>();
        IPath traviandoFilePath = this.exportPage.getTraviandoFilePath();
        IPath bioNessieFilePath = this.exportPage.getBioNessieFilePath();
        int index = 0;
        while (index < numberRuns) {
            TraviandoExport.TraviandoTraceLog travLog;
            if (traviandoFilePath != null && bioNessieFilePath != null) {
                travLog = this.createTraviandoTraceLogger(index, traviandoFilePath, traceJob);
                BioNessieTraceLog bioNessLog = this.createBioNessieTraceLogger(index, bioNessieFilePath, traceJob);
                ManyTraceLogger manyTraceLogger = new ManyTraceLogger();
                manyTraceLogger.addSimulationTraceLogger((SimulationTracer.SimulationTraceLog)travLog);
                manyTraceLogger.addSimulationTraceLogger((SimulationTracer.SimulationTraceLog)bioNessLog);
                traceLoggers.add((SimulationTracer.SimulationTraceLog)manyTraceLogger);
            } else if (traviandoFilePath != null) {
                travLog = this.createTraviandoTraceLogger(index, traviandoFilePath, traceJob);
                traceLoggers.add((SimulationTracer.SimulationTraceLog)travLog);
            } else if (bioNessieFilePath != null) {
                BioNessieTraceLog bioNessLog = this.createBioNessieTraceLogger(index, bioNessieFilePath, traceJob);
                traceLoggers.add((SimulationTracer.SimulationTraceLog)bioNessLog);
            } else {
                SimulationTracer.NullTraceLog traceLogger = new SimulationTracer.NullTraceLog();
                traceLoggers.add((SimulationTracer.SimulationTraceLog)traceLogger);
            }
            ++index;
        }
        simTrace.setDataPointStep(this.exportPage.getDataPointSize());
        simTrace.setFiringsLimit(this.exportPage.getFiringsLimit());
        simTrace.setTimeLimit(this.exportPage.getTimeLimit());
        simTrace.setDelays(this.phasesPage.getDelays());
        simTrace.setPhaseLines(this.phasesPage.getPhaseLines());
        traceJob.setSimulationTraceLoggers(traceLoggers);
        traceJob.setDoGraph(this.exportPage.getDisplayGraph());
        traceJob.setSimulationTracer(simTrace);
        traceJob.setSimulationTraceLoggers(traceLoggers);
        traceJob.setSbaModel(sbaModel);
        IPath sbrmlPath = this.exportPage.getSBRMLFilePath();
        if (sbrmlPath != null) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(sbrmlPath);
            traceJob.setSbrmlFile(file);
            traceJob.setSbrmlPath(sbrmlPath);
        }
        traceJob.schedule();
        return true;
    }

    public IResource getUnderlyingResource() {
        return this.model.getUnderlyingResource();
    }

    private class ExportPage
    extends WizardPage {
        private Button firingsLimitCheck;
        private Text firingsLimitText;
        private FileSetter traviandoFileSetter;
        private FileSetter bioNessieFileSetter;
        private FileSetter sbrmlFileSetter;
        private Button timingLimitCheck;
        private Text timeLimitText;
        private Button displayCommentsButton;
        private Text modelCommentText;
        private Button displayGraph;
        private Text dataPointsText;
        private Text numberRunsText;
        private int textStyle;
        private int labelStyle;
        private ModifyListener modifyListener;
        private Listener checkBoxListener;

        protected ExportPage(String pageName) {
            super(pageName);
            this.textStyle = 133120;
            this.labelStyle = 16388;
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent arg0) {
                    ExportPage.this.validate();
                }
            };
            this.checkBoxListener = new Listener(){

                public void handleEvent(Event event) {
                    ExportPage.this.enableWidgets();
                    ExportPage.this.validate();
                }
            };
            this.setTitle("Simulation Trace");
            this.setDescription("Set up a Simulation trace with possible export");
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.setControl((Control)composite);
            Label tmpLabel = new Label(composite, this.labelStyle);
            tmpLabel.setText("Please set the time or firings limit for this trace");
            tmpLabel.setLayoutData((Object)this.createDefaultGridData());
            Composite labelsComposite = new Composite(composite, 0);
            GridLayout labelsCompLayout = new GridLayout(3, false);
            labelsComposite.setLayout((Layout)labelsCompLayout);
            Label firingLabel = new Label(labelsComposite, this.labelStyle);
            this.firingsLimitCheck = new Button(labelsComposite, 32);
            this.firingsLimitCheck.setSelection(false);
            this.firingsLimitCheck.addListener(13, this.checkBoxListener);
            firingLabel.setText("Number of firings limit");
            this.firingsLimitText = new Text(labelsComposite, this.textStyle);
            this.firingsLimitText.setText("2000");
            this.firingsLimitText.setLayoutData((Object)this.newTextGridData());
            this.firingsLimitText.addModifyListener(this.modifyListener);
            Label timeLimitLabel = new Label(labelsComposite, this.labelStyle);
            this.timingLimitCheck = new Button(labelsComposite, 32);
            this.timingLimitCheck.setSelection(true);
            this.timingLimitCheck.addListener(13, this.checkBoxListener);
            this.timeLimitText = new Text(labelsComposite, this.textStyle);
            timeLimitLabel.setText("Set the time limit for this trace");
            this.timeLimitText.setText("20");
            this.timeLimitText.setLayoutData((Object)this.newTextGridData());
            this.timeLimitText.addModifyListener(this.modifyListener);
            Composite fileSetterComposite = new Composite(composite, 0);
            GridLayout filesCompLayout = new GridLayout(3, false);
            fileSetterComposite.setLayout((Layout)filesCompLayout);
            GridData fileSetterGridData = new GridData();
            fileSetterGridData.grabExcessHorizontalSpace = true;
            fileSetterGridData.horizontalAlignment = 4;
            fileSetterComposite.setLayoutData((Object)fileSetterGridData);
            fileSetterGridData.minimumWidth = 100;
            this.traviandoFileSetter = new FileSetter(fileSetterComposite, "Traviando export file:", "xml");
            this.bioNessieFileSetter = new FileSetter(fileSetterComposite, "BioNessie export file:", "bn");
            this.sbrmlFileSetter = new FileSetter(fileSetterComposite, "SBRML results export file:", "sbrml");
            this.displayCommentsButton = new Button(composite, 32);
            this.displayCommentsButton.setText("Output Comments");
            this.displayCommentsButton.setSelection(false);
            Label explainComment = new Label(composite, this.labelStyle);
            explainComment.setText("Enter a comment for what the model does(this isn't hugely important)");
            this.modelCommentText = new Text(composite, 18432);
            this.modelCommentText.setText("Trace generated from BioPEPA Eclipse Plugin");
            this.displayGraph = new Button(composite, 32);
            this.displayGraph.setText("Show results graph");
            this.displayGraph.setSelection(false);
            this.displayGraph.addListener(13, this.checkBoxListener);
            Label explainDataPoints = new Label(composite, this.labelStyle);
            explainDataPoints.setText("Set the increment in data point size for the graph (default 1.0)");
            this.dataPointsText = new Text(composite, this.textStyle);
            this.dataPointsText.setText("");
            this.dataPointsText.setLayoutData((Object)this.newTextGridData());
            this.dataPointsText.addModifyListener(this.modifyListener);
            Label explainNumberRuns = new Label(composite, this.labelStyle);
            explainNumberRuns.setText("The number of independent runs (default 1)");
            this.numberRunsText = new Text(composite, this.textStyle);
            this.numberRunsText.setText("");
            this.numberRunsText.setLayoutData((Object)this.newTextGridData());
            this.numberRunsText.addModifyListener(this.modifyListener);
            this.enableWidgets();
            this.validate();
        }

        private GridData newTextGridData() {
            GridData textGridData = new GridData();
            textGridData.widthHint = 80;
            textGridData.horizontalAlignment = 4;
            textGridData.grabExcessHorizontalSpace = true;
            return textGridData;
        }

        private void enableWidgets() {
            if (this.firingsLimitCheck.getSelection()) {
                this.firingsLimitText.setEnabled(true);
            } else {
                this.firingsLimitText.setEnabled(false);
            }
            if (this.timingLimitCheck.getSelection()) {
                this.timeLimitText.setEnabled(true);
            } else {
                this.timeLimitText.setEnabled(false);
            }
            if (this.displayGraph.getSelection()) {
                this.dataPointsText.setEnabled(true);
            } else {
                this.dataPointsText.setEnabled(false);
            }
        }

        private void validate() {
            String runsText;
            String text;
            this.setPageComplete(false);
            this.setErrorMessage(null);
            String fText = this.firingsLimitText.getText().trim();
            String tText = this.timeLimitText.getText().trim();
            boolean firingsChecked = this.firingsLimitCheck.getSelection();
            boolean timingsChecked = this.timingLimitCheck.getSelection();
            if (firingsChecked) {
                try {
                    Integer.parseInt(fText);
                }
                catch (Exception exception) {
                    this.setPageComplete(false);
                    this.setErrorMessage("Cannot parse firings limit");
                    return;
                }
            }
            if (timingsChecked) {
                try {
                    Double.parseDouble(tText);
                }
                catch (Exception exception) {
                    this.setPageComplete(false);
                    this.setErrorMessage("Cannot parse time limit");
                    return;
                }
            }
            if (!firingsChecked && !timingsChecked) {
                this.setPageComplete(false);
                this.setErrorMessage("You must set one kind of limit");
                return;
            }
            if (this.displayGraph.getSelection() && !(text = this.dataPointsText.getText().trim()).isEmpty()) {
                try {
                    Double.parseDouble(text);
                }
                catch (Exception exception) {
                    this.setPageComplete(false);
                    this.setErrorMessage("Cannot parse data points");
                    return;
                }
            }
            if (!(runsText = this.numberRunsText.getText().trim()).isEmpty()) {
                try {
                    Integer.parseInt(runsText);
                }
                catch (Exception exception) {
                    this.setPageComplete(false);
                    this.setErrorMessage("Cannot parse number of runs");
                    return;
                }
            }
            this.setPageComplete(true);
        }

        public int getFiringsLimit() {
            if (this.firingsLimitCheck.getSelection()) {
                String text = this.firingsLimitText.getText().trim();
                try {
                    return Integer.parseInt(text);
                }
                catch (Exception exception) {
                    return 0;
                }
            }
            return Integer.MAX_VALUE;
        }

        public double getTimeLimit() {
            if (this.timingLimitCheck.getSelection()) {
                String text = this.timeLimitText.getText().trim();
                try {
                    return Double.parseDouble(text);
                }
                catch (Exception exception) {
                    return 0.0;
                }
            }
            return Double.MAX_VALUE;
        }

        public int getNumberRuns() {
            String runsText = this.numberRunsText.getText().trim();
            if (!runsText.isEmpty()) {
                try {
                    return Integer.parseInt(runsText);
                }
                catch (Exception exception) {
                    return 1;
                }
            }
            return 1;
        }

        public IPath getTraviandoFilePath() {
            return this.traviandoFileSetter.getFilePath();
        }

        public IPath getBioNessieFilePath() {
            return this.bioNessieFileSetter.getFilePath();
        }

        public IPath getSBRMLFilePath() {
            return this.sbrmlFileSetter.getFilePath();
        }

        public boolean getDisplayComments() {
            return this.displayCommentsButton.getSelection();
        }

        public String getModelComment() {
            if (this.modelCommentText == null) {
                return "";
            }
            return this.modelCommentText.getText();
        }

        public boolean getDisplayGraph() {
            return this.displayGraph.getSelection();
        }

        public double getDataPointSize() {
            if (this.displayGraph.getSelection()) {
                String text = this.dataPointsText.getText().trim();
                if (text.isEmpty()) {
                    return 1.0;
                }
                try {
                    return Double.parseDouble(text);
                }
                catch (Exception exception) {
                    return 0.0;
                }
            }
            return Double.MAX_VALUE;
        }

        private GridData createDefaultGridData() {
            return new GridData(4, 0x1000000, true, false);
        }

        private class FileSetter {
            private Label cfLabel;
            private IPath cfPath;
            private Button cfButton;

            FileSetter(Composite parent, String exportName, String extension) {
                Label exportLabel = new Label(parent, ExportPage.this.labelStyle);
                exportLabel.setText(exportName);
                this.cfLabel = new Label(parent, ExportPage.this.labelStyle);
                this.cfLabel.setText("no file");
                GridData labelGridData = new GridData();
                labelGridData.grabExcessHorizontalSpace = true;
                labelGridData.horizontalAlignment = 4;
                this.cfLabel.setLayoutData((Object)labelGridData);
                GridData buttonGridData = new GridData();
                buttonGridData.horizontalAlignment = 4;
                buttonGridData.minimumWidth = 5;
                buttonGridData.grabExcessHorizontalSpace = true;
                this.cfButton = new Button(parent, 8);
                this.cfButton.setText("set file");
                this.cfButton.setLayoutData((Object)buttonGridData);
                class SetThisFile
                implements SelectionListener {
                    private String extension;

                    SetThisFile(String extension) {
                        this.extension = extension;
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        SaveAsDialog saveAsDialog = new SaveAsDialog(ExportPage.this.getShell());
                        IPath path = ((ExportPage)((FileSetter)FileSetter.this).ExportPage.this).TraviandoExportWizard.this.model.getUnderlyingResource().getFullPath();
                        path = path.removeFileExtension();
                        if (!this.extension.isEmpty()) {
                            path = path.addFileExtension(this.extension);
                        }
                        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                        saveAsDialog.setOriginalFile(file);
                        saveAsDialog.open();
                        path = saveAsDialog.getResult();
                        FileSetter.this.cfPath = path;
                        FileSetter.this.cfLabel.setText(path.lastSegment());
                        FileSetter.this.cfButton.setText("change");
                    }
                }
                this.cfButton.addSelectionListener((SelectionListener)new SetThisFile(extension));
            }

            public IPath getFilePath() {
                return this.cfPath;
            }
        }
    }
}

