/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui.wizards.timeseries;

import java.util.LinkedList;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import uk.ac.ed.inf.biopepa.core.sba.ExperimentSet;

public abstract class AbstractExperimentPage
extends WizardPage {
    private String headerHelp = "";
    protected NameHintPair[] experimentObjectNameHints;
    protected LinkedList<ArrayInput> arrayInputs = new LinkedList();
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            AbstractExperimentPage.this.validatePage();
        }
    };
    private Listener commonListener = new Listener(){

        public void handleEvent(Event event) {
            AbstractExperimentPage.this.validatePage();
        }
    };

    protected AbstractExperimentPage(String pageName) {
        super(pageName);
    }

    public void setHeader(String s) {
        this.headerHelp = s;
    }

    public abstract void addExperimentArrays(ExperimentSet var1);

    public void createControl(Composite parent) {
        ScrolledComposite composite = new ScrolledComposite(parent, 768);
        this.setControl((Control)composite);
        Composite linesParent = new Composite((Composite)composite, 4);
        GridLayout linesLayout = new GridLayout();
        linesLayout.numColumns = 7;
        linesLayout.makeColumnsEqualWidth = false;
        GridData linesGridData = new GridData();
        linesGridData.grabExcessHorizontalSpace = true;
        linesGridData.horizontalAlignment = 4;
        linesParent.setLayoutData((Object)linesGridData);
        linesParent.setLayout((Layout)linesLayout);
        Label labelledHelp = new Label(linesParent, 2048);
        labelledHelp.setText(this.headerHelp);
        GridData labelledHelpGridData = new GridData();
        labelledHelpGridData.grabExcessHorizontalSpace = true;
        labelledHelpGridData.horizontalSpan = linesLayout.numColumns;
        labelledHelp.setLayoutData((Object)labelledHelpGridData);
        int labelStyle = 0x1000004;
        Label nameLabel = new Label(linesParent, labelStyle);
        nameLabel.setText("Name");
        Label checkBoxDummy1 = new Label(linesParent, labelStyle);
        checkBoxDummy1.setText("");
        Label commaSep = new Label(linesParent, labelStyle);
        commaSep.setText("comma separated values");
        Label checkBoxDummy2 = new Label(linesParent, labelStyle);
        checkBoxDummy2.setText("");
        Label startValue = new Label(linesParent, labelStyle);
        startValue.setText("start value");
        Label stopValue = new Label(linesParent, labelStyle);
        stopValue.setText("stop value");
        Label stepValue = new Label(linesParent, labelStyle);
        stepValue.setText("step");
        NameHintPair[] nameHintPairArray = this.experimentObjectNameHints;
        int n = this.experimentObjectNameHints.length;
        int n2 = 0;
        while (n2 < n) {
            NameHintPair nameHint = nameHintPairArray[n2];
            ArrayInput arrayInput = new ArrayInput(linesParent, nameHint);
            this.arrayInputs.add(arrayInput);
            ++n2;
        }
        linesParent.pack(true);
        composite.setContent((Control)linesParent);
    }

    private GridData newTextGridData() {
        GridData textGridData = new GridData();
        textGridData.horizontalAlignment = 4;
        textGridData.grabExcessHorizontalSpace = true;
        return textGridData;
    }

    public void validatePage() {
        for (ArrayInput arrayInput : this.arrayInputs) {
            String message = arrayInput.validString();
            if (message.equals("")) continue;
            this.setErrorMessage("array input for: " + arrayInput.getName() + " is invalid: " + message);
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    protected class ArrayInput {
        Label nameLabel;
        Composite parent;
        String name;
        String hint;
        Button listCheckBox;
        Text listText;
        Button rangeCheckBox;
        Text startText;
        Text stopText;
        Text stepText;
        private Listener listCheckBoxListener = new Listener(){

            public void handleEvent(Event event) {
                if (ArrayInput.this.listCheckBox.getSelection()) {
                    ArrayInput.this.listText.forceFocus();
                    ArrayInput.this.rangeCheckBox.setSelection(false);
                }
                ArrayInput.this.enableWidgets();
                AbstractExperimentPage.this.validatePage();
            }
        };
        private Listener rangeCheckBoxListener = new Listener(){

            public void handleEvent(Event event) {
                if (ArrayInput.this.rangeCheckBox.getSelection()) {
                    ArrayInput.this.startText.forceFocus();
                    ArrayInput.this.listCheckBox.setSelection(false);
                }
                ArrayInput.this.enableWidgets();
                AbstractExperimentPage.this.validatePage();
            }
        };

        public ArrayInput(Composite parent, NameHintPair nameHint) {
            int labelStyle = 16388;
            int textStyle = 133120;
            this.parent = parent;
            this.name = nameHint.name;
            this.hint = nameHint.hint;
            this.nameLabel = new Label(parent, labelStyle);
            this.nameLabel.setText(String.valueOf(this.name) + " (" + this.hint + ")");
            this.nameLabel.setLayoutData((Object)new GridData());
            this.listCheckBox = new Button(parent, 32);
            this.listCheckBox.setEnabled(true);
            this.listCheckBox.setSelection(false);
            this.listCheckBox.addListener(13, this.listCheckBoxListener);
            this.listText = new Text(parent, textStyle);
            this.listText.setLayoutData((Object)AbstractExperimentPage.this.newTextGridData());
            this.listText.setText("");
            this.listText.addModifyListener(AbstractExperimentPage.this.modifyListener);
            this.rangeCheckBox = new Button(parent, 32);
            this.rangeCheckBox.setEnabled(true);
            this.rangeCheckBox.setSelection(false);
            this.rangeCheckBox.addListener(13, this.rangeCheckBoxListener);
            this.startText = new Text(parent, textStyle);
            this.startText.addModifyListener(AbstractExperimentPage.this.modifyListener);
            this.stopText = new Text(parent, textStyle);
            this.stopText.addModifyListener(AbstractExperimentPage.this.modifyListener);
            this.stepText = new Text(parent, textStyle);
            this.stepText.addModifyListener(AbstractExperimentPage.this.modifyListener);
            this.enableWidgets();
        }

        private void enableWidgets() {
            boolean listEnabled = this.listCheckBox.getSelection();
            this.listText.setEnabled(listEnabled);
            boolean rangeEnabled = this.rangeCheckBox.getSelection();
            this.startText.setEnabled(rangeEnabled);
            this.stopText.setEnabled(rangeEnabled);
            this.stepText.setEnabled(rangeEnabled);
        }

        public String getName() {
            return this.name;
        }

        private Number[] getCommaSeparatedDoubleValues(String text) throws Exception {
            String[] values = text.split("(\\s)*,(\\s)*");
            if (values.length == 0) {
                throw new Exception("No comma separated values");
            }
            Number[] list = new Number[values.length];
            int i = 0;
            while (i < values.length) {
                double current = Double.parseDouble(values[i]);
                if (current < 0.0) {
                    throw new Exception("zero number");
                }
                list[i] = current;
                ++i;
            }
            return list;
        }

        public Number[] getDoubleValues() {
            try {
                return this.obtainDoubleValues();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                return new Number[0];
            }
        }

        private Number[] obtainDoubleValues() throws Exception {
            if (this.listCheckBox.getSelection()) {
                String text = this.listText.getText().trim();
                Number[] list = this.getCommaSeparatedDoubleValues(text);
                return list;
            }
            if (this.rangeCheckBox.getSelection()) {
                String startS = this.startText.getText().trim();
                String stopS = this.stopText.getText().trim();
                String stepS = this.stepText.getText().trim();
                double start = Double.parseDouble(startS);
                double stop = Double.parseDouble(stopS);
                double step = Double.parseDouble(stepS);
                if (start > stop) {
                    throw new Exception("start value higher than stop value");
                }
                if (step > stop - start) {
                    throw new Exception("step value too high (step > (stop - start)");
                }
                if (step == 0.0) {
                    throw new Exception("step value zero");
                }
                if (step < 0.0) {
                    throw new Exception("step value negative");
                }
                LinkedList<Double> numbers = new LinkedList<Double>();
                while (start <= stop) {
                    numbers.add(start);
                    start += step;
                }
                if (numbers.size() == 0) {
                    throw new Exception("No values specified");
                }
                Number[] list = new Number[numbers.size()];
                int i = 0;
                while (i < numbers.size()) {
                    list[i] = (Number)numbers.get(i);
                    ++i;
                }
                return list;
            }
            return new Number[0];
        }

        public String validString() {
            try {
                this.obtainDoubleValues();
            }
            catch (Exception e) {
                return e.getMessage();
            }
            return "";
        }
    }

    protected class NameHintPair {
        public String name;
        public String hint;

        public NameHintPair(String name, String hint) {
            this.name = name;
            this.hint = hint;
        }
    }
}

