/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui.wizards.timeseries;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.SaveAsDialog;
import uk.ac.ed.inf.biopepa.core.sba.ExperimentSet;
import uk.ac.ed.inf.biopepa.core.sba.ExperimentSetReader;
import uk.ac.ed.inf.biopepa.ui.interfaces.BioPEPAModel;
import uk.ac.ed.inf.biopepa.ui.wizards.timeseries.CreateExperimentationWizard;

public class ImportCSVPage
extends WizardPage {
    public static final String wizardPageName = "Import CSV Page";
    private BioPEPAModel model;
    ExperimentSet experimentSet;
    String loadedFileName;
    Shell shell;
    private Button separateGraphsButton;
    private Button justBuildCsvButton;
    private Button saveExperButton;

    public ImportCSVPage(BioPEPAModel model) {
        super(wizardPageName);
        this.model = model;
        this.shell = new Shell();
        this.setTitle("Import experimentation setup from cvs");
        this.setDescription("Set up experimentation from csv");
    }

    public boolean getSeparateGraphs() {
        return this.separateGraphsButton.getSelection();
    }

    public boolean getJustBuildCsv() {
        return this.justBuildCsvButton.getSelection();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        GridLayout gl = new GridLayout();
        composite.setLayout((Layout)gl);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        gridData.minimumWidth = -1;
        this.separateGraphsButton = new Button(composite, 32);
        this.separateGraphsButton.setText("separate graphs");
        this.separateGraphsButton.setSelection(true);
        this.justBuildCsvButton = new Button(composite, 32);
        this.justBuildCsvButton.setText("Straight to csv (no graph)");
        this.justBuildCsvButton.setSelection(false);
        Button openCsvButton = new Button(composite, 8);
        openCsvButton.setText("Open a csv file");
        class Open
        implements SelectionListener {
            Open() {
            }

            public void widgetSelected(SelectionEvent event) {
                FileDialog fd = new FileDialog(ImportCSVPage.this.shell, 4096);
                fd.setText("Open");
                fd.setFilterPath("C:/");
                String[] filterExt = new String[]{"*.csv"};
                fd.setFilterExtensions(filterExt);
                String selected = fd.open();
                ImportCSVPage.this.readCSVFile(selected);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        }
        openCsvButton.addSelectionListener((SelectionListener)new Open());
        this.setMessage("No csv file has been loaded");
        Button createCsvButton = new Button(composite, 8);
        createCsvButton.setText("Create Experiment");
        class Create
        implements SelectionListener {
            Create() {
            }

            public void widgetSelected(SelectionEvent event) {
                WizardDialog dialog = null;
                try {
                    CreateExperimentationWizard wizard = new CreateExperimentationWizard(ImportCSVPage.this.model);
                    Shell shell = Display.getDefault().getActiveShell();
                    dialog = new WizardDialog(shell, (IWizard)wizard);
                    dialog.open();
                    ExperimentSet experSet = wizard.getExperimentSet();
                    ImportCSVPage.this.clearLoaded();
                    ImportCSVPage.this.loadExperimentSet(experSet);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        }
        createCsvButton.addSelectionListener((SelectionListener)new Create());
        this.saveExperButton = new Button(composite, 8);
        this.saveExperButton.setText("Save loaded experiment");
        this.saveExperButton.setEnabled(false);
        class SaveCSV
        implements SelectionListener {
            SaveCSV() {
            }

            public void widgetSelected(SelectionEvent event) {
                ImportCSVPage.this.saveLoadedExperiment();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        }
        this.saveExperButton.addSelectionListener((SelectionListener)new SaveCSV());
    }

    public static void renewTable(Table table) {
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tblCol = tableColumnArray[n2];
            tblCol.dispose();
            ++n2;
        }
        table.removeAll();
    }

    private boolean saveLoadedExperiment() {
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getShell());
        IPath path = this.model.getUnderlyingResource().getFullPath();
        path = path.removeFileExtension().addFileExtension("csv");
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        saveAsDialog.setOriginalFile(file);
        saveAsDialog.open();
        path = saveAsDialog.getResult();
        if (path == null) {
            return false;
        }
        path = path.removeFileExtension().addFileExtension("csv");
        file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        String contents = null;
        try {
            contents = this.experimentSet.toCsvString(this.model.getSBAModel());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        ByteArrayInputStream source = new ByteArrayInputStream(contents.getBytes());
        try {
            if (file.exists()) {
                file.setContents((InputStream)source, 0, null);
                this.loadedFileName = file.getName();
            } else {
                file.create((InputStream)source, 0, null);
            }
            file.refreshLocal(0, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void loadExperimentSet(ExperimentSet experSet) {
        if (experSet != null) {
            this.experimentSet = experSet;
            this.setMessage("Experiment loaded");
            if (this.saveExperButton != null) {
                this.saveExperButton.setEnabled(true);
            }
        } else if (this.saveExperButton != null) {
            this.saveExperButton.setEnabled(false);
        }
    }

    public ExperimentSet getExperimentSet() {
        return this.experimentSet;
    }

    public boolean arrayContains(Object[] array, Object object) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object arrayObj = objectArray[n2];
            if (arrayObj.equals(object)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void clearLoaded() {
        this.experimentSet = null;
        this.loadedFileName = null;
        this.setMessage("No csv file has been loaded");
    }

    private void readCSVFile(String filename) {
        if (filename == null) {
            this.clearLoaded();
            return;
        }
        ExperimentSetReader esetReader = new ExperimentSetReader(this.model.getSBAModel(), this.model.getCompiledModel());
        esetReader.readCsvFile(filename, new String[0]);
        String readingError = esetReader.getReadError();
        ExperimentSet experSet = esetReader.getExperimentSet();
        if (experSet != null) {
            experSet.setSeparateGraphs(this.separateGraphsButton.getSelection());
            this.experimentSet = experSet;
            this.loadedFileName = filename;
            this.setMessage("The csv file: " + filename + " has been loaded");
            return;
        }
        MessageDialog.openError((Shell)this.shell, (String)"Error importing csv", (String)readingError);
        this.clearLoaded();
    }

    private class MyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private MyLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            LinkedList row = (LinkedList)element;
            return (String)row.get(columnIndex);
        }
    }
}

