/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui.wizards.timeseries;

import au.com.bytecode.opencsv.CSVReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import uk.ac.ed.csbe.sbsivisual.sbsiDataFormat.ISBSIData;
import uk.ac.ed.csbe.sbsivisual.sbsiDataFormat.SBSIDataDocument;
import uk.ac.ed.csbe.sbsivisual.sbsiDataFormat.SBSIResourceFactory;
import uk.ac.ed.inf.biopepa.core.BasicResult;
import uk.ac.ed.inf.biopepa.core.interfaces.Result;
import uk.ac.ed.inf.biopepa.core.sba.Parameters;

public class ImportDataPage
extends WizardPage {
    private int textStyle = 133120;
    private int labelStyle = 16388;
    private FileOpener csvFileOpener;
    private FileOpener sbsiResultParser;
    private Result plottableResult;

    protected ImportDataPage(String pageName) {
        super(pageName);
        this.setTitle("Import external data for comparison");
        this.setDescription("Import data from a csv file or SBSI format to plot alongside data from BioPEPA analysis");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.setControl((Control)composite);
        Composite fileSetterComposite = new Composite(composite, 0);
        GridLayout filesCompLayout = new GridLayout(3, false);
        fileSetterComposite.setLayout((Layout)filesCompLayout);
        GridData fileSetterGridData = new GridData();
        fileSetterGridData.grabExcessHorizontalSpace = true;
        fileSetterGridData.horizontalAlignment = 4;
        fileSetterComposite.setLayoutData((Object)fileSetterGridData);
        fileSetterGridData.minimumWidth = 100;
        this.csvFileOpener = new FileOpener(fileSetterComposite, "Open csv data", new CsvResultParser());
        this.sbsiResultParser = new FileOpener(fileSetterComposite, "Open sbsi data", new SBSIResultParser());
    }

    public Result getPlottableResult() {
        return this.plottableResult;
    }

    private void csvParseError(String errMsg) {
        this.csvFileOpener.unSetSelectedFile();
        this.setErrorMessage(errMsg);
    }

    private void readCsvFile(String filename) {
        if (filename == null) {
            return;
        }
        try {
            FileReader freader = new FileReader(filename);
            CSVReader reader = new CSVReader((Reader)freader);
            String[] nextLine = reader.readNext();
            if (nextLine == null) {
                return;
            }
            String[] names = new String[nextLine.length - 1];
            int i = 1;
            while (i < nextLine.length) {
                names[i - 1] = nextLine[i].trim();
                ++i;
            }
            LinkedList<Double> timesList = new LinkedList<Double>();
            LinkedList<double[]> resultsList = new LinkedList<double[]>();
            while ((nextLine = reader.readNext()) != null) {
                timesList.add(Double.parseDouble(nextLine[0].trim()));
                double[] resultLine = new double[names.length];
                int column = 1;
                while (column < names.length) {
                    double value;
                    resultLine[column] = column > nextLine.length ? 0.0 : (value = Double.parseDouble(nextLine[column].trim()));
                    ++column;
                }
                resultsList.addLast(resultLine);
            }
            double[] times = new double[timesList.size()];
            int index = 0;
            while (index < times.length) {
                times[index] = ((Number)timesList.get(index)).doubleValue();
                ++index;
            }
            double[][] results = new double[names.length][];
            int i2 = 0;
            while (i2 < names.length) {
                results[i2] = new double[times.length];
                ++i2;
            }
            int timeIndex = 0;
            while (timeIndex < times.length) {
                double[] resultLine = (double[])resultsList.get(timeIndex);
                int index2 = 0;
                while (index2 < results.length) {
                    results[index2][timeIndex] = resultLine[index2];
                    ++index2;
                }
                ++timeIndex;
            }
            Parameters params = new Parameters();
            HashMap modelParams = new HashMap();
            BasicResult thisResult = new BasicResult(params, modelParams);
            thisResult.setComponentNames(names);
            thisResult.setResults((double[][])results);
            thisResult.setTimePoints(times);
            this.setErrorMessage(null);
            this.plottableResult = thisResult;
        }
        catch (FileNotFoundException e) {
            this.csvParseError("csv file not found");
            e.printStackTrace();
        }
        catch (IOException e) {
            this.csvParseError("csv file / io error " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            this.csvParseError("csv file error " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void sbsiParseError(String errMsg) {
        this.sbsiResultParser.unSetSelectedFile();
        this.setErrorMessage(errMsg);
    }

    private void readSBSIFile(String filename) {
        if (filename == null) {
            return;
        }
        try {
            SBSIResourceFactory sbsiResFact = SBSIResourceFactory.getInstance();
            SBSIDataDocument sbsiDoc = sbsiResFact.readSBSIDataFile(filename);
            ISBSIData sbsiData = sbsiDoc.getSBSIData();
            String[] names = sbsiData.getHeaders();
            double[][] results = new double[names.length][];
            int index = 0;
            while (index < names.length) {
                results[index] = sbsiData.getColumnData(index);
                ++index;
            }
            double[] times = results[0];
            Parameters params = new Parameters();
            HashMap modelParams = new HashMap();
            BasicResult thisResult = new BasicResult(params, modelParams);
            thisResult.setComponentNames(names);
            thisResult.setResults((double[][])results);
            thisResult.setTimePoints(times);
            this.setErrorMessage(null);
            this.plottableResult = thisResult;
        }
        catch (IllegalStateException e) {
            this.sbsiParseError("Cannot parse sbsi data file " + e.getMessage());
        }
        catch (Exception e) {
            this.sbsiParseError("Error opening sbsi data file " + e.getMessage());
            e.printStackTrace();
        }
    }

    private GridData newTextGridData() {
        GridData textGridData = new GridData();
        textGridData.widthHint = 80;
        textGridData.horizontalAlignment = 4;
        textGridData.grabExcessHorizontalSpace = true;
        return textGridData;
    }

    private class CsvResultParser
    implements ResultFileParser {
        private CsvResultParser() {
        }

        public void parseFile(String filename) {
            ImportDataPage.this.readCsvFile(filename);
        }

        public String[] getFileExtensions() {
            String[] result = new String[]{"*.csv", "*"};
            return result;
        }
    }

    private class FileOpener {
        private Label cfLabel;
        private IPath cfPath;
        private Button cfButton;
        private ResultFileParser resultFileParser;
        String selectedFile;

        public String getSelectedFile() {
            return this.selectedFile;
        }

        public void unSetSelectedFile() {
            this.cfLabel.setText("no file");
            this.cfButton.setText("set file");
        }

        FileOpener(Composite parent, String exportName, ResultFileParser resultFileParser) {
            Label exportLabel = new Label(parent, ImportDataPage.this.labelStyle);
            exportLabel.setText(exportName);
            GridData buttonGridData = new GridData();
            buttonGridData.horizontalAlignment = 4;
            buttonGridData.minimumWidth = 5;
            buttonGridData.grabExcessHorizontalSpace = true;
            this.cfButton = new Button(parent, 8);
            this.cfButton.setText("set file");
            this.cfButton.setLayoutData((Object)buttonGridData);
            String[] extensions = resultFileParser.getFileExtensions();
            this.cfButton.addSelectionListener((SelectionListener)new Open(extensions));
            this.cfLabel = new Label(parent, ImportDataPage.this.labelStyle);
            this.cfLabel.setText("no file");
            GridData labelGridData = new GridData();
            labelGridData.grabExcessHorizontalSpace = true;
            labelGridData.horizontalAlignment = 4;
            this.cfLabel.setLayoutData((Object)labelGridData);
            this.resultFileParser = resultFileParser;
        }

        class Open
        implements SelectionListener {
            private String[] extensions;

            Open(String[] extensions) {
                this.extensions = extensions;
            }

            public void widgetSelected(SelectionEvent event) {
                FileDialog fd = new FileDialog(ImportDataPage.this.getShell(), 4096);
                fd.setText("Open");
                fd.setFilterPath("C:/");
                fd.setFilterExtensions(this.extensions);
                String selected = fd.open();
                IPath selectedPath = Path.fromOSString((String)selected);
                String labelString = selectedPath.lastSegment();
                if (labelString.length() > 30) {
                    labelString = String.valueOf(labelString.substring(0, 30)) + "...";
                }
                FileOpener.this.selectedFile = selected;
                FileOpener.this.cfLabel.setText(labelString);
                FileOpener.this.cfButton.setText("Change");
                FileOpener.this.resultFileParser.parseFile(FileOpener.this.selectedFile);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        }
    }

    private static interface ResultFileParser {
        public void parseFile(String var1);

        public String[] getFileExtensions();
    }

    private class SBSIResultParser
    implements ResultFileParser {
        private SBSIResultParser() {
        }

        public void parseFile(String filename) {
            ImportDataPage.this.readSBSIFile(filename);
        }

        public String[] getFileExtensions() {
            String[] result = new String[]{"*.dat", "*"};
            return result;
        }
    }
}

