/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui.wizards.timeseries;

import uk.ac.ed.inf.biopepa.core.compiler.ComponentNode;
import uk.ac.ed.inf.biopepa.core.sba.ExperimentSet;
import uk.ac.ed.inf.biopepa.core.sba.LineStringBuilder;
import uk.ac.ed.inf.biopepa.ui.interfaces.BioPEPAModel;
import uk.ac.ed.inf.biopepa.ui.wizards.timeseries.AbstractExperimentPage;

public class InitPopsExperimentPage
extends AbstractExperimentPage {
    public static final String wizardPageName = "Initial Concentration Setup Page";

    public InitPopsExperimentPage(BioPEPAModel model) {
        super(wizardPageName);
        this.setTitle("Initial Concentration Setup and Experimentation Page");
        this.setDescription("Set up experiments over component initial populations ");
        LineStringBuilder sb = new LineStringBuilder();
        sb.append("For each component that you wish to range over ");
        sb.appendLine("either check the left box and");
        sb.append("enter a comma ");
        sb.appendLine("separated list of double values or check the right ");
        sb.append("box and enter a range via start and stop values with ");
        sb.appendLine("a step size.");
        sb.appendLine("Any component with unchecked boxes will not be ranged ");
        sb.appendLine("over in this experiment and their default values used.");
        this.setHeader(sb.toString());
        ComponentNode[] species = model.getSBAModel().getComponents();
        this.experimentObjectNameHints = new AbstractExperimentPage.NameHintPair[species.length];
        int i = 0;
        while (i < species.length) {
            AbstractExperimentPage.NameHintPair nameHint;
            ComponentNode compNode = species[i];
            String name = compNode.getName();
            String hint = Long.toString(compNode.getCount());
            this.experimentObjectNameHints[i] = nameHint = new AbstractExperimentPage.NameHintPair(name, hint);
            ++i;
        }
    }

    public void addExperimentArrays(ExperimentSet experiment) {
        for (AbstractExperimentPage.ArrayInput arrayInput : this.arrayInputs) {
            Number[] values;
            String compName = arrayInput.getName();
            Number[] numberArray = values = arrayInput.getDoubleValues();
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Number value = numberArray[n2];
                ExperimentSet experimentSet = experiment;
                experimentSet.getClass();
                ExperimentSet.ExperimentLine eline = new ExperimentSet.ExperimentLine(experimentSet, String.valueOf(compName) + "-" + value);
                eline.addInitialConcentration(compName, value);
                experiment.addExperimentLine(eline);
                ++n2;
            }
        }
    }
}

