/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui.wizards.timeseries;

import java.util.LinkedList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import uk.ac.ed.inf.biopepa.core.sba.ExperimentSet;
import uk.ac.ed.inf.biopepa.core.sba.ExperimentSetReader;
import uk.ac.ed.inf.biopepa.ui.interfaces.BioPEPAModel;

public class PhasesPage
extends WizardPage {
    public static final String wizardPageName = "Setup Phases";
    private BioPEPAModel model;
    private double[] delays;
    private ExperimentSet.ExperimentLine[] phaseLines;
    private String loadedFileName;
    private Shell shell;

    public PhasesPage(BioPEPAModel model) {
        super(wizardPageName);
        this.model = model;
        this.shell = new Shell();
        this.setTitle("Import phases setup from cvs");
        this.setDescription("Set up phases from csv");
    }

    private void clearLoaded() {
        this.loadedFileName = "";
        this.phaseLines = null;
        this.delays = null;
    }

    public double[] getDelays() {
        return this.delays;
    }

    public ExperimentSet.ExperimentLine[] getPhaseLines() {
        return this.phaseLines;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        GridLayout gl = new GridLayout();
        composite.setLayout((Layout)gl);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        gridData.minimumWidth = -1;
        Button openCsvButton = new Button(composite, 8);
        openCsvButton.setText("Open a csv file");
        class Open
        implements SelectionListener {
            Open() {
            }

            public void widgetSelected(SelectionEvent event) {
                FileDialog fd = new FileDialog(PhasesPage.this.shell, 4096);
                fd.setText("Open");
                fd.setFilterPath("C:/");
                String[] filterExt = new String[]{"*.csv"};
                fd.setFilterExtensions(filterExt);
                String selected = fd.open();
                PhasesPage.this.readCSVFile(selected);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        }
        openCsvButton.addSelectionListener((SelectionListener)new Open());
        this.setMessage("No csv file has been loaded");
    }

    private void readCSVFile(String filename) {
        if (filename == null) {
            this.clearLoaded();
            System.out.println("boo hoo");
            MessageDialog.openError((Shell)this.shell, (String)"Error importing csv", (String)"filename is null");
            return;
        }
        ExperimentSetReader esetReader = new ExperimentSetReader(this.model.getSBAModel(), this.model.getCompiledModel());
        String[] specialNames = new String[]{"phase-delay"};
        esetReader.readCsvFile(filename, specialNames);
        String readingError = esetReader.getReadError();
        ExperimentSet experSet = esetReader.getExperimentSet();
        if (experSet != null) {
            this.loadExperimentSet(experSet);
            this.loadedFileName = filename;
            this.setMessage("The csv file: " + filename + " has been loaded");
            return;
        }
        MessageDialog.openError((Shell)this.shell, (String)"Error importing csv", (String)readingError);
        this.clearLoaded();
    }

    private void loadExperimentSet(ExperimentSet experSet) {
        LinkedList elines = experSet.getExperimentLines();
        int noLines = elines.size();
        this.delays = new double[noLines];
        this.phaseLines = new ExperimentSet.ExperimentLine[noLines];
        int index = 0;
        while (index < noLines) {
            ExperimentSet.ExperimentLine el = (ExperimentSet.ExperimentLine)elines.get(index);
            Number thisDelay = el.getSpecialDefine("phase-delay");
            if (thisDelay == null) {
                MessageDialog.openError((Shell)this.shell, (String)"No delay", (String)"a phase line without a phase delay has been entered");
            }
            this.delays[index] = thisDelay.doubleValue();
            this.phaseLines[index] = el;
            ++index;
        }
    }
}

