/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui.wizards.timeseries;

import java.util.LinkedList;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import uk.ac.ed.inf.biopepa.core.sba.SBAReaction;
import uk.ac.ed.inf.biopepa.ui.interfaces.BioPEPAModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReactionKnockoutPage
extends WizardPage {
    public static final String wizardPageName = "Reaction Knockout Page";
    private BioPEPAModel model;
    private Button[] reactionCheckBoxes;
    private String[] reactionNames;
    private String headerHelp = "";
    private boolean defaultSelection = false;

    public void setDefaultSelection(boolean b) {
        this.defaultSelection = b;
    }

    public void setHeaderHelp(String help) {
        this.headerHelp = help;
    }

    public ReactionKnockoutPage(BioPEPAModel model) {
        super(wizardPageName);
        this.model = model;
        this.setTitle(wizardPageName);
        this.setDescription("Reaction knockout page");
        this.setDescription("Select which reactions you wish to allow for this analysis. ");
    }

    public LinkedList<SBAReaction> getSelectedReactions() {
        LinkedList<SBAReaction> selectedReactions = new LinkedList<SBAReaction>();
        Button[] buttonArray = this.reactionCheckBoxes;
        int n = this.reactionCheckBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            Button rCheckBox = buttonArray[n2];
            if (rCheckBox.getSelection()) {
                selectedReactions.add((SBAReaction)rCheckBox.getData());
            }
            ++n2;
        }
        return selectedReactions;
    }

    public void createControl(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 512);
        this.setControl((Control)scrolledComposite);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        int numColumns = 2;
        GridLayout compositeLayout = new GridLayout(numColumns, false);
        composite.setLayout((Layout)compositeLayout);
        GridLayout gl = new GridLayout();
        scrolledComposite.setLayout((Layout)gl);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        gridData.minimumWidth = -1;
        Label labelledHelp = new Label(composite, 2048);
        labelledHelp.setText(this.headerHelp);
        GridData labelledHelpGridData = new GridData();
        labelledHelpGridData.grabExcessHorizontalSpace = true;
        labelledHelpGridData.horizontalSpan = numColumns;
        labelledHelp.setLayoutData((Object)labelledHelpGridData);
        Button selectAll = new Button(composite, 8);
        selectAll.setText("Select All");
        selectAll.setEnabled(true);
        class SelectAll
        implements SelectionListener {
            SelectAll() {
            }

            public void widgetSelected(SelectionEvent event) {
                ReactionKnockoutPage.this.setAllSelections(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        }
        selectAll.addSelectionListener((SelectionListener)new SelectAll());
        Button deselectAll = new Button(composite, 8);
        deselectAll.setText("Deselect All");
        deselectAll.setEnabled(true);
        class DeselectAll
        implements SelectionListener {
            DeselectAll() {
            }

            public void widgetSelected(SelectionEvent event) {
                ReactionKnockoutPage.this.setAllSelections(false);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        }
        deselectAll.addSelectionListener((SelectionListener)new DeselectAll());
        SBAReaction[] reactions = this.model.getSBAModel().getReactions();
        this.reactionCheckBoxes = new Button[reactions.length];
        this.reactionNames = new String[reactions.length];
        Listener commonListener = new Listener(){

            public void handleEvent(Event event) {
            }
        };
        int i = 0;
        while (i < reactions.length) {
            SBAReaction reaction = reactions[i];
            String reactionName = reaction.getName();
            String reactionString = reaction.toString();
            Button checkBox = new Button(composite, 32);
            checkBox.setData((Object)reaction);
            this.reactionCheckBoxes[i] = checkBox;
            checkBox.setText(reactionString);
            this.reactionNames[i] = reactionName;
            GridData checkGridData = new GridData();
            checkGridData.grabExcessHorizontalSpace = true;
            checkGridData.horizontalSpan = numColumns;
            checkBox.setLayoutData((Object)checkGridData);
            checkBox.setSelection(this.defaultSelection);
            checkBox.addListener(13, commonListener);
            ++i;
        }
        composite.pack();
        scrolledComposite.setContent((Control)composite);
    }

    private void setAllSelections(boolean selection) {
        Button[] buttonArray = this.reactionCheckBoxes;
        int n = this.reactionCheckBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            Button rCheckBox = buttonArray[n2];
            rCheckBox.setSelection(selection);
            ++n2;
        }
    }
}

