/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui.wizards.timeseries;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import uk.ac.ed.inf.biopepa.core.sba.Parameters;
import uk.ac.ed.inf.biopepa.ui.ImageManager;
import uk.ac.ed.inf.biopepa.ui.interfaces.BioPEPAModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpeciesSelectionWizardPage
extends WizardPage {
    public static final String name = "SpeciesSelection";
    CheckboxTreeViewer checkboxTreeViewer;
    private int selectionCount = 0;
    Composite composite;
    BioPEPAModel model;
    Map<Parameters.Parameter, Object> parameters;
    Button selectAllButton;
    SpeciesFilter speciesFilter;
    boolean listenersUpdated = false;

    protected SpeciesSelectionWizardPage(BioPEPAModel model, Map<Parameters.Parameter, Object> parameters) {
        super(name);
        this.model = model;
        this.parameters = parameters;
        this.setTitle("Component Selection");
        this.setDescription("Please select the components you wish to record during this analysis");
    }

    private void checkPage() {
        TreeItem ti;
        this.setPageComplete(false);
        boolean all = true;
        Stack<TreeItem> items = new Stack<TreeItem>();
        TreeItem[] treeItemArray = this.checkboxTreeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ti = treeItemArray[n2];
            items.add(ti);
            ++n2;
        }
        while (!items.empty()) {
            ti = (TreeItem)items.pop();
            if (!ti.getChecked()) {
                all = false;
            }
            TreeItem[] treeItemArray2 = ti.getItems();
            int n3 = treeItemArray2.length;
            n = 0;
            while (n < n3) {
                TreeItem child = treeItemArray2[n];
                items.add(child);
                ++n;
            }
        }
        Object[] oArray = this.checkboxTreeViewer.getCheckedElements();
        this.selectAllButton.setText(all ? "Deselect all" : "Select all");
        this.composite.layout();
        LinkedList<String> sList = new LinkedList<String>();
        Object[] objectArray = oArray;
        int n4 = oArray.length;
        int n5 = 0;
        while (n5 < n4) {
            Object o = objectArray[n5];
            ComponentTree ct = (ComponentTree)o;
            if (ct.parent != null) {
                sList.add(ct.name);
            }
            ++n5;
        }
        if (sList.size() > 0) {
            this.setPageComplete(true);
            this.parameters.put(Parameters.Parameter.Components, sList.toArray(new String[0]));
        }
    }

    public void createControl(Composite parent) {
        ComponentTree ct;
        String s;
        int n;
        int n2;
        String[] stringArray;
        Object[] components;
        this.composite = new Composite(parent, 0);
        final Text filterInput = new Text(this.composite, 132);
        this.checkboxTreeViewer = new CheckboxTreeViewer(this.composite);
        this.checkboxTreeViewer.setContentProvider((IContentProvider)new ComponentTreeContentProvider());
        this.checkboxTreeViewer.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider());
        int i = 0;
        String[] names = this.model.getDynamicVariableNames();
        if (names.length > 0) {
            this.selectionCount = names.length + 1;
            components = new ComponentTree[2];
            components[1] = new ComponentTree();
            components[1].name = "Variables";
            components[1].children = new ComponentTree[names.length];
            stringArray = names;
            n2 = names.length;
            n = 0;
            while (n < n2) {
                s = stringArray[n];
                ct = new ComponentTree();
                ct.name = s;
                ct.parent = components[1];
                ((ComponentTree)components[1]).children[i++] = ct;
                ++n;
            }
        } else {
            components = new ComponentTree[1];
        }
        names = this.model.getComponentNames();
        this.selectionCount += names.length + 1;
        components[0] = new ComponentTree();
        components[0].name = "Species";
        components[0].children = new ComponentTree[names.length];
        i = 0;
        stringArray = names;
        n2 = names.length;
        n = 0;
        while (n < n2) {
            s = stringArray[n];
            ct = new ComponentTree();
            ct.name = s;
            ct.parent = components[0];
            ((ComponentTree)components[0]).children[i++] = ct;
            ++n;
        }
        this.checkboxTreeViewer.setInput((Object)components);
        this.checkboxTreeViewer.setExpandedElements(components);
        if (this.parameters.containsKey(Parameters.Parameter.Components)) {
            HashSet<String> sSet = new HashSet<String>();
            Object[] objectArray = (String[])this.parameters.get(Parameters.Parameter.Components);
            int n3 = objectArray.length;
            n2 = 0;
            while (n2 < n3) {
                String s2 = objectArray[n2];
                sSet.add(s2);
                ++n2;
            }
            objectArray = components;
            n3 = components.length;
            n2 = 0;
            while (n2 < n3) {
                Object ct2 = objectArray[n2];
                ComponentTree[] componentTreeArray = ((ComponentTree)ct2).children;
                int n4 = ((ComponentTree)ct2).children.length;
                int n5 = 0;
                while (n5 < n4) {
                    ComponentTree ct3 = componentTreeArray[n5];
                    if (sSet.contains(ct3.name)) {
                        this.checkboxTreeViewer.setChecked((Object)ct3, true);
                    }
                    ++n5;
                }
                ++n2;
            }
        } else {
            this.selectAllSpecies(true);
        }
        this.speciesFilter = new SpeciesFilter();
        this.checkboxTreeViewer.addFilter((ViewerFilter)this.speciesFilter);
        filterInput.setMessage("Filter species/variables list");
        filterInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SpeciesSelectionWizardPage.this.speciesFilter.updateFilter(filterInput.getText());
                SpeciesSelectionWizardPage.this.checkboxTreeViewer.refresh();
                SpeciesSelectionWizardPage.this.speciesFilter.updateSelected();
                SpeciesSelectionWizardPage.this.checkPage();
            }
        });
        Image image = ImageManager.getInstance().getImage(ImageManager.ICONS.CLEAR);
        ImageData imageData = image.getImageData();
        imageData = imageData.scaledTo(10, 10);
        image = new Image(image.getDevice(), imageData);
        ControlDecoration controlDecoration = new ControlDecoration((Control)filterInput, 131200, this.composite);
        controlDecoration.setImage(image);
        controlDecoration.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                filterInput.setText("");
                SpeciesSelectionWizardPage.this.speciesFilter.updateFilter("");
                SpeciesSelectionWizardPage.this.checkboxTreeViewer.refresh();
                SpeciesSelectionWizardPage.this.speciesFilter.updateSelected();
                SpeciesSelectionWizardPage.this.checkPage();
            }
        });
        controlDecoration.setDescriptionText("Clear the filter");
        this.selectAllButton = new Button(this.composite, 8);
        this.selectAllButton.setText("Select all");
        this.checkboxTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ComponentTree ct = (ComponentTree)event.getElement();
                if (ct.children != null) {
                    boolean state = event.getChecked();
                    ComponentTree[] componentTreeArray = ct.children;
                    int n = ct.children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ComponentTree ct2 = componentTreeArray[n2];
                        SpeciesSelectionWizardPage.this.checkboxTreeViewer.setChecked((Object)ct2, state);
                        ++n2;
                    }
                }
                SpeciesSelectionWizardPage.this.checkPage();
            }
        });
        this.selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean select = !SpeciesSelectionWizardPage.this.selectAllButton.getText().startsWith("De");
                SpeciesSelectionWizardPage.this.selectAllSpecies(select);
                SpeciesSelectionWizardPage.this.checkPage();
            }
        });
        GridLayout gl = new GridLayout();
        gl.marginRight += imageData.width;
        this.composite.setLayout((Layout)gl);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        gridData.minimumWidth = -1;
        filterInput.setText("          ");
        gridData.widthHint = filterInput.getSize().x;
        filterInput.setText("");
        filterInput.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.checkboxTreeViewer.getTree().setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        this.selectAllButton.setLayoutData((Object)gridData);
        this.setControl((Control)this.composite);
        this.checkPage();
    }

    private void selectAllSpecies(boolean select) {
        TreeItem ti;
        Stack<TreeItem> items = new Stack<TreeItem>();
        TreeItem[] treeItemArray = this.checkboxTreeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ti = treeItemArray[n2];
            items.add(ti);
            ++n2;
        }
        while (!items.empty()) {
            ti = (TreeItem)items.pop();
            ti.setChecked(select);
            TreeItem[] treeItemArray2 = ti.getItems();
            int n3 = treeItemArray2.length;
            n = 0;
            while (n < n3) {
                TreeItem child = treeItemArray2[n];
                items.add(child);
                ++n;
            }
        }
    }

    private class ComponentLabelProvider
    extends LabelProvider {
        private ComponentLabelProvider() {
        }

        public String getText(Object element) {
            return ((ComponentTree)element).name;
        }
    }

    private class ComponentTree {
        String name;
        ComponentTree[] children = null;
        ComponentTree parent = null;

        private ComponentTree() {
        }
    }

    private class ComponentTreeContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private ComponentTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return ((ComponentTree)parentElement).children;
        }

        public Object getParent(Object element) {
            return ((ComponentTree)element).parent;
        }

        public boolean hasChildren(Object element) {
            return ((ComponentTree)element).children != null;
        }
    }

    private class SpeciesFilter
    extends ViewerFilter {
        String filter = "";
        Set<ComponentTree> nonVisibleSelected = new HashSet<ComponentTree>();
        Set<ComponentTree> toCheck = new HashSet<ComponentTree>();

        private SpeciesFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            ComponentTree ct = (ComponentTree)element;
            if (ct.name.toLowerCase().indexOf(this.filter.toLowerCase()) != -1) {
                if (this.nonVisibleSelected.contains(ct)) {
                    this.toCheck.add(ct);
                    this.nonVisibleSelected.remove(ct);
                }
                return true;
            }
            if (ct.children != null) {
                return true;
            }
            if (SpeciesSelectionWizardPage.this.checkboxTreeViewer.getChecked((Object)ct)) {
                this.nonVisibleSelected.add(ct);
            }
            return false;
        }

        void updateFilter(String name) {
            this.filter = name;
        }

        void updateSelected() {
            for (ComponentTree ct : this.toCheck) {
                SpeciesSelectionWizardPage.this.checkboxTreeViewer.setChecked((Object)ct, true);
            }
            this.toCheck.clear();
        }
    }
}

