/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core;

import java.io.StringReader;
import java_cup.runtime.Symbol;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.dom.Model;
import uk.ac.ed.inf.biopepa.core.dom.internal.BioPEPALexer;
import uk.ac.ed.inf.biopepa.core.dom.internal.BioPEPAParser;
import uk.ac.ed.inf.biopepa.core.dom.internal.BioPEPASymbolFactory;
import uk.ac.ed.inf.biopepa.core.dom.internal.ParserException;
import uk.ac.ed.inf.biopepa.core.interfaces.Solver;
import uk.ac.ed.inf.biopepa.core.sba.SBAModel;
import uk.ac.ed.inf.biopepa.core.sba.Solvers;

public class BioPEPA {
    public static Model parse(String source) throws ParserException, Exception {
        BioPEPASymbolFactory symbolFactory = new BioPEPASymbolFactory();
        BioPEPAParser parser = new BioPEPAParser(new BioPEPALexer(new StringReader(source), symbolFactory), symbolFactory);
        try {
            Symbol symbol = parser.parse();
            return (Model)symbol.value;
        }
        catch (Exception e) {
            if (e instanceof ParserException) {
                throw (ParserException)e;
            }
            throw e;
        }
    }

    public static ModelCompiler compile(Model model) {
        return new ModelCompiler(model);
    }

    public static SBAModel generateSBA(ModelCompiler compiledModel) {
        SBAModel model = new SBAModel(compiledModel);
        model.parseBioPEPA();
        return model;
    }

    public static String[] getSolvers() {
        return Solvers.getSolverList();
    }

    public static Solver getSolverInstance(String name) {
        return Solvers.getSolverInstance(name);
    }
}

