/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.analysis;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerMatrix
implements Cloneable {
    private int numRows = 0;
    private int numCols = 0;
    private Vector<int[]> matrix;
    public static final String newline = System.getProperty("line.separator");

    public IntegerMatrix(int rows, int cols) {
        this.numRows = rows;
        this.numCols = cols;
        this.matrix = new Vector(rows);
        int i = 0;
        while (i < this.numRows) {
            this.matrix.add(new int[cols]);
            ++i;
        }
    }

    public int getRowDimension() {
        return this.numRows;
    }

    public int getColumnDimension() {
        return this.numCols;
    }

    public int get(int row, int col) {
        int[] d = this.matrix.get(row);
        return d[col];
    }

    public void set(int row, int col, int value) {
        int[] d = this.matrix.get(row);
        d[col] = value;
    }

    public void add(int row, int col, int value) {
        int[] d = this.matrix.get(row);
        int n = col;
        d[n] = d[n] + value;
    }

    public void setRowToZero(int row) {
        int[] d = this.matrix.get(row);
        int i = 0;
        while (i < d.length) {
            d[i] = 0;
            ++i;
        }
    }

    public void setColumnToZero(int col) {
        int i = 0;
        while (i < this.numRows) {
            int[] row = this.matrix.get(i);
            row[col] = 0;
            ++i;
        }
    }

    public IntegerMatrix mult(IntegerMatrix m) {
        if (this.numCols != m.getRowDimension()) {
            System.out.println("Matrix multiplication failed, dimensions don't match: try AxB with A: " + this.numRows + "x" + this.numCols + " and B:" + m.getRowDimension() + "x" + m.getColumnDimension());
            return new IntegerMatrix(0, 0);
        }
        int cNumRows = this.numRows;
        int cNumCols = m.getColumnDimension();
        IntegerMatrix C = new IntegerMatrix(this.numRows, cNumCols);
        int[] Ai = null;
        int i = 0;
        while (i < cNumRows) {
            Ai = this.matrix.get(i);
            int j = 0;
            while (j < cNumCols) {
                int k = 0;
                while (k < this.numCols) {
                    C.add(i, j, Ai[k] * m.get(k, j));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return C;
    }

    public IntegerMatrix solveFourierMotzkin() {
        ArrayList<int[]> lminus = new ArrayList<int[]>();
        ArrayList<int[]> lplus = new ArrayList<int[]>();
        ArrayList<int[]> lneutral = new ArrayList<int[]>();
        ArrayList<int[]> lresult = new ArrayList<int[]>();
        int i = 0;
        while (i < this.numRows) {
            int[] v = new int[this.numRows + this.numCols];
            int[] row = this.matrix.get(i);
            int j = 0;
            while (j < this.numCols) {
                v[j] = row[j];
                ++j;
            }
            v[this.numCols + i] = 1;
            lneutral.add(v);
            ++i;
        }
        try {
            int position = this.selectposition(lneutral, 10000);
            int i2 = 0;
            while (i2 < this.numCols && -1 != position) {
                this.split(lneutral, lplus, lminus, position);
                this.addcombinations(lneutral, lplus, lminus, lresult, position);
                position = this.selectposition(lneutral, 10000);
                if (lneutral.size() > 10000) {
                    throw new Exception();
                }
                ++i2;
            }
            lresult.addAll(lneutral);
        }
        catch (Exception exception) {
            System.out.println("WARNING: invariant calculation artificially terminated, intermediate solution exceeds threshold of 10000");
            return this.reducedMatrix(lresult);
        }
        return this.reducedMatrix(lresult);
    }

    private int selectposition(ArrayList<int[]> lneutral, int threshold) throws Exception {
        int min = Integer.MAX_VALUE;
        int position = -1;
        int plus = 0;
        int minus = 0;
        int result = 0;
        int i = 0;
        while (i < this.numCols) {
            plus = 0;
            minus = 0;
            int j = 0;
            while (j < lneutral.size()) {
                int[] v = lneutral.get(j);
                if (v[i] < 0) {
                    ++minus;
                }
                if (v[i] > 0) {
                    ++plus;
                }
                ++j;
            }
            if (minus != 0 || plus != 0) {
                result = minus * plus;
                if (result < min) {
                    min = result;
                    position = i;
                }
                if (1 >= result) {
                    position = i;
                    i = this.numCols;
                }
            }
            ++i;
        }
        if (result > threshold) {
            throw new Exception();
        }
        return position;
    }

    private IntegerMatrix reducedMatrix(ArrayList<int[]> lneutral) {
        IntegerMatrix result = new IntegerMatrix(lneutral.size(), this.numRows);
        if (lneutral.size() == 0) {
            return result;
        }
        Iterator<int[]> it = lneutral.iterator();
        int[] v = null;
        int r = 0;
        while (it.hasNext()) {
            v = it.next();
            int i = 0;
            while (i < this.numRows) {
                result.set(r, i, v[this.numCols + i]);
                ++i;
            }
            ++r;
        }
        return this.baseOfRowVectors(result);
    }

    private IntegerMatrix baseOfRowVectors(IntegerMatrix input) {
        int m = input.getRowDimension();
        int n = input.getColumnDimension();
        int[] support = new int[m];
        int[] base = new int[m];
        int[] covered = new int[n];
        int selected = 0;
        if (1 == m) {
            return input.clone();
        }
        Matrix mat = new Matrix(m, n);
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                if (input.get(i, j) != 0) {
                    int n2 = i;
                    support[n2] = support[n2] + 1;
                    mat.set(i, j, (double)input.get(i, j));
                }
                ++j;
            }
            ++i;
        }
        int rank = mat.rank();
        if (m == rank) {
            return input.clone();
        }
        int pos = 0;
        int j = 0;
        while (j < n) {
            if (covered[j] <= 0 && (pos = this.findRowWithMinimumSupport(m, support, base, j, input)) >= 0) {
                base[pos] = 1;
                ++selected;
                int k = 0;
                while (k < n) {
                    if (input.get(pos, k) != 0) {
                        int n3 = k;
                        covered[n3] = covered[n3] + 1;
                    }
                    ++k;
                }
            }
            ++j;
        }
        while (rank != selected) {
            pos = this.findRowWithMinimumSupport(m, support, base);
            if (pos > 0) {
                Matrix matrix;
                int mrank;
                base[pos] = 1;
                if (++selected == (mrank = (matrix = this.extractSelectedRows2(input, m, n, base, selected)).rank())) {
                    int k = 0;
                    while (k < n) {
                        if (input.get(pos, k) != 0) {
                            int n4 = k;
                            covered[n4] = covered[n4] + 1;
                        }
                        ++k;
                    }
                    continue;
                }
                base[pos] = -1;
                --selected;
                continue;
            }
            if (rank == selected) continue;
            System.out.println("IntegerMatrix.baseOfRowVectors: no vectors left but rank " + rank + " does not match selection " + selected);
            rank = selected;
        }
        System.out.println("base of Row vectors: base has dimension " + selected);
        return this.extractSelectedRows(input, m, n, base, selected);
    }

    private IntegerMatrix extractSelectedRows(IntegerMatrix input, int m, int n, int[] base, int selected) {
        IntegerMatrix result = new IntegerMatrix(selected, n);
        int pos = 0;
        int i = 0;
        while (i < m) {
            if (base[i] == 1) {
                int j = 0;
                while (j < n) {
                    result.set(pos, j, input.get(i, j));
                    ++j;
                }
                ++pos;
            }
            ++i;
        }
        System.out.println("finally returned: " + pos + " for selected " + selected);
        return result;
    }

    private Matrix extractSelectedRows2(IntegerMatrix input, int m, int n, int[] base, int selected) {
        Matrix result = new Matrix(selected, n);
        int pos = 0;
        int i = 0;
        while (i < m) {
            if (base[i] == 1) {
                int j = 0;
                while (j < n) {
                    result.set(pos, j, (double)input.get(i, j));
                    ++j;
                }
                ++pos;
            }
            ++i;
        }
        return result;
    }

    private int findRowWithMinimumSupport(int m, int[] support, int[] base) {
        int min = Integer.MAX_VALUE;
        int pos = -1;
        int i = 0;
        while (i < m) {
            if (support[i] > 0 && support[i] < min && base[i] == 0) {
                min = support[i];
                pos = i;
            }
            ++i;
        }
        return pos;
    }

    private int findRowWithMinimumSupport(int m, int[] support, int[] base, int column, IntegerMatrix input) {
        int min = Integer.MAX_VALUE;
        int pos = -1;
        int i = 0;
        while (i < m) {
            if (support[i] > 0 && support[i] < min && base[i] == 0 && input.get(i, column) != 0) {
                min = support[i];
                pos = i;
            }
            ++i;
        }
        return pos;
    }

    private void addcombinations(ArrayList<int[]> lneutral, ArrayList<int[]> lplus, ArrayList<int[]> lminus, ArrayList<int[]> lresult, int position) {
        if (lminus.isEmpty()) {
            lplus.clear();
            return;
        }
        if (lplus.isEmpty()) {
            lminus.clear();
            return;
        }
        Iterator<int[]> itminus = lminus.iterator();
        Iterator<int[]> itplus = null;
        while (itminus.hasNext()) {
            int[] vm = itminus.next();
            for (int[] vp : lplus) {
                int gcd = IntegerMatrix.euklidGCD(vm[position], vp[position]);
                int scalep = Math.abs(vm[position]) / gcd;
                int scalem = vp[position] / gcd;
                int[] vn = new int[vm.length];
                if (vm[position] * scalem + vp[position] * scalep != 0) {
                    throw new RuntimeException("Calculation of combinations is wrong");
                }
                boolean finished = true;
                int i = 0;
                while (i < vm.length) {
                    vn[i] = vm[i] * scalem + vp[i] * scalep;
                    if (i < this.numCols && vn[i] != 0) {
                        finished = false;
                    }
                    ++i;
                }
                this.normalizeWithGCD(vn, 0);
                if (finished) {
                    this.add(lresult, vn, 0);
                    continue;
                }
                this.add(lneutral, vn, 0);
            }
        }
        lminus.clear();
        lplus.clear();
    }

    private void add(ArrayList<int[]> lneutral, int[] vn, int startposition) {
        if (this.containsVector(lneutral, vn, startposition)) {
            return;
        }
        lneutral.add(vn);
    }

    private boolean containsVector(ArrayList<int[]> lneutral, int[] vn, int startposition) {
        int i = 0;
        while (i < lneutral.size()) {
            int[] v = lneutral.get(i);
            boolean ok = false;
            int j = startposition;
            while (j < v.length) {
                if (v[j] != vn[j]) {
                    ok = true;
                    j = v.length;
                }
                ++j;
            }
            if (!ok) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int myGCD(int a, int b, boolean notsure) {
        if (b == 0) {
            return a;
        }
        return this.myGCD(b, a % b, notsure);
    }

    private static int euklidGCD(int a, int b) {
        a = Math.abs(a);
        b = Math.abs(b);
        while (b != 0) {
            int t = b;
            b = a % b;
            a = t;
        }
        return a;
    }

    private void normalizeWithGCD(int[] vn, int startposition) {
        int gcd = 0;
        int i = startposition;
        while (i < vn.length) {
            if (vn[i] != 0) {
                gcd = gcd == 0 ? Math.abs(vn[i]) : IntegerMatrix.euklidGCD(gcd, vn[i]);
            }
            ++i;
        }
        if (gcd != 0 && 1 != gcd) {
            i = startposition;
            while (i < vn.length) {
                if (vn[i] != 0) {
                    int n = i;
                    vn[n] = vn[n] / gcd;
                }
                ++i;
            }
        }
    }

    private void split(ArrayList<int[]> lneutral, ArrayList<int[]> lplus, ArrayList<int[]> lminus, int column) {
        int i = 0;
        while (i < lneutral.size()) {
            int[] v = lneutral.get(i);
            if (v[column] < 0) {
                lminus.add(v);
                lneutral.remove(i);
                continue;
            }
            if (v[column] > 0) {
                lplus.add(v);
                lneutral.remove(i);
                continue;
            }
            ++i;
        }
    }

    public IntegerMatrix transpose() {
        IntegerMatrix result = new IntegerMatrix(this.numCols, this.numRows);
        int[] row = null;
        int i = 0;
        while (i < this.numRows) {
            row = this.matrix.get(i);
            int j = 0;
            while (j < this.numCols) {
                result.set(j, i, row[j]);
                ++j;
            }
            ++i;
        }
        return result;
    }

    public IntegerMatrix clone() {
        IntegerMatrix result = new IntegerMatrix(this.numRows, this.numCols);
        int[] row = null;
        int i = 0;
        while (i < this.numRows) {
            row = this.matrix.get(i);
            int j = 0;
            while (j < this.numCols) {
                result.set(i, j, row[j]);
                ++j;
            }
            ++i;
        }
        return result;
    }

    public boolean equals(IntegerMatrix m) {
        return this.compare(m) == 0;
    }

    public int compare(IntegerMatrix m) {
        if (this.numCols != m.getColumnDimension() || this.numRows != m.getRowDimension()) {
            throw new RuntimeException("Cannot compare matrices of different dimensions");
        }
        int[] row = null;
        int result = 0;
        int i = 0;
        while (i < this.numRows) {
            row = this.matrix.get(i);
            int j = 0;
            while (j < this.numCols) {
                if (row[j] != m.get(i, j)) {
                    switch (result) {
                        case -1: {
                            if (row[j] <= m.get(i, j)) break;
                            throw new RuntimeException("Matrices are not comparable");
                        }
                        case 0: {
                            result = row[j] < m.get(i, j) ? -1 : 1;
                            break;
                        }
                        case 1: {
                            if (row[j] >= m.get(i, j)) break;
                            throw new RuntimeException("Matrices are not comparable");
                        }
                        default: {
                            throw new RuntimeException("Reaching unreachable default case");
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public boolean isZeroMatrix() {
        int[] row = null;
        int i = 0;
        while (i < this.numRows) {
            row = this.matrix.get(i);
            int j = 0;
            while (j < this.numCols) {
                if (row[j] != 0) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public boolean isIdentityMatrix() {
        int[] row = null;
        int i = 0;
        while (i < this.numRows) {
            row = this.matrix.get(i);
            int j = 0;
            while (j < this.numCols) {
                if (i == j ? 1 != row[j] : row[j] != 0) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public String printMatrix() {
        String result = "Content of an " + this.numRows + " x " + this.numCols + " matrix:" + newline;
        int i = 0;
        while (i < this.numRows) {
            result = String.valueOf(result) + "row " + i + ": ";
            int j = 0;
            while (j < this.numCols) {
                result = String.valueOf(result) + " " + this.get(i, j);
                ++j;
            }
            result = String.valueOf(result) + newline;
            ++i;
        }
        return result;
    }
}

