/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.analysis;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ed.inf.biopepa.core.compiler.ActionData;
import uk.ac.ed.inf.biopepa.core.compiler.CompartmentData;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledDynamicComponent;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpression;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpressionVisitor;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledFunction;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledNumber;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledOperatorNode;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledSystemVariable;
import uk.ac.ed.inf.biopepa.core.compiler.ComponentData;
import uk.ac.ed.inf.biopepa.core.compiler.ComponentNode;
import uk.ac.ed.inf.biopepa.core.compiler.CooperationNode;
import uk.ac.ed.inf.biopepa.core.compiler.FunctionalRateData;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.PrefixData;
import uk.ac.ed.inf.biopepa.core.compiler.ProblemInfo;
import uk.ac.ed.inf.biopepa.core.compiler.SystemEquationNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReactantRateParticipationCheck {
    private ModelCompiler compiledModel;
    private SystemEquationVisitor sev = new SystemEquationVisitor();
    private ReactantParticipantVisitor rrp = new ReactantParticipantVisitor();
    private List<ProblemInfo> problems = new ArrayList<ProblemInfo>();

    private ReactantRateParticipationCheck() {
    }

    static List<ProblemInfo> checkActions(ModelCompiler compiledModel) {
        ReactantRateParticipationCheck rrpc = new ReactantRateParticipationCheck();
        rrpc.compiledModel = compiledModel;
        rrpc.sev.visit(compiledModel.getSystemEquation());
        return rrpc.problems;
    }

    private class ReactantParticipantVisitor
    extends CompiledExpressionVisitor {
        String reactant;

        private ReactantParticipantVisitor() {
        }

        public boolean visit(CompiledDynamicComponent component) {
            return component.getName().equals(this.reactant);
        }

        public boolean visit(CompiledFunction function) {
            boolean found = false;
            for (CompiledExpression ce : function.getArguments()) {
                boolean bl = found = found || ce.accept(this);
            }
            return found;
        }

        public boolean visit(CompiledNumber number) {
            return false;
        }

        public boolean visit(CompiledOperatorNode operator) {
            return operator.getLeft().accept(this) || operator.getRight().accept(this);
        }

        public boolean visit(CompiledSystemVariable variable) {
            return false;
        }
    }

    private class SystemEquationVisitor {
        private SystemEquationVisitor() {
        }

        void visit(SystemEquationNode node) {
            if (node instanceof ComponentNode) {
                this.visit((ComponentNode)node);
            } else if (node instanceof CooperationNode) {
                this.visit(((CooperationNode)node).getLeft());
                this.visit(((CooperationNode)node).getRight());
            } else {
                throw new IllegalArgumentException("Unrecognised subclass of SystemEquationNode.");
            }
        }

        void visit(ComponentNode node) {
            ComponentData cd = ReactantRateParticipationCheck.this.compiledModel.getComponentData(node.getComponent());
            CompartmentData compartmentData = node.getCompartment();
            PrefixData[] prefixDataArray = cd.getPrefixes();
            int n = prefixDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                FunctionalRateData frd;
                ActionData ad;
                PrefixData pd = prefixDataArray[n2];
                if (pd instanceof ActionData && (ad = (ActionData)pd).getOperator().equals((Object)PrefixData.Operator.REACTANT) && !(frd = ReactantRateParticipationCheck.this.compiledModel.getFunctionalRate(pd.getFunction())).isPredefinedLaw() && (ad.getLocations().size() == 0 || compartmentData == null || ad.getLocations().contains(compartmentData.getName()))) {
                    ((ReactantRateParticipationCheck)ReactantRateParticipationCheck.this).rrp.reactant = node.getName();
                    if (!frd.getRightHandSide().accept(ReactantRateParticipationCheck.this.rrp)) {
                        ProblemInfo pi = new ProblemInfo("The rate " + pd.getFunction() + " does not rely on " + ((ReactantRateParticipationCheck)ReactantRateParticipationCheck.this).rrp.reactant + ". Population count could decrease below zero.", pd);
                        pi.severity = ProblemInfo.Severity.WARNING;
                        ReactantRateParticipationCheck.this.problems.add(pi);
                    }
                }
                ++n2;
            }
        }
    }
}

