/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.compiler;

import uk.ac.ed.inf.biopepa.core.compiler.Data;
import uk.ac.ed.inf.biopepa.core.compiler.ProblemKind;
import uk.ac.ed.inf.biopepa.core.compiler.PropertySetterException;
import uk.ac.ed.inf.biopepa.core.dom.ASTNode;
import uk.ac.ed.inf.biopepa.core.dom.PropertyLiteral;

public class CompartmentData
extends Data {
    private double volume = Double.NaN;
    private double stepSize = Double.NaN;
    private Type type = Type.COMPARTMENT;
    private String parent = null;

    public double getVolume() {
        return this.volume;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public Type getType() {
        return this.type;
    }

    void setParent(String parent) {
        this.parent = parent;
    }

    public String getParent() {
        return this.parent;
    }

    protected CompartmentData(String name, ASTNode declaration) {
        super(name, declaration);
    }

    public void setProperty(PropertyLiteral literal, double result) throws PropertySetterException {
        if (literal.getKind() == PropertyLiteral.Kind.SIZE) {
            if (result < 0.0) {
                throw new IllegalArgumentException();
            }
            this.volume = result;
            return;
        }
        if (literal.getKind() == PropertyLiteral.Kind.H) {
            if (result < 0.0) {
                throw new IllegalArgumentException();
            }
            this.stepSize = result;
            return;
        }
        throw new PropertySetterException(ProblemKind.ILLEGAL_PROPERTY);
    }

    public void setProperty(PropertyLiteral literal, PropertyLiteral result) throws PropertySetterException {
        if (literal.getKind() != PropertyLiteral.Kind.TYPE) {
            throw new PropertySetterException(ProblemKind.ILLEGAL_PROPERTY);
        }
        if (result.getKind() == PropertyLiteral.Kind.COMPARTMENT) {
            this.type = Type.COMPARTMENT;
        } else if (result.getKind() == PropertyLiteral.Kind.MEMBRANE) {
            this.type = Type.MEMBRANE;
        } else {
            throw new PropertySetterException(ProblemKind.ILLEGAL_PROPERTY);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Compartment] Name=");
        sb.append(this.getName());
        sb.append(",Volume=");
        sb.append(this.volume);
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        COMPARTMENT("Compartment", 3),
        MEMBRANE("Membrane", 2);

        private String name;
        private int dimensions;

        private Type(String name, int dimensions) {
            this.name = name;
            this.dimensions = dimensions;
        }

        public String toString() {
            return this.name;
        }

        public int getDimensions() {
            return this.dimensions;
        }
    }
}

